% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_ROCit.R
\name{print.rocit}
\alias{print.rocit}
\title{Print \code{rocit} Object}
\usage{
\method{print}{rocit}(x, ... = NULL)
}
\arguments{
\item{x}{An object of class \code{"rocit"},
returned by \code{\link{rocit}} function.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\description{
Print \code{rocit} Object
}
\examples{
data("Diabetes")
roc_empirical <- rocit(score = Diabetes$chol, class = Diabetes$dtest,
                       negref = "-") # default method empirical
roc_binormal <- rocit(score = Diabetes$chol, class = Diabetes$dtest,
                     negref = "-", method = "bin")

# ---------------------
print(roc_empirical)
print(roc_binormal)


}
\seealso{
\code{\link{rocit}}, \code{\link{summary.rocit}}
}
