% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{K_zero}
\alias{K_zero}
\alias{K_lin}
\alias{K_soc}
\alias{K_psd}
\alias{K_expp}
\alias{K_expd}
\alias{K_powp}
\alias{K_powd}
\title{Cone Constructors}
\usage{
K_zero(size)

K_lin(size)

K_soc(sizes)

K_psd(sizes)

K_expp(size)

K_expd(size)

K_powp(alpha)

K_powd(alpha)
}
\arguments{
\item{size}{a integer giving the size of the cone, 
if the dimension of the cones is fixed 
(i.e. \code{zero}, \code{lin}, \code{expp}, \code{expd})
the number of cones is sufficient to define the dimension
of the product cone.}

\item{sizes}{a integer giving the sizes of the cones,
if the dimension of the cones is not fixed 
(i.e. \code{soc}, \code{psd}) we
have to define the sizes of each single cone.}

\item{alpha}{a numeric vector giving the \code{alphas}
for the (dual) power cone.}
}
\description{
Constructor functions for the different cone
    types. Currently \pkg{ROI} supports eight different types
    of cones.
    \itemize{
    \item \code{Zero cone} \deqn{ \mathcal{K}_{\mathrm{zero}} = \{0\} }
    \item \code{Nonnegative (linear) cone} \deqn{ \mathcal{K}_{\mathrm{lin}} = \{x|x \geq 0 \} }
    \item \code{Second-order cone} \deqn{ \mathcal{K}_{\mathrm{soc}} = \left\{(t, x) \ | \ ||x||_2 \leq t, x \in R^n, t \in R \right\} }
    \item \code{Positive semidefinite cone} \deqn{ \mathcal{K}_{\mathrm{psd}} = \left\{ X \ | \ min(eig(X)) \geq 0, \ X = X^T, \ X \in R^{n \times n} \right\} }
    \item \code{Exponential cone} \deqn{ \mathcal{K}_{\mathrm{expp}} = \left\{(x,y,z) \ | \ y e^{\frac{x}{y}} \leq z, \ y > 0 \right\} }
    \item \code{Dual exponential cone} \deqn{ \mathcal{K}_{\mathrm{expd}} = \left\{(u,v,w) \ | \ -u e^{\frac{v}{u}} \leq e w, u < 0 \right\} }
    \item \code{Power cone} \deqn{ \mathcal{K}_{\mathrm{powp}} = \left\{(x,y,z) \ | \ x^\alpha * y^{(1-\alpha)} \geq |z|, \ x \geq 0, \ y \geq 0 \right\} }
    \item \code{Dual power cone} \deqn{ \mathcal{K}_{\mathrm{powd}} = \left\{ (u,v,w) \ | \ \left(\frac{u}{\alpha}\right)^\alpha * \left(\frac{v}{(1-\alpha)}\right)^{(1-\alpha)} \geq |w|, \ u \geq 0, \ v \geq 0 \right\} }
    }
}
\examples{
K_zero(3) ## 3 equality constraints
K_lin(3)  ## 3 constraints where the slack variable s lies in the linear cone
}
