% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SortinoRatio_SE.R
\name{SortinoRatio.SE}
\alias{SortinoRatio.SE}
\title{Standard Error Estimate for Sortino Ratio of Returns}
\usage{
SortinoRatio.SE(data, MAR = 0, threshold = c("mean", "const")[1],
  se.method = c("IFiid", "IFcor", "IFcorAdapt", "IFcorPW", "BOOTiid",
  "BOOTcor")[c(1, 3)], cleanOutliers = FALSE,
  fitting.method = c("Exponential", "Gamma")[1], ...)
}
\arguments{
\item{data}{Data of returns for one or multiple assets or portfolios.}

\item{MAR}{Minimum Acceptable Return for threshold.}

\item{threshold}{Parameter to determine whether we use a "mean" or "const" threshold.}

\item{se.method}{A character string indicating which method should be used to compute
the standard error of the estimated standard deviation. One or a combination of:
\code{"IFiid"} (default), \code{"IFcor"}, \code{"IFcorPW"}, \code{"IFcorAdapt"} (default),
\code{"BOOTiid"} or \code{"BOOTcor"}.}

\item{cleanOutliers}{Boolean variable to indicate whether the pre-whitenning of the influence functions TS should be done through a robust filter.}

\item{fitting.method}{Distribution used in the standard errors computation. Should be one of "Exponential" (default) or "Gamma".}

\item{...}{Additional parameters.}
}
\value{
A vector or a list depending on \code{se.method}.
}
\description{
\code{SortinoRatio.SE} computes the standard error of the Sortino ratio of the returns.
}
\details{
Sortino proposed an improvement on the Sharpe Ratio to better account for
skill and excess performance by using only downside semivariance as the
measure of risk.

Sortino contends that risk should be measured in terms of not meeting the
investment goal.  This gives rise to the notion of \dQuote{Minimum
Acceptable Return} or MAR.  All of Sortino's proposed measures include the
MAR, and are more sensitive to downside or extreme risks than measures that
use volatility(standard deviation of returns) as the measure of risk.

Choosing the MAR carefully is very important, especially when comparing
disparate investment choices.  If the MAR is too low, it will not adequately
capture the risks that concern the investor, and if the MAR is too high, it
will unfavorably portray what may otherwise be a sound investment.  When
comparing multiple investments, some papers recommend using the risk free
rate as the MAR.  Practitioners may wish to choose one MAR for consistency,
several standardized MAR values for reporting a range of scenarios, or a MAR
customized to the objective of the investor.
}
\examples{
# Loading data from PerformanceAnalytics
data(edhec, package = "PerformanceAnalytics")
class(edhec)
# Changing the data colnames
names(edhec) = c("CA", "CTA", "DIS", "EM", "EMN",
                 "ED", "FIA", "GM", "LS", "MA",
                 "RV", "SS", "FOF")
# Computing the standard errors for
# the two influence functions based approaches
SortinoRatio.SE(edhec[,"CA"], se.method=c("IFiid","IFcorAdapt"),
                cleanOutliers=FALSE,
                fitting.method=c("Exponential", "Gamma")[1])

}
\author{
Xin Chen, \email{chenx26@uw.edu}

Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
