% $Id: rs11-RPPASet-class.Rd

\name{RPPASet-class}
\alias{RPPASet-class}
\alias{RPPASet}
\alias{normalize,RPPASet-method}
\alias{summary,RPPASet-method}
\alias{write.summary,RPPASet-method}
\alias{is.RPPASet}
\docType{class}
\title{Class \dQuote{RPPASet}}
\description{
  The RPPASet class fits rppaspace curves to an entire directory of
  reverse-phase protein array experiments.
}
\usage{
RPPASet(path,
        designparams,
        fitparams,
        spatialparams=NULL,
        normparams,
        doprefitqc=FALSE,
	    parallelClusterSize,
		residualsrotation = as.integer(0),
	    warningsFileName="warnings.txt",
	    printTimings=TRUE
)
is.RPPASet(x)
\S4method{normalize}{RPPASet}(object,
          \dots)
\S4method{summary}{RPPASet}(object,
        onlynormqcgood=ran.prefitqc(object),
        \dots)
\S4method{write.summary}{RPPASet}(object,
              path,
              prefix="rppaspace",
              graphs=TRUE,
			  createcombinedoutputimage=FALSE,
              imagedir=NULL,
              onlynormqcgood=ran.prefitqc(object),
              imageextension=".tif",
              imagerotation=as.integer(0),
              residualsrotation=as.integer(0),
			  majorXDivisions = object@design@majorXDivisions, 
			  majorYDivisions = object@design@majorYDivisions,
              \dots)
}
\arguments{
  \item{path}{character string specifying a directory. In the case of
    the \code{RPPASet} generator, it specifies the directory containing
    the quantification files (.txt) to be processed. In the case of the
    \code{write.summary} method, it specifies the directory where output
    should be stored.}
  \item{designparams}{object of class \code{RPPADesignParams} describing
    features common to all quantification files}
  \item{fitparams}{object of class \code{RPPAFitParams} containing
    parameters used to fit the rppaspace model}
  \item{spatialparams}{object of class \code{RPPASpatialParams} containing
    parameters used to perform spatial adjustment, or \code{NULL}}
  \item{normparams}{object of class \code{RPPANormParams} containing
    parameters used to normalize the concentrations}
  \item{doprefitqc}{logical scalar. If \code{TRUE}, performs pre-fit quality
    control.}
  \item{printTimings}{TRUE/FALSE whether or not to print out the time taken
	as the method is run.  Used for performance debugging purposes.}
  \item{object}{object of class \code{RPPASet}}
  \item{prefix}{character string used as a filename prefix on files generated by
    the write.summary method.}
  \item{graphs}{logical scalar. If \code{TRUE}, produces fit graphs.}
  \item{createcombinedoutputimage}{logical scalar. If \code{TRUE}, produces output png
    consisting of combined png images and scaled version of original slide image.}
  \item{imagedir}{character string specifying the directory containing the
    images corresponding to the quantification files}
  \item{imageextension}{character string specifying extension to use when searching
	for images matching the slide file names.}
  \item{imagerotation}{numeric scalar containing 90 degree value to rotate 
	the input image by when appending it to the generated graphs 
	in the combined output image file for each slide.}
  \item{residualsrotation}{numeric scalar containing 90 degree value to rotate 
	the generated residuals image by when generating the output graphic.  
	This should be used if the layout of the information in the input txt 
	file does not match the orientation of the slide input image.}
  \item{majorXDivisions}{integer to describe distance between grid lines on the X axis of the R2 residuals plot.  Defaults to 10 if NA or invalid value provided.}
  \item{majorYDivisions}{integer to describe distance between grid lines on the Y axis of the R2 residuals plot.  Defaults to 10 if NA or invalid value provided.}
  \item{warningsFileName}{character string specifying file to append any warnings 
	generated by this function.}
  \item{onlynormqcgood}{logical scalar. If \code{TRUE}, filters the slides
    to be normalized according to their pre-fit quality control scores.}
  \item{x}{object of class \code{RPPASet}}
  \item{parallelClusterSize}{Number of parallel cores to use when processing.}
  \item{\dots}{extra arguments for generic or plotting routines}
}
\details{
  Quantify all the slides in a directory using \code{RPPASet} generator.
  This returns an object containing slide data and fits for each slide.
  Typically this is followed by a call to \code{write.summary} to write
  the resulting quantifications and diagnostic plots to a directory.

  Potentially generates multiple \acronym{CSV} and \acronym{TSV} files: 
  one for the raw concentrations (rppaspace_conc_raw.csv"), 
  one for the \eqn{R^2} statistics (rppaspace_ss_ratio.csv),
  and one for the normalized concentrations (rppaspace_conc_norm_[norm_method].csv);
  a fourth file containing the goodness of fit probabilities 
  (rppaspace_prefit_qc.csv) may be present if pre-fit QC analysis was requested.
  If spatial adjustments were requested, a \acronym{TSV} file 
  (spatial_adjustments.tsv) will be created.
  If positive control dilution series have been declared as Noise or 
  PosCtrl-Noise points in the design file, an additional \acronym{CSV} file 
  of noise statistics will be created (rppaspace_noise.csv). 
  If prefit QC analysis was done and/or noise qc metric were created, a
  combined qc metrics file will be created (rppaspace_combined_qc.csv) as well.
  Additionally, a \acronym{TSV} file detailing completion of each stage of 
  processing for each slide is produced (rppaspace_summary.tsv).
  
  If \code{imagedir} is \code{NULL}, the directory is assumed to be a sibling
  directory to \code{path} named "tif". If \code{graphs} is \code{TRUE},
  two \acronym{PNG} files containing output graphs are created per antibody.
  The original slide image is merged with these output PNG graph files, 
  generating an additional \acronym{JPEG} file per antibody.
}
\section{Objects from the Class}{
  Although objects of the class can (in theory) be created by a direct call
  to \link[methods]{new}, the only realistic method is to use the
  \code{RPPASet} generator function.
}
\section{Slots}{
  \describe{
    \item{\code{call}:}{object of class \code{call} specifying the function
      call that was used during construction}
    \item{\code{version}:}{character string containing the version of this
      package used to construct the object}
    \item{\code{design}:}{object of class \code{RPPADesignParams}, common to all
      the slides}
    \item{\code{errorsFileName}:}{character string holding the name of the file
	  to which to write out error messages generated during processing.}
    \item{\code{warningsFileName}:}{character string holding the name of the file
	  to which to write out warning messages generated during processing.}
    \item{\code{rppas}:}{array of objects of class \code{RPPA}}
    \item{\code{spatialparams}:}{object of class \code{RPPASpatialParams}
      that was used to perform spatial adjustment, or \code{NULL}}
    \item{\code{prefitqcs}:}{array of objects of class
      \code{RPPAPreFitQCParams}}
    \item{\code{fitparams}:}{object of class \code{RPPAFitParams} that was
      used to construct the model fits}
    \item{\code{normparams}:}{object of class \code{RPPANormalizationParams}
      used to normalize the raw concentrations}
    \item{\code{fits}:}{array of fitted objects of class \code{RPPAFit}}
    \item{\code{completed}:}{logical matrix specifying stage completion
      for each slide}
  }
}
\section{Methods}{
  \describe{
    \item{normalize}{
      \code{signature(object = "RPPASet")}:\cr
      Assembles matrix of concentrations from all fits in object,
      using the object's normalization settings.}
    \item{summary}{
      \code{signature(object = "RPPASet")}:\cr
      Creates an object of class \code{RPPASetSummary}.}
    \item{write.summary}{
      \code{signature(object = "RPPASet")}:\cr
      Writes a record of the entire RPPASet, including fitted values,
      residuals, and images of the processed slides.}
  }
}
\value{
  The \code{RPPASet} generator returns an object of class \code{RPPASet}.

  The \code{is.RPPASet} method returns \code{TRUE} if its
  argument is an object of class \code{RPPASet}.

  The \code{summary} method returns an object of class \code{RPPASetSummary}.

  The \code{write.summary} method invisibly returns \code{NULL}.
}
\author{
  Kevin R. Coombes \email{coombes.3@osu.edu},
  P. Roebuck \email{paul_roebuck@comcast.net},
  James M. Melott \email{jmmelott@mdanderson.org}
}
\seealso{
  \code{\link{RPPA}},
  \code{\link{RPPADesignParams}},
  \code{\link{RPPAFit}},
  \code{\link{RPPASetSummary}}
}

\keyword{classes}
\keyword{models}
\keyword{nonlinear}
\keyword{nonparametric}
\keyword{regression}
\keyword{robust}

