% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{subsequentRun,RPhosFate-method}
\alias{subsequentRun,RPhosFate-method}
\alias{subsequentRun}
\title{Subsequent run}
\usage{
\S4method{subsequentRun}{RPhosFate}(
  x,
  substance = "PP",
  erosionPrerequisites = FALSE,
  erosion = FALSE,
  emission = FALSE,
  transportPrerequisites = FALSE,
  transportCalcOrder = FALSE
)
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}

\item{substance}{A character string specifying the substance to calculate.}

\item{erosionPrerequisites}{A logical scalar specifying if
\code{\link{erosionPrerequisites}} is called.}

\item{erosion}{A logical scalar specifying if \code{\link{erosion}} is called.}

\item{emission}{A logical scalar specifying if \code{\link{emission}} is called. It is
never called with \code{substance = "SS"} though.}

\item{transportPrerequisites}{A logical scalar specifying if
\code{\link{transportPrerequisites}} is called.}

\item{transportCalcOrder}{A logical scalar specifying if
\code{\link{transportCalcOrder}} is called.}
}
\value{
An S4 \code{\linkS4class{RPhosFate}} river catchment object and side effects in
the form of raster files.
}
\description{
Calls \code{\link{transport}} for the specified substance and optionally
\code{\link{erosionPrerequisites}}, \code{\link{erosion}}, \code{\link{emission}},
\code{\link{transportPrerequisites}} and/or \code{\link{transportCalcOrder}} beforehand.
}
\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)
# presupposed method call
x <- firstRun(x, "SS")

x <- subsequentRun(x, "PP")}

}
\seealso{
\code{\link{firstRun}}
}
