% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{calibrationQuality,RPhosFate-method}
\alias{calibrationQuality,RPhosFate-method}
\alias{calibrationQuality}
\title{Calibration quality}
\usage{
\S4method{calibrationQuality}{RPhosFate}(x, substance, col)
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}

\item{substance}{A character string specifying the substance to calculate.}

\item{col}{A character string specifying the calibration data column with the
respective substance river loads.}
}
\value{
A named numeric vector containing the assessed metrics along with the
in-channel retention ratio (one minus sum of \emph{xxt} at catchment outlet(s)
divided by sum of \emph{xxt_inp}).
}
\description{
Assesses the model's calibration quality with the help of the pairwise
complete modelled as well as observed loads and the following metrics:
\itemize{
\item \emph{NSE:} Nash-Sutcliffe Efficiency
\item \emph{mNSE:} Modified Nash-Sutcliffe Efficiency (\code{j = 1})
\item \emph{KGE:} Modified Kling-Gupta Efficiency
\item \emph{RMSE:} Root Mean Square Error
\item \emph{PBIAS:} Percent Bias
\item \emph{RSR:} Ratio of the RMSE to the standard deviation of the observations
\item \emph{RCV:} Ratio of the coefficients of variation
\item \emph{GMRAE:} Geometric Mean Relative Absolute Error
\item \emph{MdRAE:} Median Relative Absolute Error
}

In addition, a scatter plot with the observed river loads on the x- and the
modelled river loads on the y-axis is displayed and provides a visual
impression of the model performance. Other elements of this plot are an
identity line (solid) and plus/minus 30\% deviation lines (dashed).
}
\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)
# presupposed method calls
x <- firstRun(x, "SS")
x <- snapGauges(x)

calibrationQuality(x, "SS", "SS_load")}

}
\references{
\cite{Nash, J.E., Sutcliffe, J.V., 1970. River flow forecasting through
conceptual models part I – a discussion of principles. Journal of Hydrology
10, 282–290. https://doi.org/10.1016/0022-1694(70)90255-6}

\cite{Legates, D.R., McCabe Jr., G.J., 1999. Evaluating the use of
“goodness-of-fit” measures in hydrologic and hydroclimatic model validation.
Water Resources Research 35, 233–241. https://doi.org/10.1029/1998WR900018}

\cite{Kling, H., Fuchs, M., Paulin, M., 2012. Runoff conditions in the upper
Danube basin under an ensemble of climate change scenarios. Journal of
Hydrology 424–425, 264–277. https://doi.org/10.1016/j.jhydrol.2012.01.011}

\cite{Moriasi, D.N., Arnold, J.G., Van Liew, M.W., Bingner, R.L., Harmel,
R.D., Veith, T.L., 2007. Model evaluation guidelines for systematic
quantification of accuracy in watershed simulations. Transactions of the
ASABE 50, 885–900.}
}
\seealso{
\code{\link{snapGauges}}, \code{\link{autoCalibrate}}, \code{\link{autoCalibrate2}}
}
