% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quote.R
\name{quote}
\alias{quote}
\alias{dbQuoteString,PqConnection,character-method}
\alias{dbQuoteString,PqConnection,SQL-method}
\alias{dbQuoteIdentifier,PqConnection,character-method}
\alias{dbQuoteIdentifier,PqConnection,SQL-method}
\alias{dbQuoteIdentifier,PqConnection,Id-method}
\alias{dbUnquoteIdentifier,PqConnection,SQL-method}
\alias{dbQuoteLiteral}
\alias{dbQuoteLiteral,PqConnection,logical-method}
\alias{dbQuoteLiteral,PqConnection,integer-method}
\alias{dbQuoteLiteral,PqConnection,numeric-method}
\alias{dbQuoteLiteral,PqConnection,factor-method}
\alias{dbQuoteLiteral,PqConnection,Date-method}
\alias{dbQuoteLiteral,PqConnection,POSIXt-method}
\alias{dbQuoteLiteral,PqConnection,difftime-method}
\alias{dbQuoteLiteral,PqConnection,list-method}
\alias{dbQuoteLiteral,PqConnection,blob-method}
\alias{dbQuoteLiteral,PqConnection,character-method}
\title{Quote postgres strings, identifiers, and literals}
\usage{
\S4method{dbQuoteString}{PqConnection,character}(conn, x, ...)

\S4method{dbQuoteString}{PqConnection,SQL}(conn, x, ...)

\S4method{dbQuoteIdentifier}{PqConnection,character}(conn, x, ...)

\S4method{dbQuoteIdentifier}{PqConnection,SQL}(conn, x, ...)

\S4method{dbQuoteIdentifier}{PqConnection,Id}(conn, x, ...)

\S4method{dbUnquoteIdentifier}{PqConnection,SQL}(conn, x, ...)

dbQuoteLiteral(conn, x, ...)

\S4method{dbQuoteLiteral}{PqConnection,logical}(conn, x, ...)

\S4method{dbQuoteLiteral}{PqConnection,integer}(conn, x, ...)

\S4method{dbQuoteLiteral}{PqConnection,numeric}(conn, x, ...)

\S4method{dbQuoteLiteral}{PqConnection,factor}(conn, x, ...)

\S4method{dbQuoteLiteral}{PqConnection,Date}(conn, x, ...)

\S4method{dbQuoteLiteral}{PqConnection,POSIXt}(conn, x, ...)

\S4method{dbQuoteLiteral}{PqConnection,difftime}(conn, x, ...)

\S4method{dbQuoteLiteral}{PqConnection,list}(conn, x, ...)

\S4method{dbQuoteLiteral}{PqConnection,blob}(conn, x, ...)

\S4method{dbQuoteLiteral}{PqConnection,character}(conn, x, ...)
}
\arguments{
\item{conn}{A \linkS4class{PqConnection} created by \code{dbConnect()}}

\item{x}{A character to escaped}

\item{...}{Other arguments needed for compatibility with generic}
}
\description{
If an object of class \link{Id} is used for \code{dbQuoteIdentifier()}, it needs
at most one \code{table} component and at most one \code{schema} component.
}
\examples{
# For running the examples on systems without PostgreSQL connection:
run <- postgresHasDefault()

library(DBI)
if (run) con <- dbConnect(RPostgres::Postgres())

x <- c("a", "b c", "d'e", "\\\\f")
if (run) dbQuoteString(con, x)
if (run) dbQuoteIdentifier(con, x)
if (run) dbDisconnect(con)
}
