% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{control_boxplot_sample}
\alias{control_boxplot_sample}
\title{control_boxplot_sample}
\usage{
control_boxplot_sample(
  data,
  sel.Sample = "all",
  pairwise.FCh = FALSE,
  coef = 1.5,
  colors = c("#66c2a5", "#fc8d62"),
  x.axis.title = "Sample",
  y.axis.title = "value",
  axis.title.size = 11,
  axis.text.size = 12,
  legend.title = "Group",
  legend.title.size = 11,
  legend.text.size = 11,
  legend.position = "right",
  plot.title = "",
  plot.title.size = 14,
  save.to.tiff = FALSE,
  dpi = 600,
  width = 15,
  height = 15,
  name.tiff = "control_boxplot_samples"
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready() or delta_Ct() functions. Also, a data frame with
fold change values returned from RQ_dCt() and RQ_ddCt() functions run in a pairwise mode can be used.}

\item{sel.Sample}{Character vector with names of samples to include, or "all" (default) to use all samples.}

\item{pairwise.FCh}{Logical: If fold change values returned from RQ_dCt() and RQ_ddCt() functions
in a pairwise approach are used as data, this parameter should be set to TRUE, otherwise to FALSE (default).}

\item{coef}{Numeric: how many times of interquartile range should be used to determine range point for whiskers. Default to 1.5.}

\item{colors}{Character vector containing colors for compared groups. Numbers of colors must be equal to number of groups. Default to c("#66c2a5", "#fc8d62").
If pairwise.FCh parameter is set to TRUE, one color is required (data contain no groups).}

\item{x.axis.title}{Character: title of x axis. Default to "Sample".}

\item{y.axis.title}{Character: title of y axis. Default to "value".}

\item{axis.title.size}{Integer: font size of axis titles. Default to 11.}

\item{axis.text.size}{Integer: font size of axis text. Default to 12.}

\item{legend.title}{Character: title of legend. Default to "Group".}

\item{legend.title.size}{Integer: font size of legend title. Default to 11.}

\item{legend.text.size}{Integer: font size of legend text. Default to 11.}

\item{legend.position}{Position of the legend, can be "top", "right" (default), "bottom", "left", or "none" (no legend).
See description for legend.position in ggplot2::theme() function.}

\item{plot.title}{Character: title of plot. Default to "".}

\item{plot.title.size}{Integer: font size of plot title. Default to 14.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{name.tiff}{Character: name of saved .tiff file, without ".tiff" name of extension. Default to "control_boxplot_samples".}
}
\value{
Object with a boxplot illustrating distribution of data in each sample. Created plot is also displayed on the graphic device.
}
\description{
Boxplot that illustrate distribution of data in each sample. This function is helpful to identify outlier samples.
}
\examples{
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "Gene8")
control.boxplot.sample <- control_boxplot_sample(data.dCt)

}
