% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QRforX.r
\name{QRforX}
\alias{QRforX}
\title{QR decomposition of linear model design matrices}
\usage{
QRforX(X, returnQ = TRUE, reduce = TRUE, reQR = TRUE, ...)
}
\arguments{
\item{X}{A linear model design matrix, but can be any object coercible to matrix.}

\item{returnQ}{A logical value whether to return the Q matrix.  Generating a
Q matrix can be computationally intense for large matrices.  If it is not
explicitly needed, this argument can be FALSE.}

\item{reduce}{A logical value for whether redundant parameters in X should be 
removed.  This should be TRUE (default) for most cases.}

\item{reQR}{A logical value for whether to re-perform QR if reduce = TRUE,
and X has been reduced.}

\item{...}{Further arguments passed to base::qr.}
}
\value{
An object of class \code{QR} is a list containing the 
following:
\item{Q}{The Q matrix, if requested.}
\item{R}{The R matrix.}
\item{X}{The X matrix, which could be changes from dense to sparse,
or vice versa, and redundant columns removed.}
\item{rank}{The rank of the X matrix.}
\item{fix}{Logical value for whether redundant columns were removed
form X.  TRUE means columns were removed.}
\item{S4}{Logical value for whether Q, R, and X are S4 class objects.}
}
\description{
This function performs a QR decomposition (factorization) on a linear 
model design matrix (X) and returns useful results for subsequent analysis.
This is intended as an internal function but can be used externally.  Because
base::qr and Matrix::qr have different options for QR algorithms, this
function assures that results are consistent for other RRPP function use, 
whether X is a dense or sparse matrix.
}
\examples{
## Simple Example
data(Pupfish)
fit <- lm.rrpp(coords ~ Pop, data = Pupfish, print.progress = FALSE)
QR <- QRforX(model.matrix(fit))
QR$Q
QR$R
QR$rank
QR$S4

## Not run, but one could get base::qr and Matrix::qr results as

# base::qr(as.matrix(QR$X))
# Matrix::qr(QR$X)

## Complex example

data("PupfishHeads")
fit <- suppressWarnings(lm.rrpp(headSize ~ sex + 
locality/year, data = PupfishHeads))
X <- model.matrix(fit)
dim(X) # Already reduced
colnames(X)
X <- model.matrix(terms(fit), fit$LM$data)
dim(X) # Retains redundant parameters
colnames(X)
QR <- QRforX(X)
QR$fixed
dim(QR$X) # Reduced again
colnames(QR$X)

}
\author{
Michael Collyer
}
\keyword{utilities}
