% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv.map.R
\name{conv.map}
\alias{conv.map}
\title{Mapping morphological convergence on 3D surfaces}
\usage{
conv.map(x1,x2=NULL,scores, pcs, mshape,focal=NULL,mshape_sur=NULL,
  refmat = NULL,refsur = NULL, k = 4, exclude = NULL, out.rem = TRUE, plot =
  TRUE, col = "blue", NAcol = "gray", names = TRUE, nsim = 1000)
}
\arguments{
\item{x1, x2}{vectors of convergent species. When convergence within a single
clade was found, \code{x1} represents the vector of species belonging to the clade
(\code{x2=NULL}). When convergence between groups/clades was found,
\code{x1} and \code{x2} are the two convergent groups/clades.}

\item{scores}{data frame (or matrix) with the RW (or PC) scores returned by
RWA/PCA. Species not included in \code{x1} or \code{x2} are ignored.}

\item{pcs}{RW (or PC) vectors (eigenvectors of the covariance matrix)
returned by RWA/PCA.}

\item{mshape}{the consensus configuration.}

\item{focal}{vector of species included in \code{x1/x2} to be plotted. To be
provided if \code{refsur=NULL} and \code{refmat=NULL}.}

\item{mshape_sur}{a \code{mesh3d} object used as a reference for mesh
reconstruction. The vertices of \code{mshape_sur} must be the consensus
configuration. If \code{NULL}, it is automatically generated by applying
\code{\link[Rvcg]{vcgBallPivoting}} on \code{mshape}.}

\item{refmat}{a named list of landmark sets corresponding to \code{refsur}.}

\item{refsur}{a named list of \code{mesh3d} objects for species in
\code{x1/x2} to be plotted. If \code{focal} is not \code{NULL} this is
ignored.}

\item{k}{the argument \code{k} passed to \code{\link{interpolMesh}}.}

\item{exclude}{integer: the index numbers of the RWs (or PCs) to be excluded
from the comparison.}

\item{out.rem}{logical: if \code{TRUE} triangles with outlying area
difference are removed.}

\item{plot}{logical: if \code{TRUE}, the pairwise comparisons are plotted.
For more than 5 pairwise comparisons, the plot is not shown.}

\item{col}{character: the color for plotting.}

\item{NAcol}{the argument \code{NAcol} passed to \code{\link{col2mesh}}.}

\item{names}{logical: if \code{TRUE}, the names of the groups or species are
displayed in the 3d plot.}

\item{nsim}{the number of iterations to evaluate significance.}
}
\value{
The function returns a list including:
  \itemize{\item\strong{$angle.compare}: a data frame including the real angles
  between species shape vectors \code{$real.angle}, the angles computed between vectors
  of the selected RWs (or PCs) \code{$selected}, the angles between vectors of the
  non-selected RWs (or PCs) \code{$others}, the differences \code{selected-others}
  and its p-values. \item\strong{$selected.pcs} RWs (or PCs) axes selected
  for convergence. \item\strong{$average.dist} symmetric matrix of pairwise
  distances between 3D surfaces. \item\strong{$suface1} list of colored
  surfaces representing convergence between mesh A and B charted on mesh A.
  \item\strong{$suface2} list of colored surfaces representing convergence
  between mesh A and B charted on mesh B. \item \strong{$scale} the value
  used to set the color gradient, computed as the maximum of all differences
  between each surface and the mean shape.}
}
\description{
Given vectors of RW (or PC) scores for some converging species,
  the function selects the RW (PC) axes which best account for convergence
  and maps convergent areas on the corresponding 3D surfaces.
}
\details{
After selecting the RW (PC) axes which best account for convergence,
  \code{conv.map} uses such axes (and related scores) within
  \code{\link[Morpho]{restoreShapes}} (\pkg{Morpho}) to reconstruct landmark
  matrices for each convergent species (in \code{x1/x2}). The reconstruction
  of species 3d surfaces is based on \code{mshape_sur}, either provided by
  the user or generated within the function. Finally, the area differences
  between corresponding triangles of reconstructed 3d meshes for each
  possible pair of convergent species are calculated. In the calculation of
  differences, the possibility to find and remove outliers is supplied
  (\code{out.rem=TRUE}, we suggest considering this possibility if the mesh
  may contain degenerate facets).

  If the combination of \code{focal} species (or species within
  \code{refsur/refmat}) contains a number equal or lower then 5 items,
  \code{conv.map} returns a \code{rgl} plot mapping the convergence on the 3D
  models. If lists of \code{refsur/refmat} are not provided, the area
  differences are plotted onto reconstructed surfaces. If
  \code{refsur/refmat} are available, difference values are interpolated by
  means of \code{\link{interpolMesh}} to be plotted onto real surfaces. When
  species in either \code{x1} or \code{x2} are missing from \code{focal} or
  \code{refmat/refsur}, \code{conv.map} plots the reconstructed surface of
  the species having the smallest \code{$selected} angle with the focal (see
  \code{angle.compare} in the description of outputs).

  \code{conv.map} further gives the opportunity to exclude some RW (or PC)
  axes from the analysis because, for example, in most cases the first axes
  are mainly related to high-order morphological differences driven by
  phylogeny and size variations.
}
\examples{
  \donttest{
  da<-"https://github.com/pasraia/RRmorph_example_data/raw/refs/heads/main/RRmorphdata.rda"
  download.file(url=da,destfile = paste0(tempdir(),"/RRmorphdata.rda"))
  load(paste0(tempdir(),"/RRmorphdata.rda"))

  require(Morpho)

  pca<-procSym(endo.set)
  ldm_homo<-endo.set[,,"Homo_sapiens"]
  sur_homo<-endo.sur[["Homo_sapiens"]]
  ldm_macaca<-endo.set[,,"Macaca_fuscata"]
  sur_macaca<-endo.sur[["Macaca_fuscata"]]


  # Convergence within group plotted on reconstructed surfaces
  cm1<-conv.map(x1=c("Pan_troglodytes","Gorilla_gorilla","Pongo_abelii"),
                scores=pca$PCscores,pcs=pca$PCs,mshape=pca$mshape,
                focal=c("Pan_troglodytes","Gorilla_gorilla"))

  # Convergence between group plotted on reconstructed surfaces
  cm2<-conv.map(x1=c("Pongo_abelii"),x2=c("Alouatta_caraya"),
                scores=pca$PCscores,pcs=pca$PCs,mshape=pca$mshape,
                focal="Alouatta_caraya")

  # Convergence within group plotted on real surfaces
  cm3<-conv.map(x1=c("Homo_sapiens","Gorilla_gorilla","Pongo_abelii"),
                scores=pca$PCscores,pcs=pca$PCs,mshape=pca$mshape,
                refsur=list("Homo_sapiens"=sur_homo),
                refmat=list("Homo_sapiens"=ldm_homo))

  # Convergence between group plotted on real surfaces
  cm3<-conv.map(x1=c("Homo_sapiens","Pongo_abelii"),x2=c("Macaca_fuscata"),
                scores=pca$PCscores,pcs=pca$PCs,mshape=pca$mshape,
                refsur=list("Homo_sapiens"=sur_homo,"Macaca_fuscata"=sur_macaca),
                refmat=list("Homo_sapiens"=ldm_homo,"Macaca_fuscata"=ldm_macaca))
  }
}
\references{
Schlager, S. (2017). \emph{Morpho and Rvcg–Shape Analysis in R:
  R-Packages for geometric morphometrics, shape analysis and surface
  manipulations.} In: Statistical shape and deformation analysis. Academic
  Press.

Melchionna, M., Profico, A., Castiglione, S., Serio, C., Mondanaro,
  A., Modafferi, M., Tamagnini, D., Maiorano, L. , Raia, P., Witmer, L.M.,
  Wroe, S., & Sansalone, G. (2021). A method for mapping morphological
  convergence on three-dimensional digital models: the case of the mammalian
  sabre-tooth. \emph{Palaeontology}, 64, 573–584. doi:10.1111/pala.12542
}
\seealso{
\href{../doc/search.conv.html}{\code{search.conv} vignette} ;
  \code{\link[Morpho]{relWarps}} ; \code{\link[Morpho]{procSym}}
}
\author{
Marina Melchionna, Antonio Profico, Silvia Castiglione, Carmela
  Serio, Gabriele Sansalone, Pasquale Raia
}
