% Generated by roxygen2 (4.0.2): do not edit by hand
\name{RRsimu}
\alias{RRsimu}
\title{Monte Carlo simulation for one or two RR variables}
\usage{
RRsimu(numRep, n, pi, model, p, rho, complyRates = c(1, 1), sysBias = c(0,
  0), method = c("RRuni", "RRcor", "RRlog"), alpha = 0.05,
  groupRatio = 0.5, MLest = TRUE, nCPU = 1)
}
\arguments{
\item{numRep}{number of replications}

\item{n}{sample size}

\item{pi}{true proportion of carriers of sensitive attribute (for 2 RR variables: \code{vector})}

\item{model}{either one or two RR model (as \code{vector}), see \code{\link{RRuni}}}

\item{p}{randomization probability (for 2 RR variables: a \code{list})}

\item{rho}{true correlation in population (also known as point-biserial/point-tetrachoric correlation, in case of one/two dichotomous RR variables)}

\item{complyRates}{vector with two values giving the proportions of participants who adhere to the instructions in the subset with or without the sensitive attribute, respectively (for 2 RR variables: a \code{list})}

\item{sysBias}{probability of responding 'yes' (coded as 1 in the RR variable) in case of non-compliance for carriers and non-carriers, respectively. See \code{\link{RRgen}}}

\item{method}{vector specifying which RR methods to be used in each replication. For a single RR variable, all three methods can be used. For 2 RR variables, only \code{\link{RRcor}} is available.}

\item{alpha}{significance threshold for testing the logistic regression parameter \code{beta}}

\item{groupRatio}{only for multiple group models: ratio of groups (for 2 RR variables: \code{vector})}

\item{MLest}{correct estimates of \code{RRuni} if pi is outside of [0,1]}

\item{nCPU}{integer: how many processors to use? (use 'max' for automatic detection on Windows)}
}
\value{
an object \code{RRsimu} which contains the estimated parameters \code{parEsts} and a matrix \code{results} with mean parameters and standard errors across replications
}
\description{
Simulate and analyse bivariate data including either one or two RR variables. Useful for power analysis, parametric bootstraps or for testing the effects of noncompliance on the stability of estimates.
}
\details{
In case of using only one RR variable, the second, directly measured variable is sampled from a normal distribution with shifted means, depending on the true state on the sensitive attribute (i.e., the true, underlying values on the RR variable). For dichotomous RR variables, this corresponds to the assumption of an ordinary t-test, where the dependent variable is normally distributed within groups with equal variance. The difference in means is chosen in a way, to obtain the point-biserial correlation defined by \code{rho}.

In case of two dichotomous RR variables, the true group membership of individuals is sampled from a 2x2 cross table. Within this table, probabilities are chosen in a way, to obtain the point-tetrachoric correlation defined by \code{rho}

Note, that for the FR model with multiple response categories (e.g., from 0 to 4), the specified \code{rho} is not the exact target of the sampling procedure. It assumes a normal distribution for each true state, with constant differences between the groups (i.e., it assumes an interval scaled variable).
}
\examples{
# Simulate data according to the Warner model
mcsim <-  RRsimu(numRep=5, n=200, pi=.3, model="Warner", p=2/12, rho=.6)
mcsim
plot(mcsim)
}

