% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRmixed.R
\name{RRmixed}
\alias{RRmixed}
\title{Mixed Effects Logistic Regression for RR Data}
\usage{
RRmixed(formula, data, model, p, ...)
}
\arguments{
\item{formula}{two-sided formula including random and fixed effects (see below or \code{\link{glmer}} for details)}

\item{data}{an optional data frame with variables named in formula}

\item{model}{type of RR design. Only 1-group RR designs are supported at the moment (i.e., \code{"Warner"}, \code{"FR"}, \code{"UQTknown"}, \code{"Crosswise"}, \code{"Triangular"}, \code{"Kuk"}, \code{"Mangat"}, \code{"custom"}). See \code{\link{RRuni}} or \code{vignette(RRreg)} for details.}

\item{p}{randomization probability}

\item{...}{further arguments passed to \code{\link{glmer}}}
}
\value{
an object of class \code{glmerMod}
}
\description{
Uses the package \code{\link{lme4}} to fit a generalized linear mixed model (GLMM) with an adjusted link funciton.
}
\details{
Some examples for formula:
\itemize{
 \item{random intercept:   }{ \code{response ~ covariate + (1 | group)}}
 \item{random slope:   }{ \code{response ~ covariate + (0 + covariate | group)}}
 \item{both random slope and intercept:   }{ \code{response ~ covariate +(covariate | group)}}
 \item{level-2 predictor (must have constant values within groups!):   }{ \code{response ~ lev2 + (1|group)}}
}
}
\examples{
# generate data with a level-1 predictor 
d <- data.frame(group=factor(rep(LETTERS[1:20],each=50)), 
                cov=rnorm(20*50))
# generate dependent data based on logistic model (random intercept):
d$true <- simulate(~  cov + (1|group), newdata=d,
                     family=binomial(link="logit"),
                     newparams=list(beta=c("(Intercept)"=-.5, cov=1),
                                    theta=c("group.(Intercept)"=.8)))[[1]]
# scramble responses using RR:
model <- "FR"
p <- c(true0=.1, true1=.2)
d$resp <- RRgen(model="FR", p=p, trueState=d$true)$response
# fit model:
mod <- RRmixed(resp ~  cov +(1|group), data=d, model="FR", p=p)
summary(mod)
}
\references{
van den Hout, A., van der Heijden, P. G., & Gilchrist, R. (2007). The Logistic Regression Model with Response Variables Subject to Randomized Response. Computational Statistics & Data Analysis, 51, 6060–6069.
}
