/*
 * Decompiled with CFR 0.152.
 */
package org.act.cat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.act.cat.CatEngine;
import org.act.cat.CatItemsToAdminister;
import org.act.cat.CatPassageInfo;
import org.act.util.ContentTable;
import org.act.util.PrimitiveArraySet;
import org.act.util.PrimitiveArrays;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CatFunctions {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatFunctions.class);
    private static final String HEADER_FISHER_INFORMATION = CatEngine.MapIndiceHeader.FISHER_INFORMATION.name();
    private static final String HEADER_ITEM_IDENTIFIERS = CatEngine.MapIndiceHeader.ITEM_IDENTIFIERS.name();
    private static final String HEADER_ITEMS_ADMINISTERED = CatEngine.MapIndiceHeader.ITEMS_ADMINISTERED.name();
    private static final String HEADER_PASSAGE_IDENTIFIERS = CatEngine.MapIndiceHeader.PASSAGE_IDENTIFIERS.name();
    private static final String HEADER_PASSAGE_ITEM_ORDER = CatEngine.MapIndiceHeader.PASSAGE_ITEM_ORDER.name();
    private static final String STRING_NONE_LOWER_CASE = "none";
    private static final String STRING_ID = "id";
    private static final String STRING_VALUE = "value";
    private static final String STRING_PASSAGE = "passage";

    private CatFunctions() {
    }

    public static List<CatPassageInfo> calcPassageInfo(int[] selectedItemIndices, PrimitiveArraySet itemPoolDataSet) {
        PrimitiveArraySet shadowTestDataSet = itemPoolDataSet.subSample(selectedItemIndices);
        PrimitiveArraySet sortedItemsByPassage = shadowTestDataSet.groupSort(HEADER_PASSAGE_IDENTIFIERS);
        String[] passageIdentifiers = sortedItemsByPassage.getStringArrayCopy(HEADER_PASSAGE_IDENTIFIERS);
        String[] itemIdentifiers = sortedItemsByPassage.getStringArray(HEADER_ITEM_IDENTIFIERS);
        double[] itemInformationValues = sortedItemsByPassage.getDoubleArrayCopy(HEADER_FISHER_INFORMATION);
        ArrayList<CatPassageInfo> passageInfoList = new ArrayList<CatPassageInfo>();
        String oldPassageId = "INITIALIZE";
        boolean oldIsPassage = true;
        double totalInfoValue = 0.0;
        int counter = 1;
        double averageInfoValue = 0.0;
        CatPassageInfo passageInfo = null;
        for (int i = 0; i < passageIdentifiers.length; ++i) {
            boolean newIsPassage = true;
            String newPassageId = passageIdentifiers[i];
            double itemInfoValue = itemInformationValues[i];
            if (newPassageId.equalsIgnoreCase(STRING_NONE_LOWER_CASE)) {
                newPassageId = itemIdentifiers[i];
                newIsPassage = false;
            }
            if (i == 0) {
                oldPassageId = newPassageId;
                oldIsPassage = newIsPassage;
                totalInfoValue += itemInfoValue;
            } else if (i > 0) {
                if (newPassageId.equals(oldPassageId)) {
                    totalInfoValue += itemInfoValue;
                    ++counter;
                } else {
                    averageInfoValue = totalInfoValue / (double)counter;
                    passageInfo = new CatPassageInfo(oldPassageId, averageInfoValue, oldIsPassage);
                    passageInfoList.add(passageInfo);
                    oldPassageId = newPassageId;
                    oldIsPassage = newIsPassage;
                    totalInfoValue = itemInfoValue;
                    counter = 1;
                }
            }
            if (i != passageIdentifiers.length - 1) continue;
            averageInfoValue = totalInfoValue / (double)counter;
            passageInfo = new CatPassageInfo(oldPassageId, averageInfoValue, oldIsPassage);
            passageInfoList.add(passageInfo);
        }
        return passageInfoList;
    }

    public static List<Integer> getIneligibleIndicesItemOrder(String[] itemsAdministeredString, ContentTable itemPoolTable) {
        ArrayList<Integer> ineligibleIndicesItemOrder = new ArrayList<Integer>();
        if (itemsAdministeredString.length > 0) {
            String[] itemIds = new String[itemPoolTable.rowCount()];
            String[] passageIds = new String[itemPoolTable.rowCount()];
            String[] passageItemOrders = new String[itemPoolTable.rowCount()];
            Integer[] passageItemOrdersInt = new Integer[itemPoolTable.rowCount()];
            for (int i = 0; i < itemPoolTable.rowCount(); ++i) {
                itemIds[i] = itemPoolTable.rows().get(i).get(0);
                passageIds[i] = itemPoolTable.rows().get(i).get(1);
                passageItemOrders[i] = itemPoolTable.rows().get(i).get(2);
                passageItemOrdersInt[i] = NumberUtils.toInt((String)passageItemOrders[i]);
            }
            String lastItemAdministered = itemsAdministeredString[itemsAdministeredString.length - 1];
            int indexLastItemAdministered = PrimitiveArrays.select(itemIds, lastItemAdministered)[0];
            String passageItemOrderLastItem = passageItemOrders[indexLastItemAdministered];
            if (!passageItemOrderLastItem.equalsIgnoreCase(STRING_NONE_LOWER_CASE)) {
                int i;
                String passageIdLastItemAdministered = passageIds[indexLastItemAdministered];
                int[] indicesItemsInCurrentPassage = PrimitiveArrays.select(passageIds, passageIdLastItemAdministered);
                int[] indicesAdministeredItems = PrimitiveArrays.select(itemIds, itemsAdministeredString);
                ArrayList<Integer> indicesItemsInCurrentPassageNotYetAdministered = new ArrayList<Integer>();
                for (i = 0; i < indicesItemsInCurrentPassage.length; ++i) {
                    boolean itemAlreadyAdministered = false;
                    for (int j = 0; j < indicesAdministeredItems.length && !itemAlreadyAdministered; ++j) {
                        if (indicesItemsInCurrentPassage[i] != indicesAdministeredItems[j]) continue;
                        itemAlreadyAdministered = true;
                    }
                    if (itemAlreadyAdministered) continue;
                    indicesItemsInCurrentPassageNotYetAdministered.add(indicesItemsInCurrentPassage[i]);
                }
                for (i = 0; i < indicesItemsInCurrentPassageNotYetAdministered.size(); ++i) {
                    int index = (Integer)indicesItemsInCurrentPassageNotYetAdministered.get(i);
                    if (passageItemOrdersInt[index] >= passageItemOrdersInt[indexLastItemAdministered]) continue;
                    ineligibleIndicesItemOrder.add(index);
                }
            }
        }
        return ineligibleIndicesItemOrder;
    }

    public static boolean[] getEligiblePassageItems(String[] itemsAdministeredString, PrimitiveArraySet mapIndices, ContentTable itemPoolTable) {
        String[] itemIdentifiersPool = mapIndices.getStringArray(HEADER_ITEM_IDENTIFIERS);
        String[] passageIdentifiersPool = mapIndices.getStringArray(HEADER_PASSAGE_IDENTIFIERS);
        boolean[] eligiblePassageItemsBoolean = new boolean[passageIdentifiersPool.length];
        for (int i = 0; i < eligiblePassageItemsBoolean.length; ++i) {
            eligiblePassageItemsBoolean[i] = true;
        }
        ArrayList<Integer> ineligibleItemIndicesList = new ArrayList<Integer>();
        if (itemsAdministeredString.length > 0) {
            for (int i = 0; i < itemsAdministeredString.length - 1; ++i) {
                int previousItemIndex = PrimitiveArrays.select(itemIdentifiersPool, itemsAdministeredString[i])[0];
                int nextItemIndex = PrimitiveArrays.select(itemIdentifiersPool, itemsAdministeredString[i + 1])[0];
                String previousPassageId = passageIdentifiersPool[previousItemIndex];
                String nextPassageId = passageIdentifiersPool[nextItemIndex];
                boolean previousItemFromPassage = false;
                if (!passageIdentifiersPool[previousItemIndex].equalsIgnoreCase(STRING_NONE_LOWER_CASE)) {
                    previousItemFromPassage = true;
                }
                if (previousPassageId.equalsIgnoreCase(nextPassageId) || !previousItemFromPassage) continue;
                int[] previousPassageIndices = PrimitiveArrays.select(passageIdentifiersPool, previousPassageId);
                for (int j = 0; j < previousPassageIndices.length; ++j) {
                    boolean itemAlreadyAdministered = false;
                    for (int k = 0; k < itemsAdministeredString.length; ++k) {
                        int administeredItemIndex = PrimitiveArrays.select(itemIdentifiersPool, itemsAdministeredString[k])[0];
                        if (previousPassageIndices[j] != administeredItemIndex) continue;
                        itemAlreadyAdministered = true;
                    }
                    if (itemAlreadyAdministered) continue;
                    ineligibleItemIndicesList.add(previousPassageIndices[j]);
                }
            }
            List<Integer> ineligibleIndicesItemOrder = CatFunctions.getIneligibleIndicesItemOrder(itemsAdministeredString, itemPoolTable);
            ineligibleItemIndicesList.addAll(ineligibleIndicesItemOrder);
            for (int j = 0; j < ineligibleItemIndicesList.size(); ++j) {
                int index = (Integer)ineligibleItemIndicesList.get(j);
                eligiblePassageItemsBoolean[index] = false;
            }
        }
        return eligiblePassageItemsBoolean;
    }

    public static String[] orderPassageItems(String[] remainingItemsInCurrentPassage, ContentTable itemPoolTable) {
        String[] itemIds = new String[itemPoolTable.rowCount()];
        String[] passageItemOrders = new String[itemPoolTable.rowCount()];
        int[] passageItemOrdersInt = new int[itemPoolTable.rowCount()];
        for (int i = 0; i < itemPoolTable.rowCount(); ++i) {
            itemIds[i] = itemPoolTable.rows().get(i).get(0);
            passageItemOrders[i] = itemPoolTable.rows().get(i).get(2);
            passageItemOrdersInt[i] = NumberUtils.toInt((String)passageItemOrders[i]);
        }
        int[] indicesRemainingItems = PrimitiveArrays.select(itemIds, remainingItemsInCurrentPassage);
        boolean isItemOrder = false;
        if (indicesRemainingItems.length > 0 && !passageItemOrders[indicesRemainingItems[0]].equalsIgnoreCase(STRING_NONE_LOWER_CASE)) {
            isItemOrder = true;
        }
        PrimitiveArraySet mapIndices = new PrimitiveArraySet().withStringArray(HEADER_PASSAGE_IDENTIFIERS, itemIds).withIntArray(HEADER_PASSAGE_ITEM_ORDER, passageItemOrdersInt);
        PrimitiveArraySet remainingItemsArraySet = mapIndices.subSample(indicesRemainingItems);
        String[] nextItemsToAdminister = null;
        if (isItemOrder) {
            PrimitiveArraySet sortedRemainingItemsArraySet = remainingItemsArraySet.groupSort(HEADER_PASSAGE_IDENTIFIERS);
            nextItemsToAdminister = sortedRemainingItemsArraySet.getStringArrayCopy(HEADER_ITEM_IDENTIFIERS);
        }
        return nextItemsToAdminister;
    }

    private static CatItemsToAdminister prepShadowTestNextItem(String[] itemsAdminArray, int[] selectedItemIndices, PrimitiveArraySet mapIndices, ContentTable itemPoolTable, ContentTable passagePoolTable, List<Integer> passageRowIndexSequence) {
        long start = System.currentTimeMillis();
        PrimitiveArraySet shadowMapIndices = mapIndices.subSample(selectedItemIndices);
        boolean[] itemsAdministered = shadowMapIndices.getBooleanArrayCopy(HEADER_ITEMS_ADMINISTERED);
        int[] falseIndices = PrimitiveArrays.select(itemsAdministered, false);
        int[] trueIndices = PrimitiveArrays.select(itemsAdministered, true);
        PrimitiveArraySet notAdminShadowMapIndices = shadowMapIndices.subSample(falseIndices);
        PrimitiveArraySet alreadyAdminShadowMapIndices = shadowMapIndices.subSample(trueIndices);
        PrimitiveArraySet sortedItems = notAdminShadowMapIndices.groupSort(HEADER_FISHER_INFORMATION);
        String nextItemToAdminister = null;
        if (passagePoolTable != null && !passagePoolTable.rows().isEmpty()) {
            boolean nextItemSelected = false;
            String[] remainingShadowTestPassageIds = sortedItems.getStringArrayCopy(HEADER_PASSAGE_IDENTIFIERS);
            boolean anyRemainingPassageItems = false;
            for (int i = 0; i < remainingShadowTestPassageIds.length; ++i) {
                if (remainingShadowTestPassageIds[i].equalsIgnoreCase(STRING_NONE_LOWER_CASE)) continue;
                anyRemainingPassageItems = true;
            }
            if (anyRemainingPassageItems) {
                if (itemsAdminArray != null && itemsAdminArray.length > 0) {
                    int[] remainingItemIndicesForCurrentPassage;
                    String[] shadowTestItemIds = shadowMapIndices.getStringArrayCopy(HEADER_ITEM_IDENTIFIERS);
                    String[] shadowTestPassageIds = shadowMapIndices.getStringArrayCopy(HEADER_PASSAGE_IDENTIFIERS);
                    int rowIndexLastItemAdministered = PrimitiveArrays.select(shadowTestItemIds, itemsAdminArray[itemsAdminArray.length - 1])[0];
                    String passageIdLastItemAdministered = shadowTestPassageIds[rowIndexLastItemAdministered];
                    boolean lastItemFromPassage = false;
                    if (!passageIdLastItemAdministered.equalsIgnoreCase(STRING_NONE_LOWER_CASE)) {
                        lastItemFromPassage = true;
                    }
                    if (lastItemFromPassage && (remainingItemIndicesForCurrentPassage = PrimitiveArrays.select(remainingShadowTestPassageIds, passageIdLastItemAdministered)).length > 0) {
                        PrimitiveArraySet remainingItemsInCurrentPassageDataSet = sortedItems.subSample(remainingItemIndicesForCurrentPassage);
                        String[] remainingItemsInCurrentPassageArray = remainingItemsInCurrentPassageDataSet.getStringArrayCopy(HEADER_ITEM_IDENTIFIERS);
                        String[] sortedItemsInCurrentPassageArray = CatFunctions.orderPassageItems(remainingItemsInCurrentPassageArray, itemPoolTable);
                        nextItemToAdminister = sortedItemsInCurrentPassageArray != null ? sortedItemsInCurrentPassageArray[0] : remainingItemsInCurrentPassageArray[remainingItemsInCurrentPassageArray.length - 1];
                        nextItemSelected = true;
                    }
                }
                if (!nextItemSelected) {
                    String[] passageIdsFromPassageTable = new String[passagePoolTable.rowCount()];
                    for (int i = 0; i < passagePoolTable.rowCount(); ++i) {
                        passageIdsFromPassageTable[i] = passagePoolTable.rows().get(i).get(0);
                    }
                    List<CatPassageInfo> passageInfoList = CatFunctions.calcPassageInfo(selectedItemIndices, mapIndices);
                    String[] idFromCalcPassageInfo = new String[passageInfoList.size()];
                    double[] valueFromCalcPassageInfo = new double[passageInfoList.size()];
                    boolean[] passageFromCalcPassageInfo = new boolean[passageInfoList.size()];
                    for (int i = 0; i < passageInfoList.size(); ++i) {
                        idFromCalcPassageInfo[i] = passageInfoList.get(i).getId();
                        valueFromCalcPassageInfo[i] = passageInfoList.get(i).getValue();
                        passageFromCalcPassageInfo[i] = passageInfoList.get(i).getIsPassage();
                    }
                    PrimitiveArraySet passageInfoDataSet = new PrimitiveArraySet().withStringArray(STRING_ID, idFromCalcPassageInfo).withDoubleArray(STRING_VALUE, valueFromCalcPassageInfo).withBooleanArray(STRING_PASSAGE, passageFromCalcPassageInfo);
                    if (passageRowIndexSequence != null && !passageRowIndexSequence.isEmpty()) {
                        String[] passageOrderConstraintIds = new String[passageRowIndexSequence.size()];
                        for (int i = 0; i < passageRowIndexSequence.size(); ++i) {
                            passageOrderConstraintIds[i] = passageIdsFromPassageTable[passageRowIndexSequence.get(i)];
                        }
                        String nextPassageToAdminister = null;
                        String[] shadowTestItemIds = shadowMapIndices.getStringArrayCopy(HEADER_ITEM_IDENTIFIERS);
                        String[] shadowTestPassageIds = shadowMapIndices.getStringArrayCopy(HEADER_PASSAGE_IDENTIFIERS);
                        boolean itemAssociatedWithPassageHasBeenAdministered = false;
                        Integer previousPassageAdministeredIndex = null;
                        for (int i = 0; i < itemsAdminArray.length; ++i) {
                            int rowIndexForPassageIdCheck = PrimitiveArrays.select(shadowTestItemIds, itemsAdminArray[i])[0];
                            String passageIdForPassageIdCheck = shadowTestPassageIds[rowIndexForPassageIdCheck];
                            if (passageIdForPassageIdCheck.equalsIgnoreCase(STRING_NONE_LOWER_CASE)) continue;
                            previousPassageAdministeredIndex = PrimitiveArrays.select(passageOrderConstraintIds, passageIdForPassageIdCheck)[0];
                            itemAssociatedWithPassageHasBeenAdministered = true;
                        }
                        if (itemAssociatedWithPassageHasBeenAdministered && passageOrderConstraintIds.length > previousPassageAdministeredIndex + 1) {
                            nextPassageToAdminister = passageOrderConstraintIds[previousPassageAdministeredIndex + 1];
                        }
                        if (itemsAdminArray.length == 0 || !itemAssociatedWithPassageHasBeenAdministered) {
                            nextPassageToAdminister = passageOrderConstraintIds[0];
                        }
                        if (nextPassageToAdminister != null) {
                            ArrayList<Integer> passageConstraintDataSetIndices = new ArrayList<Integer>();
                            for (int i = 0; i < idFromCalcPassageInfo.length; ++i) {
                                if (passageFromCalcPassageInfo[i] && !idFromCalcPassageInfo[i].equals(nextPassageToAdminister)) continue;
                                passageConstraintDataSetIndices.add(i);
                            }
                            int[] passageConstraintDataSetIndicesArray = new int[passageConstraintDataSetIndices.size()];
                            for (int i = 0; i < passageConstraintDataSetIndices.size(); ++i) {
                                passageConstraintDataSetIndicesArray[i] = (Integer)passageConstraintDataSetIndices.get(i);
                            }
                            PrimitiveArraySet passageInfoDataSetGivenPassageOrderConstraints = passageInfoDataSet.subSample(passageConstraintDataSetIndicesArray);
                            PrimitiveArraySet passageOrderConstraintDataSetSorted = passageInfoDataSetGivenPassageOrderConstraints.groupSort(STRING_VALUE);
                            boolean noRemainingItemsInPassage = true;
                            boolean noNewDiscrete = true;
                            for (int counter = 1; noRemainingItemsInPassage && noNewDiscrete && counter <= passageInfoList.size(); ++counter) {
                                int[] indexAlreadyAdministeredItem;
                                PrimitiveArraySet passageOrderConstraintMostInformative = passageOrderConstraintDataSetSorted.subSample(passageConstraintDataSetIndices.size() - counter);
                                String passageOrderConstraintMostInformativePassageId = passageOrderConstraintMostInformative.getStringArray(STRING_ID)[0];
                                boolean passageOrderConstraintMostInformativePassageIndicator = passageOrderConstraintMostInformative.getBooleanArray(STRING_PASSAGE)[0];
                                String[] remainingShadowTestPassageIdsNextPassage = sortedItems.getStringArrayCopy(HEADER_PASSAGE_IDENTIFIERS);
                                int[] remainingItemIndicesNextPassage = PrimitiveArrays.select(remainingShadowTestPassageIdsNextPassage, passageOrderConstraintMostInformativePassageId);
                                if (remainingItemIndicesNextPassage.length > 0) {
                                    PrimitiveArraySet remainingItemsInCurrentPassageSet = sortedItems.subSample(remainingItemIndicesNextPassage);
                                    String[] remainingItemsInMostInformativePassageArray = remainingItemsInCurrentPassageSet.getStringArrayCopy(HEADER_ITEM_IDENTIFIERS);
                                    String[] sortedItemsInCurrentPassageArray = CatFunctions.orderPassageItems(remainingItemsInMostInformativePassageArray, itemPoolTable);
                                    nextItemToAdminister = sortedItemsInCurrentPassageArray != null ? sortedItemsInCurrentPassageArray[0] : remainingItemsInMostInformativePassageArray[remainingItemsInMostInformativePassageArray.length - 1];
                                    noRemainingItemsInPassage = false;
                                }
                                if (passageOrderConstraintMostInformativePassageIndicator || (indexAlreadyAdministeredItem = PrimitiveArrays.select(itemsAdminArray, passageOrderConstraintMostInformativePassageId)).length != 0) continue;
                                nextItemToAdminister = passageOrderConstraintMostInformativePassageId;
                                noNewDiscrete = false;
                            }
                        }
                    } else {
                        PrimitiveArraySet passageInfoSorted = passageInfoDataSet.groupSort(STRING_VALUE);
                        boolean noRemainingItemsInPassage = true;
                        boolean noNewDiscrete = true;
                        for (int counter = 1; noRemainingItemsInPassage && noNewDiscrete && counter <= passageInfoList.size(); ++counter) {
                            int[] indexAlreadyAdministeredItem;
                            PrimitiveArraySet passageInfoMostInformative = passageInfoSorted.subSample(passageInfoList.size() - counter);
                            String mostInformativePassageId = passageInfoMostInformative.getStringArray(STRING_ID)[0];
                            boolean mostInformativePassageIndicator = passageInfoMostInformative.getBooleanArray(STRING_PASSAGE)[0];
                            String[] remainingShadowTestPassageIdsNextPassage = sortedItems.getStringArrayCopy(HEADER_PASSAGE_IDENTIFIERS);
                            int[] remainingItemIndicesNextPassage = PrimitiveArrays.select(remainingShadowTestPassageIdsNextPassage, mostInformativePassageId);
                            if (remainingItemIndicesNextPassage.length > 0) {
                                PrimitiveArraySet remainingItemsInCurrentPassageSet = sortedItems.subSample(remainingItemIndicesNextPassage);
                                String[] remainingItemsInMostInformativePassageArray = remainingItemsInCurrentPassageSet.getStringArrayCopy(HEADER_ITEM_IDENTIFIERS);
                                String[] sortedItemsInCurrentPassageArray = CatFunctions.orderPassageItems(remainingItemsInMostInformativePassageArray, itemPoolTable);
                                nextItemToAdminister = sortedItemsInCurrentPassageArray != null ? sortedItemsInCurrentPassageArray[0] : remainingItemsInMostInformativePassageArray[remainingItemsInMostInformativePassageArray.length - 1];
                                noRemainingItemsInPassage = false;
                            }
                            if (mostInformativePassageIndicator || (indexAlreadyAdministeredItem = PrimitiveArrays.select(itemsAdminArray, mostInformativePassageId)).length != 0) continue;
                            nextItemToAdminister = mostInformativePassageId;
                            noNewDiscrete = false;
                        }
                    }
                }
            }
        }
        String[] listItemsToAdminister = sortedItems.getStringArrayCopy(HEADER_ITEM_IDENTIFIERS);
        String[] listItemsAlreadyAdministered = alreadyAdminShadowMapIndices.getStringArrayCopy(HEADER_ITEM_IDENTIFIERS);
        List<String> listItemsToAdministerTemp = Arrays.asList(listItemsToAdminister);
        Collections.reverse(listItemsToAdministerTemp);
        listItemsToAdminister = listItemsToAdministerTemp.toArray(new String[0]);
        if (nextItemToAdminister != null) {
            Integer indexForNextItem = null;
            for (int i = 0; i < listItemsToAdminister.length; ++i) {
                if (!listItemsToAdminister[i].equals(nextItemToAdminister)) continue;
                indexForNextItem = i;
            }
            String[] newItemsToAdminister = new String[listItemsToAdminister.length];
            newItemsToAdminister[0] = listItemsToAdminister[indexForNextItem];
            int counter = 1;
            for (int j = 0; j < listItemsToAdminister.length; ++j) {
                if (j == indexForNextItem) continue;
                newItemsToAdminister[counter] = listItemsToAdminister[j];
                ++counter;
            }
            listItemsToAdminister = newItemsToAdminister;
        }
        CatItemsToAdminister itemsToAdminister = new CatItemsToAdminister(listItemsToAdminister, listItemsAlreadyAdministered, 1);
        long end = System.currentTimeMillis();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("prepShadowTestNextItem time: {}", (Object)(end - start));
        }
        return itemsToAdminister;
    }

    public static CatItemsToAdminister prepShadowTest(String[] itemsAdminArray, int[] selectedItemIndices, PrimitiveArraySet mapIndices, ContentTable itemPoolTable, ContentTable passagePoolTable, List<Integer> passageRowIndexSequence) {
        long start = System.currentTimeMillis();
        Map<String, Integer> itemIdToIndexMap = CatFunctions.genMap(mapIndices.getStringArray(HEADER_ITEM_IDENTIFIERS));
        ArrayList<String> tempItemsAdmin = new ArrayList<String>(Arrays.asList(itemsAdminArray));
        CatItemsToAdminister itemsToAdminister = CatFunctions.prepShadowTestNextItem(itemsAdminArray, selectedItemIndices, mapIndices, itemPoolTable, passagePoolTable, passageRowIndexSequence);
        while (!itemsToAdminister.getListItemsToAdminister().isEmpty()) {
            String nextItem = itemsToAdminister.getListItemsToAdminister().get(0);
            tempItemsAdmin.add(nextItem);
            mapIndices.getBooleanArray((String)CatFunctions.HEADER_ITEMS_ADMINISTERED)[itemIdToIndexMap.get((Object)nextItem).intValue()] = true;
            itemsToAdminister = CatFunctions.prepShadowTestNextItem(tempItemsAdmin.toArray(new String[0]), selectedItemIndices, mapIndices, itemPoolTable, passagePoolTable, passageRowIndexSequence);
        }
        String[] itemsToAdmin = tempItemsAdmin.subList(itemsAdminArray.length, tempItemsAdmin.size()).toArray(new String[0]);
        long end = System.currentTimeMillis();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("prepShadowTest time: {}", (Object)(end - start));
        }
        return new CatItemsToAdminister(itemsToAdmin, itemsAdminArray, 1);
    }

    private static Map<String, Integer> genMap(String[] itemIdentifiers) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < itemIdentifiers.length; ++i) {
            map.put(itemIdentifiers[i], i);
        }
        return map;
    }

    public static double calInfo(double theta, double a, double b, double c, double d) {
        double p = CatFunctions.getProb3PL(a, b, c, d, theta);
        double q = 1.0 - p;
        return d * d * a * a * (q / p) * ((p - c) / (1.0 - c)) * ((p - c) / (1.0 - c));
    }

    public static double getProb3PL(double a, double b, double c, double d, double theta) {
        return c + (1.0 - c) / (1.0 + Math.exp(-d * a * (theta - b)));
    }

    public static double calPostExpInfo(double[] thetaDraws, double[] aDraws, double[] bDraws, double[] cDraws, double d) {
        int sampleLength = thetaDraws.length;
        double postExpInfo = 0.0;
        for (int s = 0; s < sampleLength; ++s) {
            postExpInfo += CatFunctions.calInfo(thetaDraws[s], aDraws[s], bDraws[s], cDraws[s], d);
        }
        return postExpInfo /= (double)sampleLength;
    }

    public static double[] calPostExpInfo(double[] thetaDraws, double[][][] itemParaSamples, double[] d) {
        double[] postExpInfo = new double[itemParaSamples.length];
        for (int i = 0; i < itemParaSamples.length; ++i) {
            postExpInfo[i] = CatFunctions.calPostExpInfo(thetaDraws, itemParaSamples[i][0], itemParaSamples[i][1], itemParaSamples[i][2], d[i]);
        }
        return postExpInfo;
    }
}

