% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{ssd.plot}
\alias{ssd.plot}
\title{Drawing the SSD}
\usage{
ssd.plot(sd.obj, names = c("1", "2"))
}
\arguments{
\item{sd.obj}{StochasticDominance object.}

\item{names}{A character vector, including the names of prospects in order.}
}
\value{
A list, including plot elements.
}
\description{
It visualize the SSD values of both prospects.
}
\details{
The parameter `names` only accepts character vector, otherwise an error will
be raised.

The function shows the line plot and returns its object for further modification.
}
\examples{
sd = createStochasticDominance(outcome1 = c(1,4,7),
                               outcome2 = c(2,3,5),
                               prob1 = c(1/3,1/3,1/3),
                               prob2 = c(1/6,1/6,2/3))
ssd.plot(sd, names = c('First', 'Second'))

}
