% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.median.R
\name{sym.median}
\alias{sym.median}
\title{Symbolic Median}
\usage{
sym.median(sym.var, method = c('centers', 'interval', 'modal'), na.rm = FALSE, ...)
}
\arguments{
\item{sym.var}{The symbolic variable.}

\item{method}{The method to be use.}

\item{na.rm}{As in R median function.}

\item{...}{As in R median function.}
}
\value{
Return a real number.
}
\description{
This function compute the symbolic median.
}
\examples{
data(example3)
sym.data<-example3
sym.median(sym.var(sym.data,1))
sym.median(sym.var(sym.data,2))
sym.median(sym.var(sym.data,6),method='interval')
sym.median(sym.var(sym.data,3),method='modal')
}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Median}
\keyword{Symbolic}
