% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateSSLData.R
\name{generateCrescentMoon}
\alias{generateCrescentMoon}
\title{Generate Crescent Moon dataset}
\usage{
generateCrescentMoon(n = 100, d = 2, sigma = 1)
}
\arguments{
\item{n}{integer; Number of objects to generate}

\item{d}{integer; Dimensionality of the dataset}

\item{sigma}{numeric; Noise added}
}
\description{
Generate a "crescent moon"/"banana" dataset
}
\examples{
data<-generateCrescentMoon(150,2,1)
plot(data$X1,data$X2,col=data$Class,asp=1)
}
\seealso{
Other RSSL datasets: 
\code{\link{generate2ClassGaussian}()},
\code{\link{generateABA}()},
\code{\link{generateFourClusters}()},
\code{\link{generateParallelPlanes}()},
\code{\link{generateSlicedCookie}()},
\code{\link{generateSpirals}()},
\code{\link{generateTwoCircles}()}
}
\concept{RSSL datasets}
