% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readSLI.R
\name{writeSLI}
\alias{writeSLI}
\title{Write ENVI spectral libraries}
\usage{
writeSLI(x, path, wavl.units = "Micrometers", scaleF = 1, mode = "bin")
}
\arguments{
\item{x}{data.frame with first column containing wavelengths and all other columns containing spectra.}

\item{path}{path to spectral library file to be created.}

\item{wavl.units}{wavelength units. Defaults to Micrometers. Nanometers is another typical option.}

\item{scaleF}{optional reflectance scaling factor. Defaults to 1.}

\item{mode}{character string specifying output file type. Must be one of \code{"bin"} for binary .sli files or \code{"ASCII"} for --guess what-- ASCII spectral library files (still in an ENVI compatible format).}
}
\description{
Writes binary ENVI spectral library files (sli) with accompanying header (.sli.hdr) files OR ASCII spectral library files in ENVI format.
}
\details{
ENVI spectral libraries with ending .sli are binary arrays with spectra saved in rows.
}
\examples{
## Create fake spectra
data <- data.frame(wavelength=350:2500, spectrumA=cumsum(abs(rnorm(2151))),
						spectrumB=cumsum(abs(rnorm(2151))))
pathToFile <- paste0(tempdir(),"/specLib.sli")

## Write to binary spectral library
writeSLI(x = data, path = pathToFile)

## Read from binary spectral library
dataRe <- readSLI(path = pathToFile)

## Check whether they are the same
all.equal(data, dataRe)
}
\seealso{
\code{\link{readSLI}}
}

