% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_api_sysreqs.R
\name{sysreqs_collect}
\alias{sysreqs_collect}
\title{Prints out all system requirements from dependencies and project packages.}
\usage{
sysreqs_collect(prj = NULL)
}
\arguments{
\item{prj}{project object to collect sys requirements for. If not passed will
use loaded project or default whichever exists. Will init default project
from working directory if no default project exists.
(type: rsuite_project, default: NULL)}
}
\value{
named list with named with package names and containing system
   requirements as value.
}
\description{
Prints out all system requirements from dependencies and project packages.
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

# add package to the project
prj_start_package("mypackage", prj = prj)

# add system requirements specification
write("SystemRequirements: some requirement",
      file = file.path(prj$path, "packages", "mypackage", "DESCRIPTION"),
      append = TRUE)

# list content of pkgzip created
sysreqs_collect(prj)

}
\seealso{
Other in SYSREQS: \code{\link{sysreqs_check}},
  \code{\link{sysreqs_install}}
}
