% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sep.binom.imperfect}
\alias{sep.binom.imperfect}
\title{Binomial population sensitivity for imperfect test}
\usage{
sep.binom.imperfect(n, c = 1, se, sp = 1, pstar)
}
\arguments{
\item{n}{sample size (scalar or vector)}

\item{c}{The cut-point number of positives to classify a cluster
as positive, default=1, if positives < c result is negative,
>= c is positive (scalar or vector of same length as n)}

\item{se}{test unit sensitivity (scalar or vector of same length as n)}

\item{sp}{test unit specificity, default=1 (scalar or vector of same length as n)}

\item{pstar}{design prevalence as a proportion (scalar or vector of same length as n)}
}
\value{
a vector of population-level sensitivities
}
\description{
Calculates population sensitivity for a large or unknown population
  and allowing for imperfect test sensitivity and specificity,
  using Binomial distribution an allowing for a variable cut-point number of
  positives to classify as positive
}
\examples{
# examples for sep.imperfect.binom
sep.binom.imperfect(1:10*5, 2, 0.95, 0.98, 0.1)
sep.binom.imperfect(50, 1:5, 0.95, 0.98, 0.1)
sep.binom.imperfect(30, 2, 0.9, 0.98, 0.1)
sep.binom.imperfect(30, 1, 0.9, 0.98, 0.1)
}
\keyword{methods}

