% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sep.sys}
\alias{sep.sys}
\title{2-stage population sensitivity}
\usage{
sep.sys(H = NA, N = NA, n, pstar.c, pstar.u, se = 1)
}
\arguments{
\item{H}{population size = number of clusters in the population, default = NA}

\item{N}{population size within clusters,
scalar or a vector of same length as n, default = NA}

\item{n}{sample size (vector of number tested per cluster)}

\item{pstar.c}{cluster (herd) level design prevalence, scalar,
either proportion or integer}

\item{pstar.u}{unit (animal) level design prevalence, scalar,
either proportion or integer}

\item{se}{unit sensitivity of test (proportion), scalar, default = 1}
}
\value{
list of 6 elements, 1) population level sensitivity, 2) vector of
  cluster-level sensitivities, 3) N, 4) n, 5) vector of design prevalences
  and 6) unit sensitivity
}
\description{
Calculates population-level (system) sensitivity for representative
  2-stage sampling (sampling of clusters and units within clusters),
  assuming imperfect test sensitivity and perfect test specificity
}
\note{
if pstar.c is not a proportion N must be provided
  (and N>=n)
}
\examples{
# examples for sep.sys - checked
H<- 500
N<- rep(1000, 150)
N[5]<- NA
n<- rep(30, 150)
pstar.u<- 0.1
pstar.c<- 0.01
se<- 0.98
sep.sys(H, N, n, pstar.c, pstar.u, se)
sep.sys(NA, N, n, 0.02, 0.05, 0.95)
N<- round(runif(105)*900+100)
n<- round(runif(105)*30+10)
sse<- sep.sys(1000, N, n, 0.02, 0.05, 0.9)
data.frame(N, n, sse[[2]])
}
\keyword{methods}

