% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot3d.R
\name{Plot3d}
\alias{Plot3d}
\title{Plot Points and Surface in 3D}
\usage{
Plot3d(r = NULL, p = NULL, xlim = NULL, ylim = NULL, zlim = NULL,
  vasp = NULL, hasp = NULL, cex.pts = 1, n = NULL,
  color.palette = grDevices::terrain.colors, maxpixels = 5e+05)
}
\arguments{
\item{r}{RasterLayer.
Gridded surface data}

\item{p}{SpatialPointsDataFrame.
Spatial point data}

\item{xlim}{numeric.
Vector of length 2 giving the minimum and maximum values for the \emph{x}-axis.}

\item{ylim}{numeric.
Vector of length 2 giving the minimum and maximum values for the \emph{y}-axis.}

\item{zlim}{numeric.
Vector of length 2 giving the minimum and maximum values for the \emph{z}-axis.}

\item{vasp}{numeric.
The \emph{z/x} aspect ratio for spatial axes.}

\item{hasp}{numeric.
The \emph{y/x} aspect ratio for spatial axes.
Defaults to 1 (one unit on the \emph{x}-axis equals one unit on the \emph{y}-axis) when \code{r} is projected,}

\item{cex.pts}{numeric.
Amount by which point symbols should be magnified relative to the default.}

\item{n}{integer.
Number of contour levels desired.}

\item{color.palette}{function.
Color \link{palette} to be used to assign colors in the plot.}

\item{maxpixels}{integer.
Maximum number of cells to use for the plot.}
}
\value{
Used for the side-effect of a new plot generated.
}
\description{
This function renders raster and point data in three-dimensional (\acronym{3D}) space.
}
\details{
The interpolated surface is rendered using \pkg{rgl},
  a \acronym{3D} visualization device system for \R based on \href{https://www.opengl.org/}{OpenGL}.
  The mouse is used for interactive viewpoint navigation where the left, right, and center mouse buttons rotate the scene,
  rotate the scene around the x-axis, and zooms the display, respectively.
}
\examples{
\dontrun{
  Plot3d()
  rgl::rgl.quit()
}

}
\seealso{
\code{\link{matplot}}, \code{\link{boxplot}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
