% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTCC_function_random.R
\name{rtcc3}
\alias{rtcc3}
\title{Clustering signal significance.}
\usage{
rtcc3(
  table1,
  table2,
  table3,
  species_abundances,
  trait_col_number,
  min_env_col,
  max_env_col,
  env_var_col,
  h_iteration,
  repetitions,
  model
)
}
\arguments{
\item{table1}{A data frame containing organisms names on the first column and its trait values on the
consecutive ones. It also has to contain two columns with the maximum and the minimum values of the tested
environmental variable where the organisms have been observed.}

\item{table2}{A presence-absence observations table with the organisms names on the first column and the
sample names as consecutive colnames.}

\item{table3}{A dataframe containing sample names on the first column and environmental parameters on the
consecutive ones.}

\item{species_abundances}{A vector containing the relative abundance of the organisms on the whole data set on
the same order as appear on Table 1.}

\item{trait_col_number}{Table 1 column number of the tested trait.}

\item{min_env_col}{Table 1 column number indicating the minimum value of the environmental variable were each
organism has been observed.}

\item{max_env_col}{Table 1 column number indicating the maximum value of the environmental variable were each
organism has been observed.}

\item{env_var_col}{Table 2 column number indicating the tested environmental variable.}

\item{h_iteration}{Number of h-index calculations for computing a confidence interval.}

\item{repetitions}{Number of simulated synthetic communities distributions.}

\item{model}{Model selection. All models build synthetic communities based on the organisms richness of the
observed communities.

- Model 1: organism are selected randomly from the global pool.
- Model 2: organism are selected randomly with a probability based on its relative abundance on the global pool.
- Model 3: organism are selected randomly, but only those whose environmental range includes the value of
the simulated community are elegible.
- Model 4: organism are selected randomly, but only those whose environmental range includes the value of
the simulated community are elegible and the selection probability is based on its relative abundance on the global pool.}
}
\value{
The function returns a dataframe with the maximum value of environmental variable corresponding to the same
number of samples on the ordered remova, h-index calculation for each environmental value, and the percentiles 0.025,
0.5 and 0.975 of the obtained distribution for each point (mean value and 95% confidence interval).
}
\description{
For a given trait and environmental variable, this function creates a null model of the
clustering/overdispersion pattern in order to test if the observed pattern statistically
differs from the expected by random. For this, it sequentially remove random samples from
the metacommunity and computes at each step the remaining metacommunity h-index. This index
is based on the percentage of samples on a metacoomunity presenting significant trait
clustering/overdispersion. After h iterations, computes a 95% confidence interval of the
obtained h-index for each point of the environmental gradient.
}
\examples{

\donttest{
data(group_information)
data(table_presence_absence)
data(metadata)
rtcc3(group_information, table_presence_absence, metadata, group_information$sums,
9, 12, 13, 2, 50, 20, model = 1)
}

}
