% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optimization_Rvalue.R
\name{optimize_R}
\alias{optimize_R}
\title{Find the otimum R value for a given data set}
\usage{
optimize_R(object,
max_rigidity = 2^9, average_coverage = NULL, crossovers_per_megabase = NULL,
save_it = FALSE, savedir = NULL)
}
\arguments{
\item{object}{an RTIGER object}

\item{max_rigidity}{R values will be explored up the value given in this parameter. Default = 2^9}

\item{average_coverage}{For conservative results set it to the lowest average coverage of a sample in your experiment, or evne to the lowest average coverage in a (sufficiently large) region in one of your samples. The lower the value, the more conservative (higher) our estimates of the false positive segments rates. If it is not provided it will be computed as the average of all data points.}

\item{crossovers_per_megabase}{For conservative results set it to the highest ratio of a sample in your experiment. The higher the value, the more conservative (higher) our estimates of the false positive segments rates. If it is not provided it will be computed as the average of all samples.}

\item{save_it}{logical values if the results should be saved. Plots might be complicated to interpret. We suggest to read the manuscript to understand them (https://doi.org/10.1093/plphys/kiad191)}

\item{savedir}{if results are saved, in which directory.}
}
\value{
A value with the optimum rigidity for the data set.
}
\description{
Find the otimum R value for a given data set
}
\examples{

data("fittedExample")
bestR = optimize_R(myDat)

}
