% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expAv.R
\name{expAv}
\alias{expAv}
\title{Matrix exponential of sparse matrix multiplied by a vector.}
\usage{
expAv(A, v, transpose = FALSE, uniformization = TRUE, tol = 1e-08, ...)
}
\arguments{
\item{A}{Sparse matrix (usually a generator)}

\item{v}{Vector (or matrix)}

\item{transpose}{Calculate \code{expm(t(A)) \%*\% v} ? (faster due to the way sparse matrices are stored)}

\item{uniformization}{Use uniformization method?}

\item{tol}{Accuracy if A is a generator matrix and v a probability vector.}

\item{...}{Extra configuration parameters}
}
\value{
Vector (or matrix)
}
\description{
Calculates \code{expm(A) \%*\% v} using plain series summation. The number of terms is determined adaptively when \code{uniformization=TRUE}.
The uniformization method essentially pushes the spectrum of the operator inside a zero centered disc, within which a uniform error bound is available.
If \code{A} is a generator matrix (i.e. \code{expm(A)} is a probability matrix) and if \code{v} is a probability vector, then the relative error of the result is bounded by \code{tol}.
}
\details{
Additional supported arguments via \code{...} currently include:
\itemize{
\item \code{Nmax} Use no more than this number of terms even if the spcified accuracy cannot be met.
\item \code{warn} Give warning if number of terms is truncated by \code{Nmax}.
\item \code{trace} Trace the number of terms when it adaptively changes.
}
}
\examples{
set.seed(1); A <- Matrix::rsparsematrix(5, 5, .5)
expAv(A, 1:5) ## Matrix::expm(A) \%*\% 1:5
F <- MakeTape(function(x) expAv(A*x, 1:5), 1)
F(1)
F(2) ## More terms needed => trigger retaping
}
\references{
Grassmann, W. K. (1977). Transient solutions in Markovian queueing systems. \emph{Computers & Operations Research}, 4(1), 47--53.

Sherlock, C. (2021). Direct statistical inference for finite Markov jump processes via the matrix exponential. \emph{Computational Statistics}, 36(4), 2863--2887.
}
