% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.test.R
\name{test_execution}
\alias{test_execution}
\title{Tests Silent Execution of an Function}
\usage{
test_execution(what, args, xmlTestSpec = NULL, ...)
}
\arguments{
\item{what, args}{Parameters for execution of the test function
(see \code{\link{do.call}}).}

\item{xmlTestSpec}{(\code{XMLNode}) The XML definition of type 'RTestTest_variable'.}

\item{...}{Additional parameters passed to \code{\link{do.call}}.}
}
\value{
\code{ANY} result of test functin
}
\description{
Tests Silent Execution of an Function
}
\examples{
value <- test_execution(
      "sum",
      list(x=2,y=3),
      xmlTestSpec=XML::xmlNode(
          name="execution",
          attrs=list('execution-type'="silent"))
)
stopifnot(value==5)

# Create a function that always produces warnings

sum_test <- function(...){
  warning("test")
  sum(...)
}

# Let this function run and crash, if it crashes check if the error contains "produced warnings"

tryCatch(
test_execution(
   "sum_test",
    list(x=2,y=3),
   xmlTestSpec=XML::xmlNode(name="execution",attrs=list("execution-type"="silent"))
 ),error=function(e){
    stopifnot(grepl("produced warnings",e))
 })
}
\seealso{
\code{\link{do.call}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
