% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.input.R
\name{validate.pvals}
\alias{validate.pvals}
\title{Validate Pvalues}
\usage{
validate.pvals(p.min, p.max, p.step)
}
\arguments{
\item{p.min}{The minimum starting FDR cutoff to be checked, so the minimum fold change cutoff to be evaluated
will be p.min + p.step, p.min default = 0.}

\item{p.max}{The maximum FDR cutoff to be checked, default = 0.2.}

\item{p.step}{The step from the minimum to maximum fold change cutoff, one step increase at a time, default = 0.005.}
}
\description{
This function ensures the fold change minimum, maximum, and step
are valid.
}
\details{
Specifically it checks that the pvalues are between 0-1, and that
at least 1 \code{p.step} fits within the \code{p.min} and \code{p.max} bounds and
is positive.
}
\references{
Xingpeng Li, Tatiana Gelaf Romer & Siddhartha Pachhai RVA - RNAseq Visualization Automation tool.
}
