% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gene.R
\name{plot_gene}
\alias{plot_gene}
\title{Plot gene expression}
\usage{
plot_gene(
  data = ~dat,
  anno = ~meta,
  gene.names = c("AAAS", "A2ML1", "AADACL3"),
  ct.table.id.type = "ENSEMBL",
  gene.id.type = "SYMBOL",
  treatment = "Treatment",
  sample.id = "sample_id",
  time = "day",
  log.option = TRUE,
  plot.save.to = NULL,
  input.type = "count"
)
}
\arguments{
\item{data}{Count table in the format of dataframe with gene id as row.names.}

\item{anno}{Annotation table that provides design information.}

\item{gene.names}{Genes to be visualized, in the format of character vector.}

\item{ct.table.id.type}{The gene id format in \code{data} should be one of: ACCNUM, ALIAS, ENSEMBL, ENSEMBLPROT,
ENSEMBLTRANS, ENTREZID, ENZYME, EVIDENCE, EVIDENCEALL, GENENAME, GO, GOALL, IPI, MAP, OMIM,
ONTOLOGY, ONTOLOGYALL, PATH, PFAM, PMID, PROSITE, REFSEQ, SYMBOL, UCSCKG, UNIGENE, UNIPROT.}

\item{gene.id.type}{The gene id format of \code{gene.names}, should be one of: ACCNUM, ALIAS, ENSEMBL, ENSEMBLPROT,
ENSEMBLTRANS, ENTREZID, ENZYME, EVIDENCE, EVIDENCEALL, GENENAME, GO, GOALL, IPI, MAP, OMIM,
ONTOLOGY, ONTOLOGYALL, PATH, PFAM, PMID, PROSITE, REFSEQ, SYMBOL, UCSCKG, UNIGENE, UNIPROT.}

\item{treatment}{The column name to specify treatment groups.}

\item{sample.id}{The column name to specify sample IDs.}

\item{time}{The column name to specify different time points.}

\item{log.option}{Logical option, whether to log2 transform the CPM as y-axis. Default = True.}

\item{plot.save.to}{The address to save the plot from simplified cutoff combination with FDR of 0.01, 0.05, 0.1, and 0.2.}

\item{input.type}{One of \code{count} or \code{cpm} indicating what the input data type is. If \code{count}, the CPM of the input data will be
calculated using \code{\link[edgeR:cpm]{edgeR::cpm()}}. Default = \code{count}.}
}
\value{
The function returns a ggplot object.
}
\description{
This is the function to process the gene count table to show gene expression variations over time or across groups.
}
\details{
The function takes the gene counts and returns a ggplot that shows gene expression variation over time or group.
}
\examples{
plot_gene(data = count_table,
anno = sample_annotation)

}
\references{
Xingpeng Li,Tatiana Gelaf Romer & Aliyah Olaniyan, RVA - RNAseq Visualization Automation tool.
}
