% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetOperations.R, R/package-RVenn.R
\docType{methods}
\name{discern,Venn-method}
\alias{discern,Venn-method}
\alias{discern}
\title{Set difference}
\usage{
\S4method{discern}{Venn}(venn, slice1, slice2 = "all")
}
\arguments{
\item{venn}{(Required) A \code{Venn} object.}

\item{slice1}{(Required) A character or numeric vector to pick sets.}

\item{slice2}{(Optional) A character or numeric vector to pick sets.}
}
\value{
A character or numeric vector showing \eqn{slice1 - slice2}.
}
\description{
\code{discern} returns the difference between two group of sets selected from
a \code{Venn} object.
}
\examples{
venn = construct(list(letters[1:10], letters[3:12], letters[6:15]))
discern(venn, slice1 = 1)
discern(venn, slice1 = c(1, 2), slice2 = 3)
}
