% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loops.R
\name{rx_one_or_more}
\alias{rx_one_or_more}
\title{Match the previous stuff one or more times.}
\usage{
rx_one_or_more(.data = NULL, mode = "greedy")
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{ \%>\% }}

\item{mode}{Matching mode (\code{greedy} (default) or\code{lazy}). \code{Lazy} matching stops after the first match, \code{greedy} continues
searching until end of the string and then back-tracks to the last match.}
}
\description{
This function simply adds a + to the end of the expression.
}
\examples{
rx_one_or_more()

# create an expression
x <- rx() \%>\%
  rx_find("a") \%>\%
  rx_one_or_more()

# create input
input <- "aaa"

# extract match
regmatches(input, regexpr(x, input))
}
