% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rdf.R
\name{read.rdf}
\alias{read.rdf}
\alias{read.rdf2}
\alias{read_rdf}
\title{Read an rdf file into R.}
\usage{
read.rdf(iFile, rdf = TRUE)

read.rdf2(iFile)

read_rdf(iFile, rdf = TRUE)
}
\arguments{
\item{iFile}{The input rdf file that will be read into R.}

\item{rdf}{Boolean; if \code{TRUE}, then an rdf object is returned. If \code{FALSE},
then a character vector is returned.}
}
\value{
An rdf object or character vector.
}
\description{
\code{read.rdf()} reads an rdf file into R and formats it as a multi-level list
containing all of the metadata included in the rdf file.  rdf files are
generated by RiverWare and are documented in the
\href{http://riverware.org/PDF/RiverWare/documentation/}{RiverWare documentation}.
}
\details{
\code{read.rdf()}uses \code{\link[data.table:fread]{data.table::fread()}} to read in the file, which provides
performance benefits as compared to earlier versions of the function.

\code{read.rdf2()} is deprecated and will be removed in a future release.
}
\section{Functions}{
\itemize{
\item \code{read.rdf2}: Deprecated version of \code{read.rdf()}
}}

\examples{
zz <- read_rdf(system.file(
  'extdata/Scenario/ISM1988_2014,2007Dems,IG,Most', 
  "KeySlots.rdf", 
  package = "RWDataPlyr"
))

}
