/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;

public class InstanceSavePanel
extends Panel
implements Serializable,
InstanceListener {
    private Label count_Lab;
    private int m_Count;
    private TextField arffFile_Tex;
    private boolean b_Debug;
    private PrintWriter outputWriter;

    public void input(Instance instance) throws Exception {
        if (this.b_Debug) {
            System.err.println("InstanceSavePanel::input(" + instance + ")");
        }
        ++this.m_Count;
        this.count_Lab.setText("" + this.m_Count + " instances");
        if (this.outputWriter != null) {
            this.outputWriter.println(instance.toString());
        }
    }

    public void inputFormat(Instances instances) {
        if (this.b_Debug) {
            System.err.println("InstanceSavePanel::inputFormat()\n" + instances.toString());
        }
        this.m_Count = 0;
        this.count_Lab.setText("" + this.m_Count + " instances");
        try {
            this.outputWriter = new PrintWriter(new FileOutputStream(this.arffFile_Tex.getText()));
            this.outputWriter.println(instances.toString());
            if (this.b_Debug) {
                System.err.println("InstanceSavePanel::inputFormat() - written header");
            }
        }
        catch (Exception exception) {
            this.outputWriter = null;
            System.err.println("InstanceSavePanel::inputFormat(): " + exception.getMessage());
        }
    }

    public void batchFinished() {
        if (this.b_Debug) {
            System.err.println("InstanceSavePanel::batchFinished()");
        }
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
    }

    public InstanceSavePanel() {
        this.setLayout(new BorderLayout());
        this.arffFile_Tex = new TextField("arffoutput.arff");
        this.add("Center", this.arffFile_Tex);
        this.count_Lab = new Label("0 instances");
        this.add("East", this.count_Lab);
        this.setBackground(Color.lightGray);
    }

    public void setDebug(boolean bl) {
        this.b_Debug = bl;
    }

    public boolean getDebug() {
        return this.b_Debug;
    }

    public void setArffFile(String string) {
        this.arffFile_Tex.setText(string);
    }

    public String getArffFile() {
        return this.arffFile_Tex.getText();
    }

    public void instanceProduced(InstanceEvent instanceEvent) {
        Object object = instanceEvent.getSource();
        if (object instanceof InstanceProducer) {
            try {
                InstanceProducer instanceProducer = (InstanceProducer)object;
                switch (instanceEvent.getID()) {
                    case 1: {
                        this.inputFormat(instanceProducer.outputFormat());
                        break;
                    }
                    case 2: {
                        this.input(instanceProducer.outputPeek());
                        break;
                    }
                    case 3: {
                        this.batchFinished();
                        break;
                    }
                    default: {
                        System.err.println("InstanceSavePanel::instanceProduced() - unknown event type");
                        break;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        } else {
            System.err.println("InstanceSavePanel::instanceProduced() - Unknown source object type");
        }
    }
}

