/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Random;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class AlgVector
implements Cloneable,
Serializable {
    protected double[] m_Elements;

    public AlgVector(int n) {
        this.m_Elements = new double[n];
        this.initialize();
    }

    public AlgVector(double[] dArray) throws Exception {
        this.m_Elements = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.m_Elements[i] = dArray[i];
        }
    }

    public AlgVector(Instances instances, Random random) throws Exception {
        int n = instances.numAttributes();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (instances.attribute(i).isNumeric()) continue;
            --n;
        }
        if (n > 0) {
            this.m_Elements = new double[n];
            this.initialize(random);
        }
    }

    public AlgVector(Instance instance) throws Exception {
        int n;
        int n2 = instance.numAttributes();
        for (n = 0; n < instance.numAttributes(); ++n) {
            if (instance.attribute(n).isNumeric()) continue;
            --n2;
        }
        if (n2 > 0) {
            this.m_Elements = new double[n2];
            for (n = 0; n < n2; ++n) {
                this.m_Elements[n] = instance.valueSparse(n);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AlgVector algVector = (AlgVector)super.clone();
        algVector.m_Elements = new double[this.numElements()];
        for (int i = 0; i < this.numElements(); ++i) {
            algVector.m_Elements[i] = this.m_Elements[i];
        }
        return algVector;
    }

    protected void initialize() {
        for (int i = 0; i < this.m_Elements.length; ++i) {
            this.m_Elements[i] = 0.0;
        }
    }

    protected void initialize(Random random) {
        for (int i = 0; i < this.m_Elements.length; ++i) {
            this.m_Elements[i] = random.nextDouble();
        }
    }

    public final double getElement(int n) {
        return this.m_Elements[n];
    }

    public final int numElements() {
        return this.m_Elements.length;
    }

    public final void setElement(int n, double d) {
        this.m_Elements[n] = d;
    }

    public final void setElements(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.m_Elements[i] = dArray[i];
        }
    }

    public double[] getElements(int n) {
        double[] dArray = new double[this.numElements()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.m_Elements[i];
        }
        return dArray;
    }

    public Instance getAsInstance(Instances instances, Random random) throws Exception {
        Instance instance = new Instance(instances.numAttributes());
        instance.setDataset(instances);
        int n = 0;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (instances.attribute(i).isNumeric()) {
                if (n >= this.m_Elements.length) {
                    throw new Exception("Datatypes are not compatible.");
                }
                instance.setValue(i, this.m_Elements[n++]);
            }
            if (!instances.attribute(i).isNominal()) continue;
            int n2 = (int)(random.nextDouble() * (double)instances.attribute(i).numValues());
            if (n2 == instances.attribute(i).numValues()) {
                --n2;
            }
            instance.setValue(i, (double)n2);
        }
        return instance;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_Elements.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(Utils.doubleToString(this.m_Elements[i], 6));
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public final AlgVector add(AlgVector algVector) {
        AlgVector algVector2;
        int n = this.m_Elements.length;
        try {
            algVector2 = (AlgVector)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            algVector2 = new AlgVector(n);
        }
        for (int i = 0; i < n; ++i) {
            algVector2.m_Elements[i] = this.m_Elements[i] + algVector.m_Elements[i];
        }
        return algVector2;
    }

    public final AlgVector substract(AlgVector algVector) {
        AlgVector algVector2;
        int n = this.m_Elements.length;
        try {
            algVector2 = (AlgVector)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            algVector2 = new AlgVector(n);
        }
        for (int i = 0; i < n; ++i) {
            algVector2.m_Elements[i] = this.m_Elements[i] - algVector.m_Elements[i];
        }
        return algVector2;
    }

    public final double dotMultiply(AlgVector algVector) {
        int n = this.m_Elements.length;
        int n2 = algVector.m_Elements.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.m_Elements[i] * algVector.m_Elements[i];
        }
        return d;
    }

    public final void scalarMultiply(double d) {
        int n = this.m_Elements.length;
        for (int i = 0; i < n; ++i) {
            this.m_Elements[i] = d * this.m_Elements[i];
        }
    }

    public void changeLength(double d) {
        double d2 = this.norm();
        d2 = d / d2;
        this.scalarMultiply(d2);
    }

    public double norm() {
        int n = this.m_Elements.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.m_Elements[i] * this.m_Elements[i];
        }
        return Math.pow(d, 0.5);
    }

    public final void normVector() {
        double d = this.norm();
        this.scalarMultiply(1.0 / d);
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{2.3, 1.2, 5.0};
        try {
            AlgVector algVector = new AlgVector(dArray);
            System.out.println("test:\n " + algVector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

