/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.SerializedObject;
import weka.filters.Filter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.PropertyText;
import weka.gui.PropertyValueSelector;

public class GenericArrayEditor
extends JPanel
implements PropertyEditor {
    private PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    private JLabel m_Label = new JLabel("Can't edit", 0);
    private JList m_ElementList = new JList();
    private Class m_ElementClass = class$java$lang$String == null ? (class$java$lang$String = GenericArrayEditor.class$("java.lang.String")) : class$java$lang$String;
    private DefaultListModel m_ListModel;
    private PropertyEditor m_ElementEditor;
    private JButton m_DeleteBut = new JButton("Delete");
    private JButton m_EditBut = new JButton("Edit");
    private JButton m_AddBut = new JButton("Add");
    private PropertyEditor m_Editor = new GenericObjectEditor();
    private PropertyDialog m_PD;
    private ActionListener m_InnerActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GenericArrayEditor.this.m_DeleteBut) {
                int[] nArray = GenericArrayEditor.this.m_ElementList.getSelectedIndices();
                if (nArray != null) {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n = nArray[i];
                        GenericArrayEditor.this.m_ListModel.removeElementAt(n);
                        if (GenericArrayEditor.this.m_ListModel.size() <= n) continue;
                        GenericArrayEditor.this.m_ElementList.setSelectedIndex(n);
                    }
                    GenericArrayEditor.this.m_Support.firePropertyChange("", null, null);
                }
            } else if (actionEvent.getSource() == GenericArrayEditor.this.m_EditBut) {
                ((GenericObjectEditor)GenericArrayEditor.this.m_Editor).setClassType(GenericArrayEditor.this.m_ElementClass);
                GenericArrayEditor.this.m_Editor.setValue(GenericArrayEditor.this.m_ElementList.getSelectedValue());
                if (GenericArrayEditor.this.m_Editor.getValue() != null) {
                    if (GenericArrayEditor.this.m_PD == null) {
                        int n = GenericArrayEditor.this.getLocationOnScreen().x;
                        int n2 = GenericArrayEditor.this.getLocationOnScreen().y;
                        GenericArrayEditor.this.m_PD = new PropertyDialog(GenericArrayEditor.this.m_Editor, n, n2);
                    } else {
                        GenericArrayEditor.this.m_PD.setVisible(true);
                    }
                    GenericArrayEditor.this.m_ElementList.setSelectedValue(GenericArrayEditor.this.m_Editor.getValue(), false);
                    GenericArrayEditor.this.m_Support.firePropertyChange("", null, null);
                }
            } else if (actionEvent.getSource() == GenericArrayEditor.this.m_AddBut) {
                int n = GenericArrayEditor.this.m_ElementList.getSelectedIndex();
                Object object = GenericArrayEditor.this.m_ElementEditor.getValue();
                try {
                    SerializedObject serializedObject = new SerializedObject(object);
                    object = serializedObject.getObject();
                    if (n != -1) {
                        GenericArrayEditor.this.m_ListModel.insertElementAt(object, n);
                    } else {
                        GenericArrayEditor.this.m_ListModel.addElement(object);
                    }
                    GenericArrayEditor.this.m_Support.firePropertyChange("", null, null);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(GenericArrayEditor.this, "Could not create an object copy", null, 0);
                }
            }
        }
    };
    private ListSelectionListener m_InnerSelectionListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == GenericArrayEditor.this.m_ElementList) {
                if (GenericArrayEditor.this.m_ElementList.getSelectedIndex() != -1) {
                    GenericArrayEditor.this.m_DeleteBut.setEnabled(true);
                    GenericArrayEditor.this.m_EditBut.setEnabled(GenericArrayEditor.this.m_ElementList.getSelectedIndices().length == 1);
                } else {
                    GenericArrayEditor.this.m_DeleteBut.setEnabled(false);
                    GenericArrayEditor.this.m_EditBut.setEnabled(false);
                }
            }
        }
    };
    private MouseListener m_InnerMouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getSource() == GenericArrayEditor.this.m_ElementList && mouseEvent.getClickCount() == 2 && (n = GenericArrayEditor.this.m_ElementList.locationToIndex(mouseEvent.getPoint())) > -1) {
                GenericArrayEditor.this.m_InnerActionListener.actionPerformed(new ActionEvent(GenericArrayEditor.this.m_EditBut, 0, ""));
            }
        }
    };
    static /* synthetic */ Class class$java$lang$String;

    public GenericArrayEditor() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_Label, "Center");
        this.m_DeleteBut.addActionListener(this.m_InnerActionListener);
        this.m_EditBut.addActionListener(this.m_InnerActionListener);
        this.m_AddBut.addActionListener(this.m_InnerActionListener);
        this.m_ElementList.addListSelectionListener(this.m_InnerSelectionListener);
        this.m_ElementList.addMouseListener(this.m_InnerMouseListener);
        this.m_AddBut.setToolTipText("Add the current item to the list");
        this.m_DeleteBut.setToolTipText("Delete the selected list item");
        this.m_EditBut.setToolTipText("Edit the selected list item");
    }

    private void updateEditorType(Object object) {
        this.m_ElementEditor = null;
        this.m_ListModel = null;
        this.removeAll();
        if (object != null && object.getClass().isArray()) {
            Class<?> clazz = object.getClass().getComponentType();
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
            JComponent jComponent = null;
            ListCellRenderer<Object> listCellRenderer = new DefaultListCellRenderer();
            if (propertyEditor != null) {
                if (propertyEditor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)propertyEditor).setClassType(clazz);
                }
                if (Array.getLength(object) > 0) {
                    propertyEditor.setValue(Array.get(object, 0));
                } else if (propertyEditor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)propertyEditor).setDefaultValue();
                } else {
                    try {
                        propertyEditor.setValue(clazz.newInstance());
                    }
                    catch (Exception exception) {
                        this.m_ElementEditor = null;
                        System.err.println(exception.getMessage());
                        this.add((Component)this.m_Label, "Center");
                        this.m_Support.firePropertyChange("", null, null);
                        this.validate();
                        return;
                    }
                }
                if (propertyEditor.isPaintable() && propertyEditor.supportsCustomEditor()) {
                    jComponent = new PropertyPanel(propertyEditor);
                    listCellRenderer = new EditorListCellRenderer(propertyEditor.getClass(), clazz);
                } else if (propertyEditor.getTags() != null) {
                    jComponent = new PropertyValueSelector(propertyEditor);
                } else if (propertyEditor.getAsText() != null) {
                    jComponent = new PropertyText(propertyEditor);
                }
            }
            if (jComponent == null) {
                System.err.println("No property editor for class: " + clazz.getName());
            } else {
                this.m_ElementEditor = propertyEditor;
                this.m_ListModel = new DefaultListModel();
                this.m_ElementClass = clazz;
                for (int i = 0; i < Array.getLength(object); ++i) {
                    this.m_ListModel.addElement(Array.get(object, i));
                }
                this.m_ElementList.setCellRenderer(listCellRenderer);
                this.m_ElementList.setModel(this.m_ListModel);
                if (this.m_ListModel.getSize() > 0) {
                    this.m_ElementList.setSelectedIndex(0);
                } else {
                    this.m_DeleteBut.setEnabled(false);
                    this.m_EditBut.setEnabled(false);
                }
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)jComponent, "Center");
                jPanel.add((Component)this.m_AddBut, "East");
                this.add((Component)jPanel, "North");
                this.add((Component)new JScrollPane(this.m_ElementList), "Center");
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridLayout(1, 2));
                jPanel2.add(this.m_DeleteBut);
                jPanel2.add(this.m_EditBut);
                this.add((Component)jPanel2, "South");
                this.m_ElementEditor.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        GenericArrayEditor.this.repaint();
                    }
                });
            }
        }
        if (this.m_ElementEditor == null) {
            this.add((Component)this.m_Label, "Center");
        }
        this.m_Support.firePropertyChange("", null, null);
        this.validate();
    }

    public void setValue(Object object) {
        this.updateEditorType(object);
    }

    public Object getValue() {
        if (this.m_ListModel == null) {
            return null;
        }
        int n = this.m_ListModel.getSize();
        Object object = Array.newInstance(this.m_ElementClass, n);
        for (int i = 0; i < n; ++i) {
            Array.set(object, i, this.m_ListModel.elementAt(i));
        }
        return object;
    }

    public String getJavaInitializationString() {
        return "null";
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        String string = this.m_ListModel.getSize() + " " + this.m_ElementClass.getName();
        graphics.drawString(string, 2, fontMetrics.getHeight() + n);
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) {
        throw new IllegalArgumentException(string);
    }

    public String[] getTags() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.removePropertyChangeListener(propertyChangeListener);
    }

    public static void main(String[] stringArray) {
        try {
            GenericObjectEditor.registerEditors();
            GenericArrayEditor genericArrayEditor = new GenericArrayEditor();
            Filter[] filterArray = new Filter[]{};
            PropertyDialog propertyDialog = new PropertyDialog(genericArrayEditor, 100, 100);
            propertyDialog.setSize(200, 200);
            propertyDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            genericArrayEditor.setValue(filterArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class EditorListCellRenderer
    implements ListCellRenderer {
        private Class m_EditorClass;
        private Class m_ValueClass;

        public EditorListCellRenderer(Class clazz, Class clazz2) {
            this.m_EditorClass = clazz;
            this.m_ValueClass = clazz2;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            try {
                PropertyEditor propertyEditor = (PropertyEditor)this.m_EditorClass.newInstance();
                if (propertyEditor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)propertyEditor).setClassType(this.m_ValueClass);
                }
                propertyEditor.setValue(object);
                return new JPanel(this, bl, jList, propertyEditor){
                    private final /* synthetic */ boolean val$isSelected;
                    private final /* synthetic */ JList val$list;
                    private final /* synthetic */ PropertyEditor val$e;
                    private final /* synthetic */ EditorListCellRenderer this$1;
                    {
                        this.this$1 = editorListCellRenderer;
                        this.val$isSelected = bl;
                        this.val$list = jList;
                        this.val$e = propertyEditor;
                    }

                    public void paintComponent(Graphics graphics) {
                        Insets insets = this.getInsets();
                        Rectangle rectangle = new Rectangle(insets.left, insets.top, this.getWidth() - insets.right, this.getHeight() - insets.bottom);
                        graphics.setColor(this.val$isSelected ? this.val$list.getSelectionBackground() : this.val$list.getBackground());
                        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                        graphics.setColor(this.val$isSelected ? this.val$list.getSelectionForeground() : this.val$list.getForeground());
                        this.val$e.paintValue(graphics, rectangle);
                    }

                    public Dimension getPreferredSize() {
                        Font font = this.getFont();
                        FontMetrics fontMetrics = this.getFontMetrics(font);
                        return new Dimension(0, fontMetrics.getHeight());
                    }
                };
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

