/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class Add
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = 761386447332932389L;
    protected int m_AttributeType = 0;
    protected String m_Name = "unnamed";
    private SingleIndex m_Insert = new SingleIndex("last");
    protected FastVector m_Labels = new FastVector(5);

    public String globalInfo() {
        return "An instance filter that adds a new attribute to the dataset. The new attribute will contain all missing values.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tSpecify where to insert the column. First and last\n\tare valid indexes.(default last)", "C", 1, "-C <index>"));
        vector.addElement(new Option("\tCreate nominal attribute with given labels\n\t(default numeric attribute)", "L", 1, "-L <label1,label2,...>"));
        vector.addElement(new Option("\tName of the new attribute.\n\t(default = 'Unnamed')", "N", 1, "-N <name>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setAttributeIndex(Utils.getOption('C', stringArray));
        this.setNominalLabels(Utils.getOption('L', stringArray));
        this.setAttributeName(Utils.getOption('N', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        stringArray[n++] = "-N";
        stringArray[n++] = this.getAttributeName();
        if (this.m_AttributeType == 1) {
            stringArray[n++] = "-L";
            stringArray[n++] = this.getNominalLabels();
        }
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getAttributeIndex();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_Insert.setUpper(instances.numAttributes());
        Instances instances2 = new Instances(instances, 0);
        Attribute attribute = null;
        switch (this.m_AttributeType) {
            case 0: {
                attribute = new Attribute(this.m_Name);
                break;
            }
            case 1: {
                attribute = new Attribute(this.m_Name, this.m_Labels);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown attribute type in Add");
            }
        }
        if (this.m_Insert.getIndex() < 0 || this.m_Insert.getIndex() > this.getInputFormat().numAttributes()) {
            throw new IllegalArgumentException("Index out of range");
        }
        instances2.insertAttributeAt(attribute, this.m_Insert.getIndex());
        this.setOutputFormat(instances2);
        Range range = new Range(this.m_Insert.getSingleIndex());
        range.setInvert(true);
        range.setUpper(instances2.numAttributes() - 1);
        this.initOutputLocators(instances2, range.getSelection());
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Instance instance2 = (Instance)instance.copy();
        this.copyValues(instance2, true, instance2.dataset(), this.getOutputFormat());
        instance2.setDataset(null);
        instance2.insertAttributeAt(this.m_Insert.getIndex());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
        return true;
    }

    public String attributeNameTipText() {
        return "Set the new attribute's name.";
    }

    public String getAttributeName() {
        return this.m_Name;
    }

    public void setAttributeName(String string) {
        String string2 = string.trim();
        if (string2.indexOf(32) >= 0) {
            if (string2.indexOf(39) != 0) {
                string2 = string2.replace('\'', ' ');
            }
            string2 = '\'' + string2 + '\'';
        }
        if (string2.equals("")) {
            string2 = "unnamed";
        }
        this.m_Name = string2;
    }

    public String attributeIndexTipText() {
        return "The position (starting from 1) where the attribute will be inserted (first and last are valid indices).";
    }

    public String getAttributeIndex() {
        return this.m_Insert.getSingleIndex();
    }

    public void setAttributeIndex(String string) {
        this.m_Insert.setSingleIndex(string);
    }

    public String nominalLabelsTipText() {
        return "The list of value labels (nominal attribute creation only).  The list must be comma-separated, eg: \"red,green,blue\". If this is empty, the created attribute will be numeric.";
    }

    public String getNominalLabels() {
        String string = "";
        for (int i = 0; i < this.m_Labels.size(); ++i) {
            string = i == 0 ? (String)this.m_Labels.elementAt(i) : string + "," + (String)this.m_Labels.elementAt(i);
        }
        return string;
    }

    public void setNominalLabels(String string) {
        String string2;
        int n;
        FastVector fastVector = new FastVector(10);
        while ((n = string.indexOf(44)) >= 0) {
            string2 = string.substring(0, n).trim();
            if (string2.equals("")) {
                throw new IllegalArgumentException("Invalid label list at " + string.substring(n));
            }
            fastVector.addElement(string2);
            string = string.substring(n + 1);
        }
        string2 = string.trim();
        if (!string2.equals("")) {
            fastVector.addElement(string2);
        }
        this.m_Labels = fastVector;
        this.m_AttributeType = fastVector.size() == 0 ? 0 : 1;
    }

    public static void main(String[] stringArray) {
        Add.runFilter(new Add(), stringArray);
    }
}

