/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Random;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.bayes.NaiveBayesUpdateable;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.NBTreeNoSplit;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class NBTreeSplit
extends ClassifierSplitModel {
    private static final long serialVersionUID = 8922627123884975070L;
    private int m_complexityIndex;
    private int m_attIndex;
    private int m_minNoObj;
    private double m_splitPoint;
    private double m_sumOfWeights;
    private double m_errors;
    private C45Split m_c45S;
    NBTreeNoSplit m_globalNB;

    public NBTreeSplit(int n, int n2, double d) {
        this.m_attIndex = n;
        this.m_minNoObj = n2;
        this.m_sumOfWeights = d;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.m_numSubsets = 0;
        this.m_splitPoint = Double.MAX_VALUE;
        this.m_errors = 0.0;
        if (this.m_globalNB != null) {
            this.m_errors = this.m_globalNB.getErrors();
        }
        if (instances.attribute(this.m_attIndex).isNominal()) {
            this.m_complexityIndex = instances.attribute(this.m_attIndex).numValues();
            this.handleEnumeratedAttribute(instances);
        } else {
            this.m_complexityIndex = 2;
            instances.sort(instances.attribute(this.m_attIndex));
            this.handleNumericAttribute(instances);
        }
    }

    public final int attIndex() {
        return this.m_attIndex;
    }

    private void handleEnumeratedAttribute(Instances instances) throws Exception {
        int n;
        int n2;
        this.m_c45S = new C45Split(this.m_attIndex, 2, this.m_sumOfWeights);
        this.m_c45S.buildClassifier(instances);
        if (this.m_c45S.numSubsets() == 0) {
            return;
        }
        this.m_errors = 0.0;
        Instances[] instancesArray = new Instances[this.m_complexityIndex];
        for (n2 = 0; n2 < this.m_complexityIndex; ++n2) {
            instancesArray[n2] = new Instances(instances, 0);
        }
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            n2 = this.m_c45S.whichSubset(instance);
            if (n2 > -1) {
                instancesArray[n2].add((Instance)instance.copy());
                continue;
            }
            double[] dArray = this.m_c45S.weights(instance);
            for (n = 0; n < this.m_complexityIndex; ++n) {
                try {
                    Instance instance2 = (Instance)instance.copy();
                    if (dArray.length == this.m_complexityIndex) {
                        instance2.setWeight(instance2.weight() * dArray[n]);
                    } else {
                        instance2.setWeight(instance2.weight() / (double)this.m_complexityIndex);
                    }
                    instancesArray[n].add(instance2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println("*** " + this.m_complexityIndex);
                    System.err.println(dArray.length);
                    System.exit(1);
                }
            }
        }
        Random random = new Random(1L);
        int n3 = 0;
        for (n = 0; n < this.m_complexityIndex; ++n) {
            if (instancesArray[n].numInstances() >= 5) {
                ++n3;
                Discretize discretize = new Discretize();
                discretize.setInputFormat(instancesArray[n]);
                instancesArray[n] = Filter.useFilter(instancesArray[n], discretize);
                instancesArray[n].randomize(random);
                instancesArray[n].stratify(5);
                NaiveBayesUpdateable naiveBayesUpdateable = new NaiveBayesUpdateable();
                naiveBayesUpdateable.buildClassifier(instancesArray[n]);
                this.m_errors += NBTreeNoSplit.crossValidate(naiveBayesUpdateable, instancesArray[n], random);
                continue;
            }
            for (int i = 0; i < instancesArray[n].numInstances(); ++i) {
                this.m_errors += instancesArray[n].instance(i).weight();
            }
        }
        if (n3 > 1) {
            this.m_numSubsets = this.m_complexityIndex;
        }
    }

    private void handleNumericAttribute(Instances instances) throws Exception {
        RevisionHandler revisionHandler;
        this.m_c45S = new C45Split(this.m_attIndex, 2, this.m_sumOfWeights);
        this.m_c45S.buildClassifier(instances);
        if (this.m_c45S.numSubsets() == 0) {
            return;
        }
        this.m_errors = 0.0;
        Instances[] instancesArray = new Instances[this.m_complexityIndex];
        instancesArray[0] = new Instances(instances, 0);
        instancesArray[1] = new Instances(instances, 0);
        int n = -1;
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            n = this.m_c45S.whichSubset(instance);
            if (n != -1) {
                instancesArray[n].add((Instance)instance.copy());
                continue;
            }
            double[] dArray = this.m_c45S.weights(instance);
            for (int j = 0; j < this.m_complexityIndex; ++j) {
                revisionHandler = (Instance)instance.copy();
                if (dArray.length == this.m_complexityIndex) {
                    ((Instance)revisionHandler).setWeight(((Instance)revisionHandler).weight() * dArray[j]);
                } else {
                    ((Instance)revisionHandler).setWeight(((Instance)revisionHandler).weight() / (double)this.m_complexityIndex);
                }
                instancesArray[j].add((Instance)revisionHandler);
            }
        }
        Random random = new Random(1L);
        int n2 = 0;
        for (int i = 0; i < this.m_complexityIndex; ++i) {
            if (instancesArray[i].numInstances() > 5) {
                ++n2;
                Discretize discretize = new Discretize();
                discretize.setInputFormat(instancesArray[i]);
                instancesArray[i] = Filter.useFilter(instancesArray[i], discretize);
                instancesArray[i].randomize(random);
                instancesArray[i].stratify(5);
                revisionHandler = new NaiveBayesUpdateable();
                ((NaiveBayes)revisionHandler).buildClassifier(instancesArray[i]);
                this.m_errors += NBTreeNoSplit.crossValidate((NaiveBayesUpdateable)revisionHandler, instancesArray[i], random);
                continue;
            }
            for (int j = 0; j < instancesArray[i].numInstances(); ++j) {
                this.m_errors += instancesArray[i].instance(j).weight();
            }
        }
        if (n2 > 1) {
            this.m_numSubsets = this.m_complexityIndex;
        }
    }

    public final int whichSubset(Instance instance) throws Exception {
        return this.m_c45S.whichSubset(instance);
    }

    public final double[] weights(Instance instance) {
        return this.m_c45S.weights(instance);
    }

    public final String sourceExpression(int n, Instances instances) {
        return this.m_c45S.sourceExpression(n, instances);
    }

    public final String rightSide(int n, Instances instances) {
        return this.m_c45S.rightSide(n, instances);
    }

    public final String leftSide(Instances instances) {
        return this.m_c45S.leftSide(instances);
    }

    public double classProb(int n, Instance instance, int n2) throws Exception {
        if (n2 > -1) {
            return this.m_globalNB.classProb(n, instance, n2);
        }
        throw new Exception("This shouldn't happen!!!");
    }

    public NBTreeNoSplit getGlobalModel() {
        return this.m_globalNB;
    }

    public void setGlobalModel(NBTreeNoSplit nBTreeNoSplit) {
        this.m_globalNB = nBTreeNoSplit;
    }

    public double getErrors() {
        return this.m_errors;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }
}

