/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class NominalToString
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 8655492378380068939L;
    private Range m_AttIndex = new Range("last");

    public String globalInfo() {
        return "Converts a nominal attribute (i.e. set number of values) to string (i.e. unspecified number of values).";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_AttIndex.setUpper(instances.numAttributes() - 1);
        return false;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isOutputFormatDefined()) {
            Instance instance2 = (Instance)instance.copy();
            this.push(instance2);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isOutputFormatDefined()) {
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.push((Instance)this.getInputFormat().instance(i).copy());
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSets the range of attributes to convert (default last).", "C", 1, "-C <col>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndexes(string);
        } else {
            this.setAttributeIndexes("last");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-C");
        vector.add("" + this.getAttributeIndexes());
        return vector.toArray(new String[vector.size()]);
    }

    public String attributeIndexesTipText() {
        return "Sets a range attributes to process. Any non-nominal attributes in the range are left untouched (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndexes() {
        return this.m_AttIndex.getRanges();
    }

    public void setAttributeIndexes(String string) {
        this.m_AttIndex.setRanges(string);
    }

    private void setOutputFormat() {
        FastVector fastVector = new FastVector(this.getInputFormat().numAttributes());
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            Attribute attribute = this.getInputFormat().attribute(i);
            if (!attribute.isNominal() || !this.m_AttIndex.isInRange(i)) {
                fastVector.addElement(attribute);
                continue;
            }
            fastVector.addElement(new Attribute(attribute.name(), (FastVector)null));
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(instances);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }

    public static void main(String[] stringArray) {
        NominalToString.runFilter(new NominalToString(), stringArray);
    }
}

