/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScatterSearchV1
extends ASSearch
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -8512041420388121326L;
    private int m_numAttribs;
    private int m_classIndex;
    private double m_treshold;
    private double m_initialThreshold;
    int m_typeOfCombination;
    private Random m_random;
    private int m_seed;
    private boolean m_debug = false;
    private StringBuffer m_InformationReports;
    private int m_totalEvals;
    protected double m_bestMerit;
    private long m_processinTime;
    private List<Subset> m_population;
    private int m_popSize;
    private int m_initialPopSize;
    private int m_calculatedInitialPopSize;
    private transient List<Subset> m_ReferenceSet;
    private transient List<Subset> m_parentsCombination;
    private List<Subset> m_attributeRanking;
    private SubsetEvaluator ASEvaluator = null;
    protected static final int COMBINATION_NOT_REDUCED = 0;
    protected static final int COMBINATION_REDUCED = 1;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(0, "Greedy Combination"), new Tag(1, "Reduced Greedy Combination")};

    public String globalInfo() {
        return "Scatter Search :\n\nPerforms an Scatter Search  through the space of attribute subsets. Start with a population of many significants and diverses subset  stops when the result is higher than a given treshold or there's not more improvement\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "F\u00c8lix Garc\u00cca L\u00dbpez");
        technicalInformation.setValue(TechnicalInformation.Field.MONTH, "October");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2004");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Solving feature subset selection problem by a Parallel Scatter Search");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Elsevier");
        technicalInformation.setValue(TechnicalInformation.Field.LANGUAGE, "English");
        return technicalInformation;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.0$");
    }

    public ScatterSearchV1() {
        this.resetOptions();
    }

    public String tresholdTipText() {
        return "Set the treshold that subsets most overcome to be considered as significants";
    }

    public void setTreshold(double d) {
        this.m_initialThreshold = d;
    }

    public double getTreshold() {
        return this.m_initialThreshold;
    }

    public String populationSizeTipText() {
        return "Set the number of subset to generate in the initial Population";
    }

    public void setPopulationSize(int n) {
        this.m_initialPopSize = n;
    }

    public int getPopulationSize() {
        return this.m_initialPopSize;
    }

    public String combinationTipText() {
        return "Set the kind of combination for using it to combine ReferenceSet subsets.";
    }

    public void setCombination(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_SELECTION) {
            this.m_typeOfCombination = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getCombination() {
        return new SelectedTag(this.m_typeOfCombination, TAGS_SELECTION);
    }

    public String seedTipText() {
        return "Set the random seed.";
    }

    public void setSeed(int n) {
        this.m_seed = n;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public String debugTipText() {
        return "Turn on verbose output for monitoring the search's progress.";
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public boolean getDebug() {
        return this.m_debug;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option("\tSpecify the number of subsets to generate \n\tin the initial population..", "Z", 1, "-Z <num>"));
        vector.addElement(new Option("\tSpecify the treshold used for considering when a subset is significant.", "T", 1, "-T <threshold>"));
        vector.addElement(new Option("\tSpecify the kind of combiantion \n\tfor using it in the combination method.", "R", 1, "-R <0 = greedy combination | 1 = reduced greedy combination >"));
        vector.addElement(new Option("\tSet the random number seed.\n\t(default = 1)", "S", 1, "-S <seed>"));
        vector.addElement(new Option("\tVerbose output for monitoring the search.", "D", 0, "-D"));
        return vector.elements();
    }

    @Override
    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('Z', stringArray);
        if (string.length() != 0) {
            this.setPopulationSize(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('T', stringArray)).length() != 0) {
            this.setTreshold(Double.parseDouble(string));
        }
        if ((string = Utils.getOption('R', stringArray)).length() != 0) {
            this.setCombination(new SelectedTag(Integer.parseInt(string), TAGS_SELECTION));
        } else {
            this.setCombination(new SelectedTag(0, TAGS_SELECTION));
        }
        string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSeed(Integer.parseInt(string));
        }
        this.setDebug(Utils.getFlag('D', stringArray));
    }

    @Override
    public String[] getOptions() {
        String[] stringArray = new String[9];
        int n = 0;
        stringArray[n++] = "-T";
        stringArray[n++] = "" + this.getTreshold();
        stringArray[n++] = "-Z";
        stringArray[n++] = "" + this.getPopulationSize();
        stringArray[n++] = "-R";
        stringArray[n++] = "" + String.valueOf(this.getCombination().getSelectedTag().getID());
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSeed();
        if (this.getDebug()) {
            stringArray[n++] = "-D";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tScatter Search \n\tInit Population: " + this.m_calculatedInitialPopSize);
        stringBuffer.append("\n\tKind of Combination: " + this.getCombination().getSelectedTag().getReadable());
        stringBuffer.append("\n\tRandom number seed: " + this.m_seed);
        stringBuffer.append("\n\tDebug: " + this.m_debug);
        stringBuffer.append("\n\tTreshold: " + Utils.doubleToString(Math.abs(this.getTreshold()), 8, 3) + "\n");
        stringBuffer.append("\tTotal number of subsets evaluated: " + this.m_totalEvals + "\n");
        stringBuffer.append("\tMerit of best subset found: " + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        if (this.m_debug) {
            return stringBuffer.toString() + "\n\n" + this.m_InformationReports.toString();
        }
        return stringBuffer.toString();
    }

    @Override
    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        int n;
        int n2;
        this.m_totalEvals = 0;
        this.m_popSize = this.m_initialPopSize;
        this.m_calculatedInitialPopSize = this.m_initialPopSize;
        this.m_treshold = this.m_initialThreshold;
        this.m_processinTime = System.currentTimeMillis();
        this.m_InformationReports = new StringBuffer();
        this.m_numAttribs = instances.numAttributes();
        this.m_classIndex = instances.classIndex();
        if (this.m_popSize <= 0) {
            this.m_calculatedInitialPopSize = this.m_popSize = this.m_numAttribs / 2;
        }
        this.ASEvaluator = (SubsetEvaluator)((Object)aSEvaluation);
        if (!(this.m_treshold >= 0.0)) {
            this.m_treshold = this.calculateTreshhold();
            ++this.m_totalEvals;
        }
        this.m_random = new Random(this.m_seed);
        this.m_attributeRanking = this.RankEachAttribute();
        this.CreatePopulation(this.m_popSize);
        int n3 = this.m_popSize / 4;
        int n4 = this.m_popSize / 4;
        if (this.m_popSize < 4) {
            n3 = this.m_popSize / 2;
            n4 = this.m_popSize / 2;
            if (this.m_popSize == 1) {
                return this.attributeList(this.m_population.get((int)0).subset);
            }
        }
        this.m_ReferenceSet = new ArrayList<Subset>();
        for (n2 = 0; n2 < this.m_population.size(); ++n2) {
            this.m_ReferenceSet.add(this.m_population.get(n2));
        }
        this.GenerateReferenceSet(this.m_ReferenceSet, n3, n4);
        this.m_InformationReports.append("Population: " + this.m_population.size() + "\n");
        this.m_InformationReports.append("merit    \tsubset\n");
        for (n2 = 0; n2 < this.m_population.size(); ++n2) {
            this.m_InformationReports.append(this.printSubset(this.m_population.get(n2)));
        }
        this.m_ReferenceSet = this.m_ReferenceSet.subList(0, n3 + n4);
        this.m_InformationReports.append("\nReferenceSet:");
        this.m_InformationReports.append("\n----------------Most Significants Solutions--------------\n");
        for (n2 = 0; n2 < this.m_ReferenceSet.size(); ++n2) {
            if (n2 == n3) {
                this.m_InformationReports.append("----------------Most Diverses Solutions--------------\n");
            }
            this.m_InformationReports.append(this.printSubset(this.m_ReferenceSet.get(n2)));
        }
        Subset subset = new Subset(new BitSet(this.m_numAttribs), 0.0);
        while (!subset.isEqual(this.m_ReferenceSet.get(0))) {
            this.CombineParents();
            this.ImproveSolutions();
            subset = this.m_ReferenceSet.get(0);
            n = this.m_ReferenceSet.size() / 2;
            int n5 = this.m_ReferenceSet.size() / 2;
            this.UpdateReferenceSet(n, n5);
            this.m_ReferenceSet = this.m_ReferenceSet.subList(0, n + n5);
        }
        this.m_InformationReports.append("\nLast Reference Set Updated:\n");
        this.m_InformationReports.append("merit    \tsubset\n");
        for (n = 0; n < this.m_ReferenceSet.size(); ++n) {
            this.m_InformationReports.append(this.printSubset(this.m_ReferenceSet.get(n)));
        }
        this.m_bestMerit = subset.merit;
        this.m_processinTime = System.currentTimeMillis() - this.m_processinTime;
        return this.attributeList(subset.subset);
    }

    public void GenerateReferenceSet(List<Subset> list, int n, int n2) {
        list = this.bubbleSubsetSort(list);
        BitSet bitSet = this.getAllBits(list.subList(0, n));
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n5 = n3; n5 < list.size(); ++n5) {
                arrayList.add(this.SimetricDiference(list.get(n5).clone(), bitSet));
            }
            n5 = this.getIndexofBiggest(arrayList);
            list.set(n3, list.get(n3 + n5));
            bitSet = this.getAllBits(list.subList(0, ++n3));
        }
        list = this.filterSubset(list, n3);
    }

    public void UpdateReferenceSet(int n, int n2) {
        for (int i = 0; i < this.m_parentsCombination.size(); ++i) {
            this.m_ReferenceSet.add(i, this.m_parentsCombination.get(i));
        }
        this.GenerateReferenceSet(this.m_ReferenceSet, n, n2);
    }

    public void ImproveSolutions() throws Exception {
        for (int i = 0; i < this.m_parentsCombination.size(); ++i) {
            BitSet bitSet = (BitSet)this.m_parentsCombination.get((int)i).subset.clone();
            ArrayList arrayList = new ArrayList();
            for (int j = 0; j < this.m_attributeRanking.size(); ++j) {
                Subset subset = this.m_attributeRanking.get(j).clone();
                BitSet bitSet2 = (BitSet)subset.subset.clone();
                Subset subset2 = this.m_parentsCombination.get(i).clone();
                BitSet bitSet3 = (BitSet)subset2.subset.clone();
                if (bitSet3.get(bitSet2.nextSetBit(0))) continue;
                bitSet3.or(bitSet2);
                double d = this.ASEvaluator.evaluateSubset(bitSet3);
                ++this.m_totalEvals;
                if (d <= subset2.merit) break;
                this.m_parentsCombination.set(i, new Subset(bitSet3, d));
            }
            this.filterSubset(this.m_parentsCombination, this.m_ReferenceSet.size());
        }
    }

    public void CombineParents() throws Exception {
        this.m_parentsCombination = new ArrayList<Subset>();
        for (int i = 0; i < this.m_ReferenceSet.size() - 1; ++i) {
            for (int j = i + 1; j < this.m_ReferenceSet.size(); ++j) {
                Subset subset = this.m_ReferenceSet.get(i);
                Subset subset2 = this.m_ReferenceSet.get(j);
                Subset subset3 = this.intersectSubsets(subset, subset2);
                Subset subset4 = subset3.clone();
                Subset subset5 = this.simetricDif(subset, subset2, this.getCombination().getSelectedTag().getID());
                BitSet bitSet = (BitSet)subset5.subset.clone();
                boolean bl = true;
                while (bl) {
                    Subset subset6 = this.getBestgen(subset3, bitSet);
                    Subset subset7 = this.getBestgen(subset4, bitSet);
                    if (subset6 != null || subset7 != null) {
                        if (subset7 == null) {
                            subset3 = subset6.clone();
                            continue;
                        }
                        if (subset6 == null) {
                            subset4 = subset7.clone();
                            continue;
                        }
                        if (subset6 == null || subset7 == null) continue;
                        double d = subset6.merit;
                        double d2 = subset7.merit;
                        if (d > d2) {
                            subset3 = subset6.clone();
                            continue;
                        }
                        if (d < d2) {
                            subset4 = subset7.clone();
                            continue;
                        }
                        if (d != d2) continue;
                        if (subset6.subset.cardinality() > subset7.subset.cardinality()) {
                            subset4 = subset7.clone();
                            continue;
                        }
                        if (subset6.subset.cardinality() < subset7.subset.cardinality()) {
                            subset3 = subset6.clone();
                            continue;
                        }
                        if (subset6.subset.cardinality() != subset7.subset.cardinality()) continue;
                        double d3 = this.m_random.nextDouble();
                        if (d3 < 0.5) {
                            subset3 = subset6.clone();
                            continue;
                        }
                        subset4 = subset7.clone();
                        continue;
                    }
                    this.m_parentsCombination.add(subset3);
                    this.m_parentsCombination.add(subset4);
                    bl = false;
                }
            }
        }
        this.m_parentsCombination = this.filterSubset(this.m_parentsCombination, this.m_ReferenceSet.size());
        this.GenerateReferenceSet(this.m_parentsCombination, this.m_ReferenceSet.size() / 2, this.m_ReferenceSet.size() / 2);
        this.m_parentsCombination = this.m_parentsCombination.subList(0, this.m_ReferenceSet.size());
    }

    public void CreatePopulation(int n) throws Exception {
        this.InitPopulation(n);
        int n2 = this.m_numAttribs / 2;
        block2: for (int i = 0; i < this.m_popSize; ++i) {
            ArrayList<Subset> arrayList = new ArrayList<Subset>();
            for (int j = 0; j < this.m_attributeRanking.size(); ++j) {
                arrayList.add(this.m_attributeRanking.get(j));
            }
            double d = -999.0;
            double d2 = 0.0;
            boolean bl = true;
            while (true) {
                int n3 = this.m_random.nextInt(n2 + 1);
                if (bl && i <= n2) {
                    n3 = i;
                }
                bl = false;
                Subset subset = ((Subset)arrayList.get(n3)).clone();
                Subset subset2 = this.m_population.get(i).clone();
                Subset subset3 = this.joinSubsets(subset, subset2);
                d2 = subset3.merit;
                if (!(d2 > d)) continue block2;
                this.m_population.set(i, subset3);
                d = d2;
                try {
                    arrayList.set(n3, (Subset)arrayList.get(n2 + 1));
                    arrayList.remove(n2 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    arrayList.set(n3, new Subset(new BitSet(this.m_numAttribs), 0.0));
                }
            }
        }
    }

    public List<Subset> RankEachAttribute() throws Exception {
        ArrayList<Subset> arrayList = new ArrayList<Subset>();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (i == this.m_classIndex) continue;
            BitSet bitSet = new BitSet(this.m_numAttribs);
            bitSet.set(i);
            double d = this.ASEvaluator.evaluateSubset(bitSet);
            ++this.m_totalEvals;
            arrayList.add(new Subset(bitSet, d));
        }
        return this.bubbleSubsetSort(arrayList);
    }

    public Subset getBestgen(Subset subset, BitSet bitSet) throws Exception {
        Subset subset2 = null;
        double d = subset.merit;
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            BitSet bitSet2 = (BitSet)subset.subset.clone();
            if (!bitSet2.get(n)) {
                bitSet2.set(n);
                double d2 = this.ASEvaluator.evaluateSubset(bitSet2);
                ++this.m_totalEvals;
                if (d2 > d) {
                    d = d2;
                    subset2 = new Subset(bitSet2, d);
                }
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return subset2;
    }

    public List<Subset> bubbleSubsetSort(List<Subset> list) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size() - 1; ++i) {
            Subset subset = list.get(i);
            double d = subset.merit;
            for (int j = i + 1; j < list.size(); ++j) {
                Subset subset2 = list.get(j);
                double d2 = subset2.merit;
                if (!(d2 > d)) continue;
                Subset subset3 = subset;
                list.set(i, subset2);
                list.set(j, subset3);
                subset = subset2;
                d = subset.merit;
            }
        }
        return list;
    }

    public int getIndexofBiggest(List<Integer> list) {
        int n;
        int n2 = -99999;
        int n3 = -1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (list.size() == 0) {
            return -1;
        }
        for (n = 0; n < list.size(); ++n) {
            if (list.get(n) <= n2) continue;
            n2 = list.get(n);
            n3 = n;
        }
        for (n = 0; n < list.size(); ++n) {
            if (list.get(n) != n2) continue;
            arrayList.add(n);
        }
        n = (Integer)arrayList.get(this.m_random.nextInt(arrayList.size()));
        return n;
    }

    public BitSet getAllBits(List<Subset> list) {
        BitSet bitSet = new BitSet(this.m_numAttribs);
        for (int i = 0; i < list.size(); ++i) {
            BitSet bitSet2 = list.get((int)i).clone().subset;
            int n = bitSet2.nextSetBit(0);
            while (n >= 0) {
                bitSet.set(n);
                n = bitSet2.nextSetBit(n + 1);
            }
        }
        return bitSet;
    }

    public void InitPopulation(int n) {
        this.m_population = new ArrayList<Subset>();
        for (int i = 0; i < n; ++i) {
            this.m_population.add(new Subset(new BitSet(this.m_numAttribs), 0.0));
        }
    }

    public Subset joinSubsets(Subset subset, Subset subset2) throws Exception {
        BitSet bitSet = (BitSet)subset.subset.clone();
        BitSet bitSet2 = (BitSet)subset2.subset.clone();
        bitSet.or(bitSet2);
        double d = this.ASEvaluator.evaluateSubset(bitSet);
        ++this.m_totalEvals;
        return new Subset((BitSet)bitSet.clone(), d);
    }

    public Subset intersectSubsets(Subset subset, Subset subset2) throws Exception {
        BitSet bitSet = (BitSet)subset.subset.clone();
        BitSet bitSet2 = (BitSet)subset2.subset.clone();
        bitSet.and(bitSet2);
        double d = this.ASEvaluator.evaluateSubset(bitSet);
        ++this.m_totalEvals;
        return new Subset((BitSet)bitSet.clone(), d);
    }

    public Subset simetricDif(Subset subset, Subset subset2, int n) throws Exception {
        BitSet bitSet = (BitSet)subset.subset.clone();
        BitSet bitSet2 = (BitSet)subset2.subset.clone();
        bitSet.xor(bitSet2);
        double d = this.ASEvaluator.evaluateSubset(bitSet);
        ++this.m_totalEvals;
        Subset subset3 = new Subset((BitSet)bitSet.clone(), d);
        if (n == 1) {
            double d2 = 0.0;
            int n2 = 0;
            ArrayList<Subset> arrayList = new ArrayList<Subset>();
            BitSet bitSet3 = subset3.subset;
            int n3 = bitSet3.nextSetBit(0);
            while (n3 >= 0) {
                double d3 = 0.0;
                int n4 = 0;
                Subset subset4 = null;
                for (int i = 0; i < this.m_ReferenceSet.size(); ++i) {
                    subset4 = this.m_ReferenceSet.get(i);
                    if (!subset4.subset.get(n3)) continue;
                    d3 += subset4.merit;
                    ++n4;
                }
                BitSet bitSet4 = new BitSet(this.m_numAttribs);
                bitSet4.set(n3);
                Subset subset5 = new Subset(bitSet4, d3 / (double)n4);
                arrayList.add(subset5);
                d2 += d3;
                ++n2;
                n3 = bitSet3.nextSetBit(n3 + 1);
            }
            d2 /= (double)n2;
            BitSet bitSet5 = new BitSet(this.m_numAttribs);
            for (int i = 0; i < arrayList.size(); ++i) {
                Subset subset6 = (Subset)arrayList.get(i);
                if (!(subset6.merit >= d2)) continue;
                bitSet5.or(subset6.subset);
            }
            double d4 = this.ASEvaluator.evaluateSubset(bitSet5);
            subset3 = new Subset(bitSet5, d4);
        }
        return subset3;
    }

    public int generateRandomNumber(int n) {
        return (int)Math.round(Math.random() * ((double)n + 0.4));
    }

    public double calculateTreshhold() throws Exception {
        BitSet bitSet = new BitSet(this.m_numAttribs);
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (i == this.m_classIndex) continue;
            bitSet.set(i);
        }
        return this.ASEvaluator.evaluateSubset(bitSet);
    }

    public int SimetricDiference(Subset subset, BitSet bitSet) {
        BitSet bitSet2 = subset.clone().subset;
        bitSet2.xor(bitSet);
        return bitSet2.cardinality();
    }

    public List<Subset> filterSubset(List<Subset> list, int n) {
        if (list.size() <= n && n != -1) {
            return list;
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                Subset subset = list.get(i);
                if (!subset.isEqual(list.get(j))) continue;
                list.remove(j);
                --j;
                if (list.size() > n || n == -1) continue;
                return list;
            }
        }
        return list;
    }

    public String printSubset(Subset subset) {
        StringBuffer stringBuffer = new StringBuffer();
        if (subset == null) {
            return "";
        }
        BitSet bitSet = subset.subset;
        double d = subset.merit;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            arrayList.add(i + 1);
        }
        stringBuffer.append(Utils.doubleToString(d, 8, 5) + "\t " + ((Object)arrayList).toString() + "\n");
        return stringBuffer.toString();
    }

    protected void resetOptions() {
        this.m_popSize = -1;
        this.m_initialPopSize = -1;
        this.m_calculatedInitialPopSize = -1;
        this.m_treshold = -1.0;
        this.m_typeOfCombination = 0;
        this.m_seed = 1;
        this.m_debug = true;
        this.m_totalEvals = 0;
        this.m_bestMerit = 0.0;
        this.m_processinTime = 0L;
    }

    public int[] attributeList(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    public class Subset
    implements Serializable {
        double merit;
        BitSet subset;

        public Subset(BitSet bitSet, double d) {
            this.subset = (BitSet)bitSet.clone();
            this.merit = d;
        }

        public boolean isEqual(Subset subset) {
            return this.subset.equals(subset.subset);
        }

        public Subset clone() {
            return new Subset((BitSet)this.subset.clone(), this.merit);
        }
    }
}

