/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import weka.classifiers.UpdateableClassifier;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.Classifier;
import weka.gui.beans.CustomizerClosingListener;

public class ClassifierCustomizer
extends JPanel
implements Customizer,
CustomizerClosingListener {
    private static final long serialVersionUID = -6688000820160821429L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Classifier m_dsClassifier;
    private PropertySheetPanel m_ClassifierEditor = new PropertySheetPanel();
    private JPanel m_incrementalPanel = new JPanel();
    private JCheckBox m_updateIncrementalClassifier = new JCheckBox("Update classifier on incoming instance stream");
    private boolean m_panelVisible = false;
    private JPanel m_holderPanel = new JPanel();
    private JTextField m_executionSlotsText = new JTextField();

    public ClassifierCustomizer() {
        this.m_ClassifierEditor.setBorder(BorderFactory.createTitledBorder("Classifier options"));
        this.m_updateIncrementalClassifier.setToolTipText("Train the classifier on each individual incoming streamed instance.");
        this.m_updateIncrementalClassifier.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ClassifierCustomizer.this.m_dsClassifier != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setUpdateIncrementalClassifier(ClassifierCustomizer.this.m_updateIncrementalClassifier.isSelected());
                }
            }
        });
        this.m_incrementalPanel.add(this.m_updateIncrementalClassifier);
        this.m_executionSlotsText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ClassifierCustomizer.this.m_dsClassifier != null && ClassifierCustomizer.this.m_executionSlotsText.getText().length() > 0) {
                    int n = Integer.parseInt(ClassifierCustomizer.this.m_executionSlotsText.getText());
                    ClassifierCustomizer.this.m_dsClassifier.setExecutionSlots(n);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = new JLabel("Execution slots");
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)this.m_executionSlotsText, "Center");
        this.m_holderPanel.setBorder(BorderFactory.createTitledBorder("More options"));
        this.m_holderPanel.setLayout(new BorderLayout());
        this.m_holderPanel.add((Component)jPanel, "North");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_ClassifierEditor, "Center");
        this.add((Component)this.m_holderPanel, "South");
    }

    private void checkOnClassifierType() {
        weka.classifiers.Classifier classifier = this.m_dsClassifier.getClassifier();
        if (classifier instanceof UpdateableClassifier && this.m_dsClassifier.hasIncomingStreamInstances()) {
            if (!this.m_panelVisible) {
                this.m_holderPanel.add((Component)this.m_incrementalPanel, "South");
                this.m_panelVisible = true;
                this.m_executionSlotsText.setEnabled(false);
            }
        } else if (this.m_panelVisible) {
            this.m_holderPanel.remove(this.m_incrementalPanel);
            this.m_executionSlotsText.setEnabled(true);
            this.m_panelVisible = false;
        }
    }

    public void setObject(Object object) {
        this.m_dsClassifier = (Classifier)object;
        this.m_ClassifierEditor.setTarget(this.m_dsClassifier.getClassifier());
        this.m_updateIncrementalClassifier.setSelected(this.m_dsClassifier.getUpdateIncrementalClassifier());
        this.m_executionSlotsText.setText("" + this.m_dsClassifier.getExecutionSlots());
        this.checkOnClassifierType();
    }

    public void customizerClosing() {
        if (this.m_executionSlotsText.getText().length() > 0) {
            int n = Integer.parseInt(this.m_executionSlotsText.getText());
            this.m_dsClassifier.setExecutionSlots(n);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.removePropertyChangeListener(propertyChangeListener);
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

