/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import org.w3c.dom.Element;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.pmml.FieldMetaInfo;

public class MiningFieldMetaInfo
extends FieldMetaInfo
implements Serializable {
    private static final long serialVersionUID = -1256774332779563185L;
    Usage m_usageType = Usage.ACTIVE;
    protected Outlier m_outlierTreatmentMethod = Outlier.ASIS;
    protected double m_lowValue;
    protected double m_highValue;
    protected Missing m_missingValueTreatmentMethod = Missing.ASIS;
    protected String m_missingValueReplacementNominal;
    protected double m_missingValueReplacementNumeric;
    protected FieldMetaInfo.Optype m_optypeOverride = FieldMetaInfo.Optype.NONE;
    protected int m_index;
    protected double m_importance;
    Instances m_miningSchemaI = null;

    protected void setMiningSchemaInstances(Instances instances) {
        this.m_miningSchemaI = instances;
    }

    public Usage getUsageType() {
        return this.m_usageType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_miningSchemaI.attribute(this.m_index));
        stringBuffer.append("\n\tusage: " + (Object)((Object)this.m_usageType) + "\n\toutlier treatment: " + (Object)((Object)this.m_outlierTreatmentMethod));
        if (this.m_outlierTreatmentMethod == Outlier.ASEXTREMEVALUES) {
            stringBuffer.append(" (lowValue = " + this.m_lowValue + " highValue = " + this.m_highValue + ")");
        }
        stringBuffer.append("\n\tmissing value treatment: " + (Object)((Object)this.m_missingValueTreatmentMethod));
        if (this.m_missingValueTreatmentMethod != Missing.ASIS) {
            stringBuffer.append(" (replacementValue = " + (this.m_missingValueReplacementNominal != null ? this.m_missingValueReplacementNominal : Utils.doubleToString(this.m_missingValueReplacementNumeric, 4)) + ")");
        }
        return stringBuffer.toString();
    }

    public void setIndex(int n) {
        this.m_index = n;
    }

    public String getName() {
        return this.m_fieldName;
    }

    public Outlier getOutlierTreatmentMethod() {
        return this.m_outlierTreatmentMethod;
    }

    public Missing getMissingValueTreatmentMethod() {
        return this.m_missingValueTreatmentMethod;
    }

    public double applyMissingValueTreatment(double d) throws Exception {
        double d2 = d;
        if (this.m_missingValueTreatmentMethod != Missing.ASIS && Instance.isMissingValue(d)) {
            if (this.m_missingValueReplacementNominal != null) {
                Attribute attribute = this.m_miningSchemaI.attribute(this.m_index);
                int n = attribute.indexOfValue(this.m_missingValueReplacementNominal);
                if (n < 0) {
                    throw new Exception("[MiningSchema] Nominal missing value replacement value doesn't exist in the mining schema Instances!");
                }
                d2 = n;
            } else {
                d2 = this.m_missingValueReplacementNumeric;
            }
        }
        return d2;
    }

    public double applyOutlierTreatment(double d) throws Exception {
        double d2 = d;
        if (this.m_outlierTreatmentMethod != Outlier.ASIS) {
            if (this.m_outlierTreatmentMethod == Outlier.ASMISSINGVALUES) {
                d2 = this.applyMissingValueTreatment(d);
            } else if (d < this.m_lowValue) {
                d2 = this.m_lowValue;
            } else if (d > this.m_highValue) {
                d2 = this.m_highValue;
            }
        }
        return d2;
    }

    public Attribute getFieldAsAttribute() {
        return this.m_miningSchemaI.attribute(this.m_index);
    }

    public MiningFieldMetaInfo(Element element) throws Exception {
        super(element);
        String string = element.getAttribute("usageType");
        Object object = Usage.values();
        int n = ((Usage[])object).length;
        for (int i = 0; i < n; ++i) {
            Usage usage = object[i];
            if (!usage.toString().equals(string)) continue;
            this.m_usageType = usage;
            break;
        }
        if (((String)(object = element.getAttribute("importance"))).length() > 0) {
            this.m_importance = Double.parseDouble((String)object);
        }
        String string2 = element.getAttribute("outliers");
        Object object2 = Outlier.values();
        int n2 = ((Outlier[])object2).length;
        for (int i = 0; i < n2; ++i) {
            Outlier outlier = object2[i];
            if (!outlier.toString().equals(string2)) continue;
            this.m_outlierTreatmentMethod = outlier;
            break;
        }
        if (string2.length() > 0) {
            object2 = element.getAttribute("lowValue");
            if (((String)object2).length() <= 0) {
                throw new Exception("[MiningFieldMetaInfo] as extreme values outlier treatment specified, but no low value defined!");
            }
            this.m_lowValue = Double.parseDouble((String)object2);
            String string3 = element.getAttribute("highValue");
            if (string3.length() > 0) {
                this.m_highValue = Double.parseDouble(string3);
            } else {
                throw new Exception("[MiningFieldMetaInfo] as extreme values outlier treatment specified, but no high value defined!");
            }
        }
        if (((String)(object2 = element.getAttribute("missingValueReplacement"))).length() > 0) {
            try {
                this.m_missingValueReplacementNumeric = Double.parseDouble((String)object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.m_missingValueReplacementNominal = object2;
            }
            String string4 = element.getAttribute("missingValueTreatment");
            for (Missing missing : Missing.values()) {
                if (!missing.toString().equals(string4)) continue;
                this.m_missingValueTreatmentMethod = missing;
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Missing {
        ASIS("asIs"),
        ASMEAN("asMean"),
        ASMODE("asMode"),
        ASMEDIAN("asMedian"),
        ASVALUE("asValue");

        private final String m_stringVal;

        private Missing(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Outlier {
        ASIS("asIs"),
        ASMISSINGVALUES("asMissingValues"),
        ASEXTREMEVALUES("asExtremeValues");

        private final String m_stringVal;

        private Outlier(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Usage {
        ACTIVE("active"),
        PREDICTED("predicted"),
        SUPPLEMENTARY("supplementary"),
        GROUP("group"),
        ORDER("order");

        private final String m_stringVal;

        private Usage(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

