/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import weka.core.Environment;
import weka.core.logging.Logger;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.Startable;
import weka.gui.beans.xml.XMLBeans;

public class FlowRunner {
    protected Vector m_beans;
    protected int m_runningCount = 0;
    protected transient Logger m_log = null;

    public FlowRunner() {
        KnowledgeFlowApp.loadProperties();
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    protected synchronized void launchThread(final Startable startable, final int n) {
        Thread thread = new Thread(){
            private int m_num;
            {
                this.m_num = n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        startable.start();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (FlowRunner.this.m_log != null) {
                            FlowRunner.this.m_log.logMessage(exception.getMessage());
                        } else {
                            System.err.println(exception.getMessage());
                        }
                        Object var3_2 = null;
                        if (FlowRunner.this.m_log != null) {
                            FlowRunner.this.m_log.logMessage("[FlowRunner] flow " + this.m_num + " finished.");
                        } else {
                            System.out.println("[FlowRunner] Flow " + this.m_num + " finished.");
                        }
                        FlowRunner.this.decreaseCount();
                    }
                    Object var3_1 = null;
                    if (FlowRunner.this.m_log != null) {
                        FlowRunner.this.m_log.logMessage("[FlowRunner] flow " + this.m_num + " finished.");
                    } else {
                        System.out.println("[FlowRunner] Flow " + this.m_num + " finished.");
                    }
                    FlowRunner.this.decreaseCount();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (FlowRunner.this.m_log != null) {
                        FlowRunner.this.m_log.logMessage("[FlowRunner] flow " + this.m_num + " finished.");
                    } else {
                        System.out.println("[FlowRunner] Flow " + this.m_num + " finished.");
                    }
                    FlowRunner.this.decreaseCount();
                    throw throwable;
                }
            }
        };
        ++this.m_runningCount;
        thread.setPriority(1);
        thread.start();
    }

    protected synchronized void decreaseCount() {
        --this.m_runningCount;
    }

    public synchronized void stopAllFlows() {
        for (int i = 0; i < this.m_beans.size(); ++i) {
            BeanInstance beanInstance = (BeanInstance)this.m_beans.elementAt(i);
            if (!(beanInstance.getBean() instanceof BeanCommon)) continue;
            ((BeanCommon)beanInstance.getBean()).stop();
        }
    }

    public void waitUntilFinished() {
        try {
            while (this.m_runningCount > 0) {
                Thread.sleep(200L);
            }
            while (true) {
                boolean bl = false;
                for (int i = 0; i < this.m_beans.size(); ++i) {
                    BeanInstance beanInstance = (BeanInstance)this.m_beans.elementAt(i);
                    if (!(beanInstance.getBean() instanceof BeanCommon) || !((BeanCommon)beanInstance.getBean()).isBusy()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    Thread.sleep(3000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            if (this.m_log != null) {
                this.m_log.logMessage("[FlowRunner] Attempting to stop all flows...");
            } else {
                System.err.println("[FlowRunner] Attempting to stop all flows...");
            }
            this.stopAllFlows();
        }
    }

    public void load(String string) throws Exception {
        if (!string.endsWith(".kf") && !string.endsWith(".kfml")) {
            throw new Exception("Can only load and run binary or xml serialized KnowledgeFlows (*.kf | *.kfml)");
        }
        if (string.endsWith(".kf")) {
            this.loadBinary(string);
        } else if (string.endsWith(".kfml")) {
            this.loadXML(string);
        }
    }

    public void loadBinary(String string) throws Exception {
        if (!string.endsWith(".kf")) {
            throw new Exception("File must be a binary flow (*.kf)");
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        this.m_beans = (Vector)objectInputStream.readObject();
        objectInputStream.close();
        Environment.addVariable("Internal.knowledgeflow.directory", new File(string).getParent());
    }

    public void loadXML(String string) throws Exception {
        if (!string.endsWith(".kfml")) {
            throw new Exception("File must be an XML flow (*.kfml)");
        }
        XMLBeans xMLBeans = new XMLBeans(null, null);
        Vector vector = (Vector)xMLBeans.read(new File(string));
        this.m_beans = (Vector)vector.get(0);
        Environment.addVariable("Internal.knowledgeflow.directory", new File(string).getParent());
    }

    public Vector getFlows() {
        return this.m_beans;
    }

    public void setFlows(Vector vector) {
        this.m_beans = vector;
    }

    public void run() throws Exception {
        int n;
        if (this.m_beans == null) {
            throw new Exception("Don't seem to have any beans I can execute.");
        }
        if (this.m_log != null) {
            for (n = 0; n < this.m_beans.size(); ++n) {
                BeanInstance beanInstance = (BeanInstance)this.m_beans.elementAt(n);
                if (!(beanInstance.getBean() instanceof BeanCommon)) continue;
                ((BeanCommon)beanInstance.getBean()).setLog(this.m_log);
            }
        }
        n = 1;
        for (int i = 0; i < this.m_beans.size(); ++i) {
            BeanInstance beanInstance = (BeanInstance)this.m_beans.elementAt(i);
            if (!(beanInstance.getBean() instanceof Startable)) continue;
            Startable startable = (Startable)beanInstance.getBean();
            if (this.m_log != null) {
                this.m_log.logMessage("[FlowRunner] Launching flow " + n + "...");
            } else {
                System.out.println("[FlowRunner] Launching flow " + n + "...");
            }
            this.launchThread(startable, n);
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        weka.core.logging.Logger.log(Logger.Level.INFO, "Logging started");
        if (stringArray.length != 1) {
            System.err.println("Usage:\n\nFlowRunner <serialized kf file>");
        } else {
            try {
                FlowRunner flowRunner = new FlowRunner();
                SimpleLogger simpleLogger = new SimpleLogger();
                String string = stringArray[0];
                flowRunner.setLog(simpleLogger);
                flowRunner.load(string);
                flowRunner.run();
                flowRunner.waitUntilFinished();
                System.out.println("Finished all flows.");
                System.exit(1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println(exception.getMessage());
            }
        }
    }

    protected static class SimpleLogger
    implements Logger {
        SimpleDateFormat m_DateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        protected SimpleLogger() {
        }

        public void logMessage(String string) {
            System.out.println(this.m_DateFormat.format(new Date()) + ": " + string);
        }

        public void statusMessage(String string) {
            System.out.println(this.m_DateFormat.format(new Date()) + ": " + string);
        }
    }
}

