/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.pmml.BuiltInArithmetic;
import weka.core.pmml.BuiltInMath;
import weka.core.pmml.TransformationDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Function
implements Serializable {
    private static final long serialVersionUID = -6997738288201933171L;
    protected String m_functionName;
    protected ArrayList<Attribute> m_parameterDefs = null;

    public String getName() {
        return this.m_functionName;
    }

    public abstract String[] getParameterNames();

    public abstract void setParameterDefs(ArrayList<Attribute> var1) throws Exception;

    public abstract Attribute getOutputDef();

    public abstract double getResult(double[] var1) throws Exception;

    public static Function getFunction(String string) {
        Function function = null;
        if ((string = string.trim()).equals("+")) {
            function = new BuiltInArithmetic(BuiltInArithmetic.Operator.ADDITION);
        } else if (string.equals("-")) {
            function = new BuiltInArithmetic(BuiltInArithmetic.Operator.SUBTRACTION);
        } else if (string.equals("*")) {
            function = new BuiltInArithmetic(BuiltInArithmetic.Operator.MULTIPLICATION);
        } else if (string.equals("/")) {
            function = new BuiltInArithmetic(BuiltInArithmetic.Operator.DIVISION);
        } else if (string.equals(BuiltInMath.MathFunc.MIN.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.MIN);
        } else if (string.equals(BuiltInMath.MathFunc.MAX.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.MAX);
        } else if (string.equals(BuiltInMath.MathFunc.SUM.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.SUM);
        } else if (string.equals(BuiltInMath.MathFunc.AVG.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.AVG);
        } else if (string.equals(BuiltInMath.MathFunc.LOG10.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.LOG10);
        } else if (string.equals(BuiltInMath.MathFunc.LN.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.LN);
        } else if (string.equals(BuiltInMath.MathFunc.SQRT.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.SQRT);
        } else if (string.equals(BuiltInMath.MathFunc.ABS.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.ABS);
        } else if (string.equals(BuiltInMath.MathFunc.EXP.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.EXP);
        } else if (string.equals(BuiltInMath.MathFunc.POW.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.POW);
        } else if (string.equals(BuiltInMath.MathFunc.THRESHOLD.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.THRESHOLD);
        } else if (string.equals(BuiltInMath.MathFunc.FLOOR.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.FLOOR);
        } else if (string.equals(BuiltInMath.MathFunc.CEIL.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.CEIL);
        } else if (string.equals(BuiltInMath.MathFunc.ROUND.toString())) {
            function = new BuiltInMath(BuiltInMath.MathFunc.ROUND);
        }
        return function;
    }

    public static Function getFunction(String string, TransformationDictionary transformationDictionary) throws Exception {
        Function function = Function.getFunction(string);
        if (function == null && transformationDictionary != null) {
            function = transformationDictionary.getFunction(string);
        }
        if (function == null) {
            throw new Exception("[Function] unknown/unsupported function " + string);
        }
        return function;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        return string + this.getClass().getName();
    }
}

