/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class AddValues
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    private static final long serialVersionUID = -8100622241742393656L;
    protected SingleIndex m_AttIndex = new SingleIndex("last");
    protected Vector m_Labels = new Vector();
    protected boolean m_Sort = false;
    protected int[] m_SortedIndices;

    public String globalInfo() {
        return "Adds the labels from the given list to an attribute if they are missing. The labels can also be sorted in an ascending manner. If no labels are provided then only the (optional) sorting applies.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSets the attribute index\n\t(default last).", "C", 1, "-C <col>"));
        vector.addElement(new Option("\tComma-separated list of labels to add.\n\t(default: none)", "L", 1, "-L <label1,label2,...>"));
        vector.addElement(new Option("\tTurns on the sorting of the labels.", "S", 0, "-S"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndex(string);
        } else {
            this.setAttributeIndex("last");
        }
        string = Utils.getOption('L', stringArray);
        if (string.length() != 0) {
            this.setLabels(string);
        } else {
            this.setLabels("");
        }
        this.setSort(Utils.getFlag('S', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-C");
        vector.add("" + this.getAttributeIndex());
        vector.add("-L");
        vector.add("" + this.getLabels());
        if (this.getSort()) {
            vector.add("-S");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        int n;
        super.setInputFormat(instances);
        this.m_AttIndex.setUpper(instances.numAttributes() - 1);
        Attribute attribute = instances.attribute(this.m_AttIndex.getIndex());
        if (!attribute.isNominal()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute not nominal.");
        }
        Vector vector = new Vector();
        Enumeration enumeration = attribute.enumerateValues();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        for (n = 0; n < this.m_Labels.size(); ++n) {
            if (vector.contains(this.m_Labels.get(n))) continue;
            vector.add(this.m_Labels.get(n));
        }
        if (this.getSort()) {
            Collections.sort(vector);
        }
        this.m_SortedIndices = new int[attribute.numValues()];
        enumeration = attribute.enumerateValues();
        n = 0;
        while (enumeration.hasMoreElements()) {
            this.m_SortedIndices[n] = vector.indexOf(enumeration.nextElement());
            ++n;
        }
        FastVector fastVector = new FastVector();
        for (n = 0; n < vector.size(); ++n) {
            fastVector.addElement(vector.get(n));
        }
        Attribute attribute2 = new Attribute(attribute.name(), fastVector);
        FastVector fastVector2 = new FastVector();
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == this.m_AttIndex.getIndex()) {
                fastVector2.addElement(attribute2);
                continue;
            }
            fastVector2.addElement(instances.attribute(n));
        }
        Instances instances2 = new Instances(instances.relationName(), fastVector2, 0);
        instances2.setClassIndex(instances.classIndex());
        this.setOutputFormat(instances2);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] dArray = instance.toDoubleArray();
        dArray[this.m_AttIndex.getIndex()] = this.m_SortedIndices[(int)dArray[this.m_AttIndex.getIndex()]];
        Instance instance2 = new Instance(instance.weight(), dArray);
        this.copyValues(instance, false, instance.dataset(), this.getOutputFormat());
        this.push(instance2);
        return true;
    }

    public String attributeIndexTipText() {
        return "Sets which attribute to process. This attribute must be nominal (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String string) {
        this.m_AttIndex.setSingleIndex(string);
    }

    public String labelsTipText() {
        return "Comma-separated list of lables to add.";
    }

    public String getLabels() {
        String string = "";
        for (int i = 0; i < this.m_Labels.size(); ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + Utils.quote((String)this.m_Labels.get(i));
        }
        return string;
    }

    public void setLabels(String string) {
        this.m_Labels.clear();
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\"') {
                boolean bl3 = bl = !bl;
                if (!bl) {
                    bl2 = true;
                }
            } else if (string.charAt(i) == ',' && !bl) {
                bl2 = true;
            } else {
                string2 = string2 + string.charAt(i);
                if (i == string.length() - 1) {
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            if (string2.length() != 0) {
                this.m_Labels.add(string2);
            }
            string2 = "";
            bl2 = false;
        }
    }

    public String sortTipText() {
        return "Whether to sort the labels alphabetically.";
    }

    public boolean getSort() {
        return this.m_Sort;
    }

    public void setSort(boolean bl) {
        this.m_Sort = bl;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }

    public static void main(String[] stringArray) {
        AddValues.runFilter(new AddValues(), stringArray);
    }
}

