/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.adtree;

import java.util.Enumeration;
import weka.classifiers.trees.adtree.PredictionNode;
import weka.classifiers.trees.adtree.ReferenceInstances;
import weka.classifiers.trees.adtree.Splitter;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class TwoWayNominalSplit
extends Splitter {
    private static final long serialVersionUID = -4598366190152721355L;
    private int attIndex;
    private int trueSplitValue;
    private PredictionNode[] children;

    public TwoWayNominalSplit(int n, int n2) {
        this.attIndex = n;
        this.trueSplitValue = n2;
        this.children = new PredictionNode[2];
    }

    public int getNumOfBranches() {
        return 2;
    }

    public int branchInstanceGoesDown(Instance instance) {
        if (instance.isMissing(this.attIndex)) {
            return -1;
        }
        if (instance.value(this.attIndex) == (double)this.trueSplitValue) {
            return 0;
        }
        return 1;
    }

    public ReferenceInstances instancesDownBranch(int n, Instances instances) {
        ReferenceInstances referenceInstances = new ReferenceInstances(instances, 1);
        if (n == -1) {
            Enumeration enumeration = instances.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                Instance instance = (Instance)enumeration.nextElement();
                if (!instance.isMissing(this.attIndex)) continue;
                referenceInstances.addReference(instance);
            }
        } else if (n == 0) {
            Enumeration enumeration = instances.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                Instance instance = (Instance)enumeration.nextElement();
                if (instance.isMissing(this.attIndex) || instance.value(this.attIndex) != (double)this.trueSplitValue) continue;
                referenceInstances.addReference(instance);
            }
        } else {
            Enumeration enumeration = instances.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                Instance instance = (Instance)enumeration.nextElement();
                if (instance.isMissing(this.attIndex) || instance.value(this.attIndex) == (double)this.trueSplitValue) continue;
                referenceInstances.addReference(instance);
            }
        }
        return referenceInstances;
    }

    public String attributeString(Instances instances) {
        return instances.attribute(this.attIndex).name();
    }

    public String comparisonString(int n, Instances instances) {
        Attribute attribute = instances.attribute(this.attIndex);
        if (attribute.numValues() != 2) {
            return (n == 0 ? "= " : "!= ") + attribute.value(this.trueSplitValue);
        }
        return "= " + (n == 0 ? attribute.value(this.trueSplitValue) : attribute.value(this.trueSplitValue == 0 ? 1 : 0));
    }

    public boolean equalTo(Splitter splitter) {
        if (splitter instanceof TwoWayNominalSplit) {
            TwoWayNominalSplit twoWayNominalSplit = (TwoWayNominalSplit)splitter;
            return this.attIndex == twoWayNominalSplit.attIndex && this.trueSplitValue == twoWayNominalSplit.trueSplitValue;
        }
        return false;
    }

    public void setChildForBranch(int n, PredictionNode predictionNode) {
        this.children[n] = predictionNode;
    }

    public PredictionNode getChildForBranch(int n) {
        return this.children[n];
    }

    public Object clone() {
        TwoWayNominalSplit twoWayNominalSplit = new TwoWayNominalSplit(this.attIndex, this.trueSplitValue);
        twoWayNominalSplit.orderAdded = this.orderAdded;
        if (this.children[0] != null) {
            twoWayNominalSplit.setChildForBranch(0, (PredictionNode)this.children[0].clone());
        }
        if (this.children[1] != null) {
            twoWayNominalSplit.setChildForBranch(1, (PredictionNode)this.children[1].clone());
        }
        return twoWayNominalSplit;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }
}

