/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.pmml.Apply;
import weka.core.pmml.Constant;
import weka.core.pmml.Discretize;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.FieldRef;
import weka.core.pmml.NormContinuous;
import weka.core.pmml.NormDiscrete;
import weka.core.pmml.TransformationDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
implements Serializable {
    private static final long serialVersionUID = 4448840549804800321L;
    protected FieldMetaInfo.Optype m_opType;
    protected ArrayList<Attribute> m_fieldDefs = null;

    public Expression(FieldMetaInfo.Optype optype, ArrayList<Attribute> arrayList) {
        this.m_opType = optype;
        this.m_fieldDefs = arrayList;
    }

    public void setFieldDefs(ArrayList<Attribute> arrayList) throws Exception {
        this.m_fieldDefs = arrayList;
    }

    public abstract double getResult(double[] var1) throws Exception;

    public double getResultContinuous(double[] dArray) throws Exception {
        if (this.m_opType != FieldMetaInfo.Optype.CONTINUOUS) {
            throw new Exception("[Expression] Can't return continuous result as optype is not continuous");
        }
        return this.getResult(dArray);
    }

    public abstract String getResultCategorical(double[] var1) throws Exception;

    protected abstract Attribute getOutputDef();

    public static Expression getExpression(Node node, FieldMetaInfo.Optype optype, ArrayList<Attribute> arrayList, TransformationDictionary transformationDictionary) throws Exception {
        Node node2;
        Expression expression = null;
        String string = "";
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            throw new Exception("[Expression] container has no children!");
        }
        for (int i = 0; i < nodeList.getLength() && ((node2 = nodeList.item(i)).getNodeType() != 1 || (expression = Expression.getExpression(string = ((Element)node2).getTagName(), node2, optype, arrayList, transformationDictionary)) == null); ++i) {
        }
        return expression;
    }

    public static Expression getExpression(String string, Node node, FieldMetaInfo.Optype optype, ArrayList<Attribute> arrayList, TransformationDictionary transformationDictionary) throws Exception {
        Expression expression = null;
        if (string.equals("Constant")) {
            expression = new Constant((Element)node, optype, arrayList);
        } else if (string.equals("FieldRef")) {
            expression = new FieldRef((Element)node, optype, arrayList);
        } else if (string.equals("Apply")) {
            expression = new Apply((Element)node, optype, arrayList, transformationDictionary);
        } else if (string.equals("NormDiscrete")) {
            expression = new NormDiscrete((Element)node, optype, arrayList);
        } else if (string.equals("NormContinuous")) {
            expression = new NormContinuous((Element)node, optype, arrayList);
        } else if (string.equals("Discretize")) {
            expression = new Discretize((Element)node, optype, arrayList);
        } else if (string.equals("MapValues") || string.equals("Aggregate")) {
            throw new Exception("[Expression] Unhandled Expression tyoe " + string);
        }
        return expression;
    }

    public Attribute getFieldDef(String string) {
        Attribute attribute = null;
        for (int i = 0; i < this.m_fieldDefs.size(); ++i) {
            if (!this.m_fieldDefs.get(i).name().equals(string)) continue;
            attribute = this.m_fieldDefs.get(i);
            break;
        }
        return attribute;
    }

    public int getFieldDefIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.m_fieldDefs.size(); ++i) {
            if (!this.m_fieldDefs.get(i).name().equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public FieldMetaInfo.Optype getOptype() {
        return this.m_opType;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        return string + this.getClass().getName();
    }
}

