/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.core.Queue;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.Compute;
import weka.experiment.Task;
import weka.experiment.TaskStatusInfo;

public class RemoteEngine
extends UnicastRemoteObject
implements Compute,
RevisionHandler {
    private static final long serialVersionUID = -1021538162895448259L;
    private String m_HostName = "local";
    private Queue m_TaskQueue = new Queue();
    private Queue m_TaskIdQueue = new Queue();
    private Hashtable m_TaskStatus = new Hashtable();
    private boolean m_TaskRunning = false;
    protected static long CLEANUPTIMEOUT = 3600000L;

    public RemoteEngine(String string) throws RemoteException {
        this.m_HostName = string;
        Thread thread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(CLEANUPTIMEOUT);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (RemoteEngine.this.m_TaskStatus.size() > 0) {
                        RemoteEngine.this.purge();
                        continue;
                    }
                    System.err.println("RemoteEngine : purge - no tasks to check.");
                }
            }
        };
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized Object executeTask(Task task) throws RemoteException {
        String string = "" + System.currentTimeMillis() + ":";
        string = string + task.hashCode();
        this.addTaskToQueue(task, string);
        return string;
    }

    public Object checkStatus(Object object) throws Exception {
        TaskStatusInfo taskStatusInfo = (TaskStatusInfo)this.m_TaskStatus.get(object);
        if (taskStatusInfo == null) {
            throw new Exception("RemoteEngine (" + this.m_HostName + ") : Task not found.");
        }
        TaskStatusInfo taskStatusInfo2 = new TaskStatusInfo();
        taskStatusInfo2.setExecutionStatus(taskStatusInfo.getExecutionStatus());
        taskStatusInfo2.setStatusMessage(taskStatusInfo.getStatusMessage());
        taskStatusInfo2.setTaskResult(taskStatusInfo.getTaskResult());
        if (taskStatusInfo.getExecutionStatus() == 3 || taskStatusInfo.getExecutionStatus() == 2) {
            System.err.println("Finished/failed Task id : " + object + " checked by client. Removing.");
            taskStatusInfo.setTaskResult(null);
            taskStatusInfo = null;
            this.m_TaskStatus.remove(object);
        }
        taskStatusInfo = null;
        return taskStatusInfo2;
    }

    private synchronized void addTaskToQueue(Task task, String string) {
        TaskStatusInfo taskStatusInfo = task.getTaskStatus();
        if (taskStatusInfo == null) {
            taskStatusInfo = new TaskStatusInfo();
        }
        this.m_TaskQueue.push(task);
        this.m_TaskIdQueue.push(string);
        taskStatusInfo.setStatusMessage("RemoteEngine (" + this.m_HostName + ") : task " + string + " queued at postion: " + this.m_TaskQueue.size());
        this.m_TaskStatus.put(string, taskStatusInfo);
        System.err.println("Task id : " + string + " Queued.");
        if (!this.m_TaskRunning) {
            this.startTask();
        }
    }

    private void startTask() {
        if (!this.m_TaskRunning && this.m_TaskQueue.size() > 0) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block13: {
                        RemoteEngine.this.m_TaskRunning = true;
                        Task task = (Task)RemoteEngine.this.m_TaskQueue.pop();
                        String string = (String)RemoteEngine.this.m_TaskIdQueue.pop();
                        TaskStatusInfo taskStatusInfo = (TaskStatusInfo)RemoteEngine.this.m_TaskStatus.get(string);
                        taskStatusInfo.setExecutionStatus(1);
                        taskStatusInfo.setStatusMessage("RemoteEngine (" + RemoteEngine.this.m_HostName + ") : task " + string + " running...");
                        try {
                            try {
                                System.err.println("Launching task id : " + string + "...");
                                task.execute();
                                TaskStatusInfo taskStatusInfo2 = task.getTaskStatus();
                                taskStatusInfo.setExecutionStatus(taskStatusInfo2.getExecutionStatus());
                                taskStatusInfo.setStatusMessage("RemoteExperiment (" + RemoteEngine.this.m_HostName + ") " + taskStatusInfo2.getStatusMessage());
                                taskStatusInfo.setTaskResult(taskStatusInfo2.getTaskResult());
                            }
                            catch (Error error) {
                                taskStatusInfo.setExecutionStatus(2);
                                if (error.getCause() instanceof AccessControlException) {
                                    taskStatusInfo.setStatusMessage("RemoteEngine (" + RemoteEngine.this.m_HostName + ") : security error, check remote policy file.");
                                    System.err.println("Task id " + string + " Failed! Check remote policy file");
                                } else {
                                    taskStatusInfo.setStatusMessage("RemoteEngine (" + RemoteEngine.this.m_HostName + ") : unknown initialization error.");
                                    System.err.println("Task id " + string + " Unknown initialization error");
                                }
                                Object var6_8 = null;
                                if (RemoteEngine.this.m_TaskStatus.size() == 0) {
                                    RemoteEngine.this.purgeClasses();
                                }
                                RemoteEngine.this.m_TaskRunning = false;
                                RemoteEngine.this.startTask();
                                return;
                            }
                            catch (Exception exception) {
                                taskStatusInfo.setExecutionStatus(2);
                                if (exception instanceof FileNotFoundException) {
                                    taskStatusInfo.setStatusMessage("RemoteEngine (" + RemoteEngine.this.m_HostName + ") : " + exception.getMessage());
                                    System.err.println("Task id " + string + " Failed, " + exception.getMessage());
                                } else {
                                    taskStatusInfo.setStatusMessage("RemoteEngine (" + RemoteEngine.this.m_HostName + ") : task " + string + " failed.");
                                    System.err.println("Task id " + string + " Failed!");
                                }
                                Object var6_9 = null;
                                if (RemoteEngine.this.m_TaskStatus.size() == 0) {
                                    RemoteEngine.this.purgeClasses();
                                }
                                RemoteEngine.this.m_TaskRunning = false;
                                RemoteEngine.this.startTask();
                                return;
                            }
                            Object var6_7 = null;
                            if (RemoteEngine.this.m_TaskStatus.size() != 0) break block13;
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            if (RemoteEngine.this.m_TaskStatus.size() == 0) {
                                RemoteEngine.this.purgeClasses();
                            }
                            RemoteEngine.this.m_TaskRunning = false;
                            RemoteEngine.this.startTask();
                            throw throwable;
                        }
                        RemoteEngine.this.purgeClasses();
                    }
                    RemoteEngine.this.m_TaskRunning = false;
                    RemoteEngine.this.startTask();
                }
            };
            thread.setPriority(1);
            thread.start();
        }
    }

    private void purgeClasses() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader uRLClassLoader = URLClassLoader.newInstance(new URL[]{new URL("file:.")}, classLoader);
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void purge() {
        Enumeration enumeration = this.m_TaskStatus.keys();
        long l = System.currentTimeMillis();
        System.err.println("RemoteEngine purge. Current time : " + l);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.err.print("Examining task id : " + string + "... ");
            String string2 = string.substring(0, string.indexOf(58));
            long l2 = Long.valueOf(string2);
            if (l - l2 > CLEANUPTIMEOUT) {
                TaskStatusInfo taskStatusInfo = (TaskStatusInfo)this.m_TaskStatus.get(string);
                if (taskStatusInfo == null || taskStatusInfo.getExecutionStatus() != 3 && taskStatusInfo.getExecutionStatus() != 2) continue;
                System.err.println("\nTask id : " + string + " has gone stale. Removing.");
                this.m_TaskStatus.remove(string);
                taskStatusInfo.setTaskResult(null);
                taskStatusInfo = null;
                continue;
            }
            System.err.println("ok.");
        }
        if (this.m_TaskStatus.size() == 0) {
            this.purgeClasses();
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.12 $");
    }

    public static void main(String[] stringArray) {
        Object object;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        int n = 1099;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            System.err.println("Host name : " + inetAddress.getHostName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = inetAddress != null ? inetAddress.getHostName() : "localhost";
        try {
            object = Utils.getOption("p", stringArray);
            if (!((String)object).equals("")) {
                n = Integer.parseInt((String)object);
            }
        }
        catch (Exception exception) {
            System.err.println("Usage : -p <port>");
        }
        if (n != 1099) {
            string = string + ":" + n;
        }
        string = "//" + string + "/RemoteEngine";
        try {
            object = new RemoteEngine(string);
            try {
                Naming.rebind(string, (Remote)object);
                System.out.println("RemoteEngine bound in RMI registry");
            }
            catch (RemoteException remoteException) {
                System.err.println("Attempting to start RMI registry on port " + n + "...");
                LocateRegistry.createRegistry(n);
                Naming.bind(string, (Remote)object);
                System.out.println("RemoteEngine bound in RMI registry");
            }
        }
        catch (Exception exception) {
            System.err.println("RemoteEngine exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

