/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.Utils;
import weka.datagenerators.DataGenerator;

public abstract class RegressionGenerator
extends DataGenerator {
    protected int m_NumExamples;

    public RegressionGenerator() {
        this.setNumExamples(this.defaultNumExamples());
    }

    public Enumeration listOptions() {
        Vector vector = this.enumToVector(super.listOptions());
        vector.addElement(new Option("\tThe number of examples to generate (default " + this.defaultNumExamples() + ")", "n", 1, "-n <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('n', stringArray);
        if (string.length() != 0) {
            this.setNumExamples(Integer.parseInt(string));
        } else {
            this.setNumExamples(this.defaultNumExamples());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-n");
        vector.add("" + this.getNumExamples());
        return vector.toArray(new String[vector.size()]);
    }

    protected int defaultNumExamples() {
        return 100;
    }

    public void setNumExamples(int n) {
        this.m_NumExamples = n;
    }

    public int getNumExamples() {
        return this.m_NumExamples;
    }

    public String numExamplesTipText() {
        return "The number of examples to generate.";
    }
}

