/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.CfsSubsetEval;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.instance.SpreadSubsample;

public class FilteredSubsetEval
extends ASEvaluation
implements Serializable,
SubsetEvaluator,
OptionHandler {
    static final long serialVersionUID = 2111121880778327334L;
    protected SubsetEvaluator m_evaluator = new CfsSubsetEval();
    protected Filter m_filter = new SpreadSubsample();
    protected Instances m_filteredInstances = null;

    public Capabilities getCapabilities() {
        Capabilities capabilities;
        if (this.getFilter() == null) {
            capabilities = super.getCapabilities();
            capabilities.disableAll();
        } else {
            capabilities = this.getFilter().getCapabilities();
        }
        for (Capabilities.Capability capability : Capabilities.Capability.values()) {
            capabilities.enableDependency(capability);
        }
        return capabilities;
    }

    public String globalInfo() {
        return "Class for running an arbitrary subset evaluator on data that has been passed through an arbitrary filter (note: filters that alter the order or number of attributes are not allowed). Like the evaluator, the structure of the filter is based exclusively on the training data.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tFull name of base evaluator to use, followed by evaluator options.\n\teg: \"weka.attributeSelection.CfsSubsetEval -L\"", "W", 1, "-W <evaluator specification>"));
        vector.addElement(new Option("\tFull class name of filter to use, followed\n\tby filter options.\n\teg: \"weka.filters.supervised.instance.SpreadSubsample -M 1\"", "F", 1, "-F <filter specification>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String[] stringArray2;
        Object object;
        String string = Utils.getOption('W', stringArray);
        if (string.length() > 0) {
            object = Utils.splitOptions(string);
            if (((String[])object).length == 0) {
                throw new IllegalArgumentException("Invalid evaluator specification string");
            }
            stringArray2 = object[0];
            object[0] = "";
            this.setSubsetEvaluator((ASEvaluation)Utils.forName(SubsetEvaluator.class, (String)stringArray2, (String[])object));
        } else {
            this.setSubsetEvaluator(new CfsSubsetEval());
        }
        object = Utils.getOption('F', stringArray);
        if (((String)object).length() > 0) {
            stringArray2 = Utils.splitOptions((String)object);
            if (stringArray2.length == 0) {
                throw new IllegalArgumentException("Invalid filter specification string");
            }
            String string2 = stringArray2[0];
            stringArray2[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, string2, stringArray2));
        } else {
            this.setFilter(new SpreadSubsample());
        }
    }

    public String[] getOptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-W");
        arrayList.add(this.getEvaluatorSpec());
        arrayList.add("-F");
        arrayList.add(this.getFilterSpec());
        return arrayList.toArray(new String[0]);
    }

    protected String getEvaluatorSpec() {
        SubsetEvaluator subsetEvaluator = this.m_evaluator;
        if (subsetEvaluator instanceof OptionHandler) {
            return subsetEvaluator.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)subsetEvaluator)).getOptions());
        }
        return subsetEvaluator.getClass().getName();
    }

    public String subsetEvaluatorTipText() {
        return "The subset evaluator to be used.";
    }

    public void setSubsetEvaluator(ASEvaluation aSEvaluation) {
        if (!(aSEvaluation instanceof SubsetEvaluator)) {
            throw new IllegalArgumentException("Evaluator must be a SubsetEvaluator!");
        }
        this.m_evaluator = (SubsetEvaluator)((Object)aSEvaluation);
    }

    public ASEvaluation getSubsetEvaluator() {
        return (ASEvaluation)((Object)this.m_evaluator);
    }

    protected String getFilterSpec() {
        Filter filter = this.getFilter();
        if (filter instanceof OptionHandler) {
            return filter.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)filter)).getOptions());
        }
        return filter.getClass().getName();
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5562 $");
    }

    public void buildEvaluator(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        Instances instances2 = new Instances(instances, 0);
        this.m_filter.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_filter);
        if (instances.numAttributes() != instances2.numAttributes()) {
            throw new Exception("Filter must not alter the number of attributes in the data!");
        }
        if (instances2.classIndex() >= 0 && instances.classIndex() != instances2.classIndex()) {
            throw new Exception("Filter must not change the class attribute!");
        }
        for (int i = 0; i < instances2.numAttributes(); ++i) {
            if (instances.attribute(i).name().equals(instances2.attribute(i).name())) continue;
            throw new Exception("Filter must not alter the order of the attributes!");
        }
        this.getSubsetEvaluator().getCapabilities().testWithFail(instances);
        this.m_filteredInstances = instances.stringFreeStructure();
        ((ASEvaluation)((Object)this.m_evaluator)).buildEvaluator(instances);
    }

    public double evaluateSubset(BitSet bitSet) throws Exception {
        return this.m_evaluator.evaluateSubset(bitSet);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_filteredInstances == null) {
            stringBuffer.append("Filtered attribute evaluator has not been built");
        } else {
            stringBuffer.append("Filtered Attribute Evaluator");
            stringBuffer.append("\nFilter: " + this.getFilterSpec());
            stringBuffer.append("\nAttribute evaluator: " + this.getEvaluatorSpec());
            stringBuffer.append("\n\nFiltered header:\n");
            stringBuffer.append(this.m_filteredInstances);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        FilteredSubsetEval.runEvaluator(new FilteredSubsetEval(), stringArray);
    }
}

