/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableClassifier;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.Matrix;

public class BFTree
extends RandomizableClassifier
implements AdditionalMeasureProducer,
TechnicalInformationHandler {
    private static final long serialVersionUID = -7035607375962528217L;
    public static final int PRUNING_UNPRUNED = 0;
    public static final int PRUNING_POSTPRUNING = 1;
    public static final int PRUNING_PREPRUNING = 2;
    public static final Tag[] TAGS_PRUNING = new Tag[]{new Tag(0, "unpruned", "Un-pruned"), new Tag(1, "postpruned", "Post-pruning"), new Tag(2, "prepruned", "Pre-pruning")};
    protected int m_PruningStrategy = 1;
    protected BFTree[] m_Successors;
    protected Attribute m_Attribute;
    protected double m_SplitValue;
    protected String m_SplitString;
    protected double m_ClassValue;
    protected Attribute m_ClassAttribute;
    protected int m_minNumObj = 2;
    protected int m_numFoldsPruning = 5;
    protected boolean m_isLeaf;
    protected static int m_Expansion;
    protected int m_FixedExpansion = -1;
    protected boolean m_Heuristic = true;
    protected boolean m_UseGini = true;
    protected boolean m_UseErrorRate = true;
    protected boolean m_UseOneSE = false;
    protected double[] m_Distribution;
    protected double[] m_Props;
    protected int[][] m_SortedIndices;
    protected double[][] m_Weights;
    protected double[][][] m_Dists;
    protected double[] m_ClassProbs;
    protected double m_TotalWeight;
    protected double m_SizePer = 1.0;

    public String globalInfo() {
        return "Class for building a best-first decision tree classifier. This class uses binary split for both nominal and numeric attributes. For missing values, the method of 'fractional' instances is used.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MASTERSTHESIS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Haijian Shi");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2007");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Best-first decision tree learning");
        technicalInformation.setValue(TechnicalInformation.Field.SCHOOL, "University of Waikato");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, NZ");
        technicalInformation.setValue(TechnicalInformation.Field.NOTE, "COMP594");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.ARTICLE);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Jerome Friedman and Trevor Hastie and Robert Tibshirani");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2000");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Additive logistic regression : A statistical view of boosting");
        technicalInformation2.setValue(TechnicalInformation.Field.JOURNAL, "Annals of statistics");
        technicalInformation2.setValue(TechnicalInformation.Field.VOLUME, "28");
        technicalInformation2.setValue(TechnicalInformation.Field.NUMBER, "2");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "337-407");
        technicalInformation2.setValue(TechnicalInformation.Field.ISSN, "0090-5364");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        Object object;
        int n;
        Object object2;
        int n2;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (this.m_PruningStrategy == 0) {
            int[][] nArray = new int[instances.numAttributes()][0];
            double[][] dArray = new double[instances.numAttributes()][0];
            double[] dArray2 = new double[instances.numClasses()];
            double d = this.computeSortedInfo(instances, nArray, dArray, dArray2);
            double[][][] dArray3 = new double[instances.numAttributes()][2][instances.numClasses()];
            double[][] dArray4 = new double[instances.numAttributes()][2];
            double[][] dArray5 = new double[instances.numAttributes()][2];
            FastVector fastVector = this.computeSplitInfo(this, instances, nArray, dArray, dArray3, dArray4, dArray5, this.m_Heuristic, this.m_UseGini);
            FastVector fastVector2 = new FastVector();
            fastVector2.addElement(fastVector);
            int n3 = ((Attribute)fastVector.elementAt(1)).index();
            m_Expansion = 0;
            this.makeTree(fastVector2, instances, nArray, dArray, dArray3, dArray2, d, dArray4[n3], this.m_minNumObj, this.m_Heuristic, this.m_UseGini, this.m_FixedExpansion);
            return;
        }
        int n4 = 0;
        Random random = new Random(this.m_Seed);
        Instances instances2 = new Instances(instances);
        instances2.randomize(random);
        instances2 = new Instances(instances2, 0, (int)((double)instances2.numInstances() * this.m_SizePer) - 1);
        instances2.stratify(this.m_numFoldsPruning);
        Instances[] instancesArray = new Instances[this.m_numFoldsPruning];
        Instances[] instancesArray2 = new Instances[this.m_numFoldsPruning];
        FastVector[] fastVectorArray = new FastVector[this.m_numFoldsPruning];
        BFTree[] bFTreeArray = new BFTree[this.m_numFoldsPruning];
        int[][][] nArray = new int[this.m_numFoldsPruning][instances.numAttributes()][0];
        double[][][] dArray = new double[this.m_numFoldsPruning][instances.numAttributes()][0];
        double[][] dArray6 = new double[this.m_numFoldsPruning][instances.numClasses()];
        double[] dArray7 = new double[this.m_numFoldsPruning];
        double[][][][] dArray8 = new double[this.m_numFoldsPruning][instances.numAttributes()][2][instances.numClasses()];
        double[][][] dArray9 = new double[this.m_numFoldsPruning][instances.numAttributes()][2];
        double[][][] dArray10 = new double[this.m_numFoldsPruning][instances.numAttributes()][2];
        FastVector[] fastVectorArray2 = new FastVector[this.m_numFoldsPruning];
        for (int i = 0; i < this.m_numFoldsPruning; ++i) {
            instancesArray[i] = instances2.trainCV(this.m_numFoldsPruning, i);
            instancesArray2[i] = instances2.testCV(this.m_numFoldsPruning, i);
            fastVectorArray[i] = new FastVector();
            bFTreeArray[i] = new BFTree();
            dArray7[i] = this.computeSortedInfo(instancesArray[i], nArray[i], dArray[i], dArray6[i]);
            fastVectorArray2[i] = this.computeSplitInfo(bFTreeArray[i], instancesArray[i], nArray[i], dArray[i], dArray8[i], dArray9[i], dArray10[i], this.m_Heuristic, this.m_UseGini);
            n2 = ((Attribute)fastVectorArray2[i].elementAt(1)).index();
            bFTreeArray[i].m_SortedIndices = new int[nArray[i].length][0];
            bFTreeArray[i].m_Weights = new double[dArray[i].length][0];
            bFTreeArray[i].m_Dists = new double[dArray8[i].length][0][0];
            bFTreeArray[i].m_ClassProbs = new double[dArray6[i].length];
            bFTreeArray[i].m_Distribution = new double[dArray6[i].length];
            bFTreeArray[i].m_Props = new double[2];
            for (int j = 0; j < bFTreeArray[i].m_SortedIndices.length; ++j) {
                bFTreeArray[i].m_SortedIndices[j] = nArray[i][j];
                bFTreeArray[i].m_Weights[j] = dArray[i][j];
                bFTreeArray[i].m_Dists[j] = dArray8[i][j];
            }
            System.arraycopy(dArray6[i], 0, bFTreeArray[i].m_ClassProbs, 0, dArray6[i].length);
            if (Utils.sum(bFTreeArray[i].m_ClassProbs) != 0.0) {
                Utils.normalize(bFTreeArray[i].m_ClassProbs);
            }
            System.arraycopy(dArray6[i], 0, bFTreeArray[i].m_Distribution, 0, dArray6[i].length);
            System.arraycopy(dArray9[i][n2], 0, bFTreeArray[i].m_Props, 0, dArray9[i][n2].length);
            bFTreeArray[i].m_TotalWeight = dArray7[i];
            fastVectorArray[i].addElement(fastVectorArray2[i]);
        }
        if (this.m_PruningStrategy == 2) {
            double d;
            double d2;
            double d3 = d2 = Double.MAX_VALUE;
            double d4 = Double.MAX_VALUE;
            int n5 = 0;
            object2 = new FastVector();
            while (true) {
                d = 0.0;
                n = 0;
                for (int i = 0; i < this.m_numFoldsPruning; ++i) {
                    Evaluation evaluation;
                    if (n4 == 0) {
                        bFTreeArray[i].m_isLeaf = true;
                        evaluation = new Evaluation(instancesArray2[i]);
                        evaluation.evaluateModel(bFTreeArray[i], instancesArray2[i], new Object[0]);
                        d = this.m_UseErrorRate ? (d += evaluation.errorRate()) : (d += evaluation.rootMeanSquaredError());
                        ++n;
                        continue;
                    }
                    if (bFTreeArray[i] == null) continue;
                    bFTreeArray[i].m_isLeaf = false;
                    BFTree bFTree = (BFTree)((FastVector)fastVectorArray[i].elementAt(0)).elementAt(0);
                    if (!bFTreeArray[i].makeTree(fastVectorArray[i], bFTreeArray[i], instancesArray[i], bFTree.m_SortedIndices, bFTree.m_Weights, bFTree.m_Dists, bFTree.m_ClassProbs, bFTree.m_TotalWeight, bFTree.m_Props, this.m_minNumObj, this.m_Heuristic, this.m_UseGini)) {
                        bFTreeArray[i] = null;
                        continue;
                    }
                    evaluation = new Evaluation(instancesArray2[i]);
                    evaluation.evaluateModel(bFTreeArray[i], instancesArray2[i], new Object[0]);
                    d = this.m_UseErrorRate ? (d += evaluation.errorRate()) : (d += evaluation.rootMeanSquaredError());
                    ++n;
                }
                if (n == 0) break;
                ((FastVector)object2).addElement(new Double(d /= (double)n));
                d3 = d;
                if (!this.m_UseOneSE) {
                    if (d3 > d2) {
                        break;
                    }
                } else {
                    double d5;
                    if (d < d4) {
                        d4 = d;
                        n5 = n4;
                    }
                    if (d3 > d2 && d3 > d4 + (d5 = Math.sqrt(d4 * (1.0 - d4) / (double)instances.numInstances()))) break;
                }
                ++n4;
                d2 = d3;
            }
            if (!this.m_UseOneSE) {
                --n4;
            } else {
                d = Math.sqrt(d4 * (1.0 - d4) / (double)instances.numInstances());
                for (n = 0; n < ((FastVector)object2).size(); ++n) {
                    double d6 = (Double)((FastVector)object2).elementAt(n);
                    if (!(d6 <= d4 + d)) continue;
                    n4 = n;
                    break;
                }
            }
        } else {
            FastVector[] fastVectorArray3 = new FastVector[this.m_numFoldsPruning];
            for (n2 = 0; n2 < this.m_numFoldsPruning; ++n2) {
                fastVectorArray3[n2] = new FastVector();
                bFTreeArray[n2].m_isLeaf = true;
                Evaluation evaluation = new Evaluation(instancesArray2[n2]);
                evaluation.evaluateModel(bFTreeArray[n2], instancesArray2[n2], new Object[0]);
                double d = this.m_UseErrorRate ? evaluation.errorRate() : evaluation.rootMeanSquaredError();
                fastVectorArray3[n2].addElement(new Double(d));
                bFTreeArray[n2].m_isLeaf = false;
                object = (BFTree)((FastVector)fastVectorArray[n2].elementAt(0)).elementAt(0);
                bFTreeArray[n2].makeTree(fastVectorArray[n2], bFTreeArray[n2], instancesArray[n2], instancesArray2[n2], fastVectorArray3[n2], object.m_SortedIndices, object.m_Weights, object.m_Dists, object.m_ClassProbs, object.m_TotalWeight, object.m_Props, this.m_minNumObj, this.m_Heuristic, this.m_UseGini, this.m_UseErrorRate);
                bFTreeArray[n2] = null;
            }
            double d = Double.MAX_VALUE;
            int n6 = fastVectorArray3[0].size();
            for (int i = 1; i < fastVectorArray3.length; ++i) {
                if (fastVectorArray3[i].size() <= n6) continue;
                n6 = fastVectorArray3[i].size();
            }
            double[] dArray11 = new double[n6];
            object = new int[n6];
            for (int i = 0; i < n6; ++i) {
                object[i] = 0;
                dArray11[i] = 0.0;
                for (int j = 0; j < this.m_numFoldsPruning; ++j) {
                    if (i >= fastVectorArray3[j].size()) continue;
                    int n7 = i;
                    dArray11[n7] = dArray11[n7] + (Double)fastVectorArray3[j].elementAt(i);
                    int n8 = i;
                    object[n8] = object[n8] + 1;
                }
                dArray11[i] = dArray11[i] / (double)object[i];
                if (!(dArray11[i] < d)) continue;
                d = dArray11[i];
                n4 = i;
            }
            if (this.m_UseOneSE) {
                double d7 = Math.sqrt(d * (1.0 - d) / (double)instances.numInstances());
                for (int i = 0; i < n6; ++i) {
                    if (!(dArray11[i] <= d + d7)) continue;
                    n4 = i;
                    break;
                }
            }
        }
        int[][] nArray2 = new int[instances.numAttributes()][0];
        double[][] dArray12 = new double[instances.numAttributes()][0];
        double[] dArray13 = new double[instances.numClasses()];
        double d = this.computeSortedInfo(instances, nArray2, dArray12, dArray13);
        object = new double[instances.numAttributes()][2][instances.numClasses()];
        double[][] dArray14 = new double[instances.numAttributes()][2];
        object2 = new double[instances.numAttributes()][2];
        FastVector fastVector = this.computeSplitInfo(this, instances, nArray2, dArray12, (double[][][])object, dArray14, (double[][])object2, this.m_Heuristic, this.m_UseGini);
        FastVector fastVector3 = new FastVector();
        fastVector3.addElement(fastVector);
        n = ((Attribute)fastVector.elementAt(1)).index();
        m_Expansion = 0;
        this.makeTree(fastVector3, instances, nArray2, dArray12, (double[][][])object, dArray13, d, dArray14[n], this.m_minNumObj, this.m_Heuristic, this.m_UseGini, n4);
    }

    protected void makeTree(FastVector fastVector, Instances instances, int[][] nArray, double[][] dArray, double[][][] dArray2, double[] dArray3, double d, double[] dArray4, int n, boolean bl, boolean bl2, int n2) throws Exception {
        int n3;
        if (fastVector.size() == 0) {
            return;
        }
        FastVector fastVector2 = (FastVector)fastVector.elementAt(0);
        Attribute attribute = (Attribute)fastVector2.elementAt(1);
        double d2 = Double.NaN;
        String string = null;
        if (attribute.isNumeric()) {
            d2 = (Double)fastVector2.elementAt(2);
        } else {
            string = ((String)fastVector2.elementAt(2)).toString();
        }
        double d3 = (Double)fastVector2.elementAt(3);
        if (this.m_ClassProbs == null) {
            this.m_SortedIndices = new int[nArray.length][0];
            this.m_Weights = new double[dArray.length][0];
            this.m_Dists = new double[dArray2.length][0][0];
            this.m_ClassProbs = new double[dArray3.length];
            this.m_Distribution = new double[dArray3.length];
            this.m_Props = new double[2];
            for (n3 = 0; n3 < this.m_SortedIndices.length; ++n3) {
                this.m_SortedIndices[n3] = nArray[n3];
                this.m_Weights[n3] = dArray[n3];
                this.m_Dists[n3] = dArray2[n3];
            }
            System.arraycopy(dArray3, 0, this.m_ClassProbs, 0, dArray3.length);
            System.arraycopy(dArray3, 0, this.m_Distribution, 0, dArray3.length);
            System.arraycopy(dArray4, 0, this.m_Props, 0, this.m_Props.length);
            this.m_TotalWeight = d;
            if (Utils.sum(this.m_ClassProbs) != 0.0) {
                Utils.normalize(this.m_ClassProbs);
            }
        }
        if (d < (double)(2 * n) || dArray4[0] == 0.0 || dArray4[1] == 0.0) {
            fastVector.removeElementAt(0);
            this.makeLeaf(instances);
            if (fastVector.size() != 0) {
                FastVector fastVector3 = (FastVector)fastVector.elementAt(0);
                BFTree bFTree = (BFTree)fastVector3.elementAt(0);
                bFTree.makeTree(fastVector, instances, bFTree.m_SortedIndices, bFTree.m_Weights, bFTree.m_Dists, bFTree.m_ClassProbs, bFTree.m_TotalWeight, bFTree.m_Props, n, bl, bl2, n2);
            }
            return;
        }
        if (d3 == 0.0 || n2 == m_Expansion) {
            for (n3 = 0; n3 < fastVector.size(); ++n3) {
                FastVector fastVector4 = (FastVector)fastVector.elementAt(n3);
                BFTree bFTree = (BFTree)fastVector4.elementAt(0);
                bFTree.makeLeaf(instances);
            }
            fastVector.removeAllElements();
        } else {
            fastVector.removeElementAt(0);
            this.m_Attribute = attribute;
            if (this.m_Attribute.isNumeric()) {
                this.m_SplitValue = d2;
            } else {
                this.m_SplitString = string;
            }
            int[][][] nArray2 = new int[2][instances.numAttributes()][0];
            double[][][] dArray5 = new double[2][instances.numAttributes()][0];
            this.splitData(nArray2, dArray5, this.m_Attribute, this.m_SplitValue, this.m_SplitString, nArray, dArray, instances);
            int n4 = attribute.index();
            if (nArray2[0][n4].length < n || nArray2[1][n4].length < n) {
                this.makeLeaf(instances);
            } else {
                this.m_isLeaf = false;
                this.m_Attribute = attribute;
                if (this.m_PruningStrategy == 2 || this.m_PruningStrategy == 1 || n2 != -1) {
                    ++m_Expansion;
                }
                this.makeSuccessors(fastVector, instances, nArray2, dArray5, dArray2, attribute, bl, bl2);
            }
            if (fastVector.size() != 0) {
                FastVector fastVector5 = (FastVector)fastVector.elementAt(0);
                BFTree bFTree = (BFTree)fastVector5.elementAt(0);
                bFTree.makeTree(fastVector, instances, bFTree.m_SortedIndices, bFTree.m_Weights, bFTree.m_Dists, bFTree.m_ClassProbs, bFTree.m_TotalWeight, bFTree.m_Props, n, bl, bl2, n2);
            }
        }
    }

    protected boolean makeTree(FastVector fastVector, BFTree bFTree, Instances instances, int[][] nArray, double[][] dArray, double[][][] dArray2, double[] dArray3, double d, double[] dArray4, int n, boolean bl, boolean bl2) throws Exception {
        if (fastVector.size() == 0) {
            return false;
        }
        FastVector fastVector2 = (FastVector)fastVector.elementAt(0);
        BFTree bFTree2 = (BFTree)fastVector2.elementAt(0);
        Attribute attribute = (Attribute)fastVector2.elementAt(1);
        double d2 = Double.NaN;
        String string = null;
        if (attribute.isNumeric()) {
            d2 = (Double)fastVector2.elementAt(2);
        } else {
            string = ((String)fastVector2.elementAt(2)).toString();
        }
        double d3 = (Double)fastVector2.elementAt(3);
        if (d < (double)(2 * n) || dArray4[0] == 0.0 || dArray4[1] == 0.0) {
            fastVector.removeElementAt(0);
            bFTree2.makeLeaf(instances);
            BFTree bFTree3 = (BFTree)((FastVector)fastVector.elementAt(0)).elementAt(0);
            return bFTree.makeTree(fastVector, bFTree, instances, bFTree3.m_SortedIndices, bFTree3.m_Weights, bFTree3.m_Dists, bFTree3.m_ClassProbs, bFTree3.m_TotalWeight, bFTree3.m_Props, n, bl, bl2);
        }
        if (d3 == 0.0) {
            for (int i = 0; i < fastVector.size(); ++i) {
                FastVector fastVector3 = (FastVector)fastVector.elementAt(i);
                BFTree bFTree4 = (BFTree)fastVector3.elementAt(0);
                bFTree4.makeLeaf(instances);
            }
            fastVector.removeAllElements();
            return false;
        }
        fastVector.removeElementAt(0);
        bFTree2.m_Attribute = attribute;
        if (attribute.isNumeric()) {
            bFTree2.m_SplitValue = d2;
        } else {
            bFTree2.m_SplitString = string;
        }
        int[][][] nArray2 = new int[2][instances.numAttributes()][0];
        double[][][] dArray5 = new double[2][instances.numAttributes()][0];
        this.splitData(nArray2, dArray5, bFTree2.m_Attribute, bFTree2.m_SplitValue, bFTree2.m_SplitString, bFTree2.m_SortedIndices, bFTree2.m_Weights, instances);
        int n2 = attribute.index();
        if (nArray2[0][n2].length < n || nArray2[1][n2].length < n) {
            bFTree2.makeLeaf(instances);
            BFTree bFTree5 = (BFTree)((FastVector)fastVector.elementAt(0)).elementAt(0);
            return bFTree.makeTree(fastVector, bFTree, instances, bFTree5.m_SortedIndices, bFTree5.m_Weights, bFTree5.m_Dists, bFTree5.m_ClassProbs, bFTree5.m_TotalWeight, bFTree5.m_Props, n, bl, bl2);
        }
        bFTree2.m_isLeaf = false;
        bFTree2.m_Attribute = attribute;
        bFTree2.makeSuccessors(fastVector, instances, nArray2, dArray5, dArray2, bFTree2.m_Attribute, bl, bl2);
        for (int i = 0; i < 2; ++i) {
            bFTree2.m_Successors[i].makeLeaf(instances);
        }
        return true;
    }

    protected void makeTree(FastVector fastVector, BFTree bFTree, Instances instances, Instances instances2, FastVector fastVector2, int[][] nArray, double[][] dArray, double[][][] dArray2, double[] dArray3, double d, double[] dArray4, int n, boolean bl, boolean bl2, boolean bl3) throws Exception {
        if (fastVector.size() == 0) {
            return;
        }
        FastVector fastVector3 = (FastVector)fastVector.elementAt(0);
        Attribute attribute = (Attribute)fastVector3.elementAt(1);
        double d2 = Double.NaN;
        String string = null;
        if (attribute.isNumeric()) {
            d2 = (Double)fastVector3.elementAt(2);
        } else {
            string = ((String)fastVector3.elementAt(2)).toString();
        }
        double d3 = (Double)fastVector3.elementAt(3);
        if (d < (double)(2 * n) || dArray4[0] == 0.0 || dArray4[1] == 0.0) {
            fastVector.removeElementAt(0);
            this.makeLeaf(instances);
            if (fastVector.size() == 0) {
                return;
            }
            BFTree bFTree2 = (BFTree)((FastVector)fastVector.elementAt(0)).elementAt(0);
            bFTree2.makeTree(fastVector, bFTree, instances, instances2, fastVector2, bFTree2.m_SortedIndices, bFTree2.m_Weights, bFTree2.m_Dists, bFTree2.m_ClassProbs, bFTree2.m_TotalWeight, bFTree2.m_Props, n, bl, bl2, bl3);
            return;
        }
        if (d3 == 0.0) {
            for (int i = 0; i < fastVector.size(); ++i) {
                FastVector fastVector4 = (FastVector)fastVector.elementAt(i);
                BFTree bFTree3 = (BFTree)fastVector4.elementAt(0);
                bFTree3.makeLeaf(instances);
            }
            fastVector.removeAllElements();
        } else {
            RevisionHandler revisionHandler;
            fastVector.removeElementAt(0);
            this.m_Attribute = attribute;
            if (attribute.isNumeric()) {
                this.m_SplitValue = d2;
            } else {
                this.m_SplitString = string;
            }
            int[][][] nArray2 = new int[2][instances.numAttributes()][0];
            double[][][] dArray5 = new double[2][instances.numAttributes()][0];
            this.splitData(nArray2, dArray5, this.m_Attribute, this.m_SplitValue, this.m_SplitString, nArray, dArray, instances);
            int n2 = attribute.index();
            if (nArray2[0][n2].length < n || nArray2[1][n2].length < n) {
                this.makeLeaf(instances);
            } else {
                this.m_isLeaf = false;
                this.m_Attribute = attribute;
                this.makeSuccessors(fastVector, instances, nArray2, dArray5, dArray2, this.m_Attribute, bl, bl2);
                for (int i = 0; i < 2; ++i) {
                    this.m_Successors[i].makeLeaf(instances);
                }
                revisionHandler = new Evaluation(instances2);
                ((Evaluation)revisionHandler).evaluateModel(bFTree, instances2, new Object[0]);
                double d4 = bl3 ? ((Evaluation)revisionHandler).errorRate() : ((Evaluation)revisionHandler).rootMeanSquaredError();
                fastVector2.addElement(new Double(d4));
            }
            if (fastVector.size() != 0) {
                revisionHandler = (FastVector)fastVector.elementAt(0);
                BFTree bFTree4 = (BFTree)((FastVector)revisionHandler).elementAt(0);
                bFTree4.makeTree(fastVector, bFTree, instances, instances2, fastVector2, bFTree4.m_SortedIndices, bFTree4.m_Weights, bFTree4.m_Dists, bFTree4.m_ClassProbs, bFTree4.m_TotalWeight, bFTree4.m_Props, n, bl, bl2, bl3);
            }
        }
    }

    protected void makeSuccessors(FastVector fastVector, Instances instances, int[][][] nArray, double[][][] dArray, double[][][] dArray2, Attribute attribute, boolean bl, boolean bl2) throws Exception {
        this.m_Successors = new BFTree[2];
        block0: for (int i = 0; i < 2; ++i) {
            int n;
            FastVector fastVector2;
            int n2;
            this.m_Successors[i] = new BFTree();
            this.m_Successors[i].m_isLeaf = true;
            this.m_Successors[i].m_ClassProbs = new double[instances.numClasses()];
            this.m_Successors[i].m_Distribution = new double[instances.numClasses()];
            System.arraycopy(dArray2[attribute.index()][i], 0, this.m_Successors[i].m_ClassProbs, 0, this.m_Successors[i].m_ClassProbs.length);
            System.arraycopy(dArray2[attribute.index()][i], 0, this.m_Successors[i].m_Distribution, 0, this.m_Successors[i].m_Distribution.length);
            if (Utils.sum(this.m_Successors[i].m_ClassProbs) != 0.0) {
                Utils.normalize(this.m_Successors[i].m_ClassProbs);
            }
            double[][] dArray3 = new double[instances.numAttributes()][2];
            double[][][] dArray4 = new double[instances.numAttributes()][2][instances.numClasses()];
            double[][] dArray5 = new double[instances.numAttributes()][2];
            FastVector fastVector3 = this.m_Successors[i].computeSplitInfo(this.m_Successors[i], instances, nArray[i], dArray[i], dArray4, dArray3, dArray5, bl, bl2);
            int n3 = ((Attribute)fastVector3.elementAt(1)).index();
            this.m_Successors[i].m_Props = new double[2];
            System.arraycopy(dArray3[n3], 0, this.m_Successors[i].m_Props, 0, this.m_Successors[i].m_Props.length);
            this.m_Successors[i].m_SortedIndices = new int[instances.numAttributes()][0];
            this.m_Successors[i].m_Weights = new double[instances.numAttributes()][0];
            for (n2 = 0; n2 < this.m_Successors[i].m_SortedIndices.length; ++n2) {
                this.m_Successors[i].m_SortedIndices[n2] = nArray[i][n2];
                this.m_Successors[i].m_Weights[n2] = dArray[i][n2];
            }
            this.m_Successors[i].m_Dists = new double[instances.numAttributes()][2][instances.numClasses()];
            for (n2 = 0; n2 < dArray4.length; ++n2) {
                this.m_Successors[i].m_Dists[n2] = dArray4[n2];
            }
            this.m_Successors[i].m_TotalWeight = Utils.sum(dArray5[n3]);
            if (fastVector.size() == 0) {
                fastVector.addElement(fastVector3);
                continue;
            }
            double d = (Double)fastVector3.elementAt(3);
            if (d < (Double)(fastVector2 = (FastVector)fastVector.elementAt((n = fastVector.size()) - 1)).elementAt(3)) {
                fastVector.insertElementAt(fastVector3, n);
                continue;
            }
            for (int j = 0; j < n; ++j) {
                FastVector fastVector4 = (FastVector)fastVector.elementAt(j);
                double d2 = (Double)fastVector4.elementAt(3);
                if (!(d >= d2)) continue;
                fastVector.insertElementAt(fastVector3, j);
                continue block0;
            }
        }
    }

    protected double computeSortedInfo(Instances instances, int[][] nArray, double[][] dArray, double[] dArray2) throws Exception {
        Instance instance;
        int n;
        double[] dArray3 = new double[instances.numInstances()];
        for (int i = 0; i < instances.numAttributes(); ++i) {
            int n2;
            if (i == instances.classIndex()) continue;
            dArray[i] = new double[instances.numInstances()];
            if (instances.attribute(i).isNominal()) {
                nArray[i] = new int[instances.numInstances()];
                n2 = 0;
                for (n = 0; n < instances.numInstances(); ++n) {
                    instance = instances.instance(n);
                    if (instance.isMissing(i)) continue;
                    nArray[i][n2] = n;
                    dArray[i][n2] = instance.weight();
                    ++n2;
                }
                for (n = 0; n < instances.numInstances(); ++n) {
                    instance = instances.instance(n);
                    if (!instance.isMissing(i)) continue;
                    nArray[i][n2] = n;
                    dArray[i][n2] = instance.weight();
                    ++n2;
                }
                continue;
            }
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                Instance instance2 = instances.instance(n2);
                dArray3[n2] = instance2.value(i);
            }
            nArray[i] = Utils.sort(dArray3);
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                dArray[i][n2] = instances.instance(nArray[i][n2]).weight();
            }
        }
        double d = 0.0;
        for (n = 0; n < instances.numInstances(); ++n) {
            instance = instances.instance(n);
            int n3 = (int)instance.classValue();
            dArray2[n3] = dArray2[n3] + instance.weight();
            d += instance.weight();
        }
        return d;
    }

    protected FastVector computeSplitInfo(BFTree bFTree, Instances instances, int[][] nArray, double[][] dArray, double[][][] dArray2, double[][] dArray3, double[][] dArray4, boolean bl, boolean bl2) throws Exception {
        int n;
        double[] dArray5 = new double[instances.numAttributes()];
        String[] stringArray = new String[instances.numAttributes()];
        double[] dArray6 = new double[instances.numAttributes()];
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == instances.classIndex()) continue;
            Attribute attribute = instances.attribute(n);
            if (attribute.isNumeric()) {
                dArray5[n] = this.numericDistribution(dArray3, dArray2, attribute, nArray[n], dArray[n], dArray4, dArray6, instances, bl2);
                continue;
            }
            stringArray[n] = this.nominalDistribution(dArray3, dArray2, attribute, nArray[n], dArray[n], dArray4, dArray6, instances, bl, bl2);
        }
        n = Utils.maxIndex(dArray6);
        double d = dArray6[n];
        Attribute attribute = instances.attribute(n);
        double d2 = Double.NaN;
        String string = null;
        if (attribute.isNumeric()) {
            d2 = dArray5[n];
        } else {
            string = stringArray[n];
            if (string == null) {
                string = "";
            }
        }
        FastVector fastVector = new FastVector();
        fastVector.addElement(bFTree);
        fastVector.addElement(attribute);
        if (attribute.isNumeric()) {
            fastVector.addElement(new Double(d2));
        } else {
            fastVector.addElement(string);
        }
        fastVector.addElement(new Double(d));
        return fastVector;
    }

    protected double numericDistribution(double[][] dArray, double[][][] dArray2, Attribute attribute, int[] nArray, double[] dArray3, double[][] dArray4, double[] dArray5, Instances instances, boolean bl) throws Exception {
        int n;
        Instance instance;
        double d = Double.NaN;
        double[][] dArray6 = null;
        int n2 = instances.numClasses();
        double[][] dArray7 = new double[2][n2];
        dArray6 = new double[2][n2];
        double[] dArray8 = new double[n2];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            Instance instance2 = instances.instance(nArray[i]);
            if (!instance2.isMissing(attribute)) {
                ++n3;
                double[] dArray9 = dArray7[1];
                int n4 = (int)instance2.classValue();
                dArray9[n4] = dArray9[n4] + dArray3[i];
            }
            int n5 = (int)instance2.classValue();
            dArray8[n5] = dArray8[n5] + dArray3[i];
        }
        System.arraycopy(dArray7[1], 0, dArray6[1], 0, dArray6[1].length);
        double d2 = instances.instance(nArray[0]).value(attribute);
        double d3 = -1.7976931348623157E308;
        for (int i = 0; i < nArray.length && !(instance = instances.instance(nArray[i])).isMissing(attribute); ++i) {
            if (instance.value(attribute) > d2) {
                int n6;
                double[][] dArray10 = new double[2][n2];
                for (int j = 0; j < 2; ++j) {
                    System.arraycopy(dArray7[j], 0, dArray10[j], 0, dArray10[j].length);
                }
                double[] dArray11 = new double[2];
                for (n6 = 0; n6 < 2; ++n6) {
                    dArray11[n6] = Utils.sum(dArray10[n6]);
                }
                if (Utils.sum(dArray11) != 0.0) {
                    Utils.normalize(dArray11);
                }
                for (n6 = n3; n6 < nArray.length; ++n6) {
                    Instance instance3 = instances.instance(nArray[n6]);
                    for (int j = 0; j < 2; ++j) {
                        double[] dArray12 = dArray10[j];
                        int n7 = (int)instance3.classValue();
                        dArray12[n7] = dArray12[n7] + dArray11[j] * dArray3[n6];
                    }
                }
                double d4 = bl ? this.computeGiniGain(dArray8, dArray10) : this.computeInfoGain(dArray8, dArray10);
                if (d4 > d3) {
                    d3 = d4;
                    d = Math.rint((instance.value(attribute) + d2) / 2.0 * 100000.0) / 100000.0;
                    for (int j = 0; j < dArray7.length; ++j) {
                        System.arraycopy(dArray10[j], 0, dArray6[j], 0, dArray6[j].length);
                    }
                }
            }
            d2 = instance.value(attribute);
            double[] dArray13 = dArray7[0];
            int n8 = (int)instance.classValue();
            dArray13[n8] = dArray13[n8] + dArray3[i];
            double[] dArray14 = dArray7[1];
            int n9 = (int)instance.classValue();
            dArray14[n9] = dArray14[n9] - dArray3[i];
        }
        int n10 = attribute.index();
        dArray[n10] = new double[2];
        for (n = 0; n < 2; ++n) {
            dArray[n10][n] = Utils.sum(dArray6[n]);
        }
        if (Utils.sum(dArray[n10]) != 0.0) {
            Utils.normalize(dArray[n10]);
        }
        dArray4[n10] = new double[2];
        for (n = 0; n < 2; ++n) {
            double[] dArray15 = dArray4[n10];
            int n11 = n;
            dArray15[n11] = dArray15[n11] + Utils.sum(dArray6[n]);
        }
        dArray5[n10] = Math.rint(d3 * 1.0E7) / 1.0E7;
        dArray2[n10] = dArray6;
        return d;
    }

    protected String nominalDistribution(double[][] dArray, double[][][] dArray2, Attribute attribute, int[] nArray, double[] dArray3, double[][] dArray4, double[] dArray5, Instances instances, boolean bl, boolean bl2) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String[] stringArray = new String[attribute.numValues()];
        int n6 = stringArray.length;
        int n7 = instances.numClasses();
        String string = "";
        double d = -1.7976931348623157E308;
        int[] nArray2 = new int[n6];
        for (int i = 0; i < n6; ++i) {
            nArray2[i] = 0;
        }
        double[] dArray6 = new double[n7];
        double[][] dArray7 = new double[2][n7];
        double[][] dArray8 = new double[2][n7];
        int n8 = 0;
        for (n5 = 0; n5 < nArray.length; ++n5) {
            Instance instance = instances.instance(nArray[n5]);
            if (!instance.isMissing(attribute)) {
                ++n8;
                int n9 = (int)instance.value(attribute);
                nArray2[n9] = nArray2[n9] + 1;
            }
            int n10 = (int)instance.classValue();
            dArray6[n10] = dArray6[n10] + dArray3[n5];
        }
        n5 = 0;
        for (int i = 0; i < n6; ++i) {
            if (nArray2[i] == 0) continue;
            ++n5;
        }
        String[] stringArray2 = new String[n5];
        int n11 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            if (nArray2[n4] == 0) continue;
            stringArray2[n11] = attribute.value(n4);
            ++n11;
        }
        n4 = n6 - n5;
        String[] stringArray3 = new String[n4];
        int n12 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            if (nArray2[n3] != 0) continue;
            stringArray3[n12] = attribute.value(n3);
            ++n12;
        }
        if (n5 <= 1) {
            dArray5[attribute.index()] = 0.0;
            return "";
        }
        if (instances.numClasses() == 2) {
            int n13;
            Instance instance;
            int n14;
            double[] dArray9 = new double[n5];
            double[][] dArray10 = new double[n5][2];
            for (n14 = 0; n14 < n5; ++n14) {
                for (int i = 0; i < 2; ++i) {
                    dArray10[n14][i] = 0.0;
                }
            }
            block7: for (n14 = 0; n14 < nArray.length && !(instance = instances.instance(nArray[n14])).isMissing(attribute); ++n14) {
                for (n13 = 0; n13 < n5; ++n13) {
                    if (attribute.value((int)instance.value(attribute)).compareTo(stringArray2[n13]) != 0) continue;
                    double[] dArray11 = dArray10[n13];
                    int n15 = (int)instance.classValue();
                    dArray11[n15] = dArray11[n15] + instance.weight();
                    continue block7;
                }
            }
            for (n14 = 0; n14 < n5; ++n14) {
                double d2 = Utils.sum(dArray10[n14]);
                dArray9[n14] = d2 == 0.0 ? 0.0 : dArray10[n14][0] / d2;
            }
            String[] stringArray4 = new String[n5];
            for (int i = 0; i < n5; ++i) {
                stringArray4[i] = stringArray2[Utils.minIndex(dArray9)];
                dArray9[Utils.minIndex((double[])dArray9)] = Double.MAX_VALUE;
            }
            String string2 = "";
            for (n13 = 0; n13 < n5 - 1; ++n13) {
                int n16;
                Object object;
                dArray7 = new double[2][n7];
                string2 = string2 == "" ? "(" + stringArray4[n13] + ")" : string2 + "|(" + stringArray4[n13] + ")";
                for (int i = 0; i < nArray.length && !((Instance)(object = instances.instance(nArray[i]))).isMissing(attribute); ++i) {
                    if (string2.indexOf("(" + attribute.value((int)((Instance)object).value(attribute)) + ")") != -1) {
                        double[] dArray12 = dArray7[0];
                        int n17 = (int)((Instance)object).classValue();
                        dArray12[n17] = dArray12[n17] + dArray3[i];
                        continue;
                    }
                    double[] dArray13 = dArray7[1];
                    int n18 = (int)((Instance)object).classValue();
                    dArray13[n18] = dArray13[n18] + dArray3[i];
                }
                double[][] dArray14 = new double[2][n7];
                for (int i = 0; i < 2; ++i) {
                    dArray14[i] = dArray7[i];
                }
                object = new double[2];
                for (n16 = 0; n16 < 2; ++n16) {
                    object[n16] = Utils.sum(dArray14[n16]);
                }
                if (Utils.sum((double[])object) != 0.0) {
                    Utils.normalize((double[])object);
                }
                for (n16 = n8; n16 < nArray.length; ++n16) {
                    Instance instance2 = instances.instance(nArray[n16]);
                    for (int i = 0; i < 2; ++i) {
                        double[] dArray15 = dArray14[i];
                        int n19 = (int)instance2.classValue();
                        dArray15[n19] = dArray15[n19] + object[i] * dArray3[n16];
                    }
                }
                double d3 = bl2 ? this.computeGiniGain(dArray6, dArray14) : this.computeInfoGain(dArray6, dArray14);
                if (!(d3 > d)) continue;
                d = d3;
                string = string2;
                for (n2 = 0; n2 < 2; ++n2) {
                    System.arraycopy(dArray14[n2], 0, dArray8[n2], 0, dArray8[n2].length);
                }
            }
        } else if (!bl || n5 <= 4) {
            for (n3 = 0; n3 < (int)Math.pow(2.0, n5 - 1); ++n3) {
                int n20;
                Object object;
                int n21;
                String string3 = "";
                dArray7 = new double[2][n7];
                int n22 = n3;
                for (n21 = n5 - 1; n21 >= 0; --n21) {
                    int n23 = n22 % 2;
                    if (n23 == 1) {
                        string3 = string3 == "" ? "(" + stringArray2[n21] + ")" : string3 + "|(" + stringArray2[n21] + ")";
                    }
                    n22 /= 2;
                }
                for (n21 = 0; n21 < nArray.length && !((Instance)(object = instances.instance(nArray[n21]))).isMissing(attribute); ++n21) {
                    if (string3.indexOf("(" + attribute.value((int)((Instance)object).value(attribute)) + ")") != -1) {
                        double[] dArray16 = dArray7[0];
                        int n24 = (int)((Instance)object).classValue();
                        dArray16[n24] = dArray16[n24] + dArray3[n21];
                        continue;
                    }
                    double[] dArray17 = dArray7[1];
                    int n25 = (int)((Instance)object).classValue();
                    dArray17[n25] = dArray17[n25] + dArray3[n21];
                }
                double[][] dArray18 = new double[2][n7];
                for (int i = 0; i < 2; ++i) {
                    dArray18[i] = dArray7[i];
                }
                object = new double[2];
                for (n20 = 0; n20 < 2; ++n20) {
                    object[n20] = Utils.sum(dArray18[n20]);
                }
                if (Utils.sum((double[])object) != 0.0) {
                    Utils.normalize((double[])object);
                }
                for (n20 = n8; n20 < nArray.length; ++n20) {
                    Instance instance = instances.instance(nArray[n20]);
                    for (int i = 0; i < 2; ++i) {
                        double[] dArray19 = dArray18[i];
                        int n26 = (int)instance.classValue();
                        dArray19[n26] = dArray19[n26] + object[i] * dArray3[n20];
                    }
                }
                double d4 = bl2 ? this.computeGiniGain(dArray6, dArray18) : this.computeInfoGain(dArray6, dArray18);
                if (!(d4 > d)) continue;
                d = d4;
                string = string3;
                for (int i = 0; i < 2; ++i) {
                    System.arraycopy(dArray18[i], 0, dArray8[i], 0, dArray8[i].length);
                }
            }
        } else {
            int n27;
            int n28;
            n3 = n5;
            int n29 = instances.numClasses();
            double[][] dArray20 = new double[n3][n29];
            int[] nArray3 = new int[n3];
            double[] dArray21 = new double[n29];
            int n30 = instances.numInstances();
            for (n28 = 0; n28 < dArray21.length; ++n28) {
                dArray21[n28] = 0.0;
            }
            for (n28 = 0; n28 < n30; ++n28) {
                Instance instance = instances.instance(n28);
                n27 = 0;
                for (int i = 0; i < n5; ++i) {
                    if (attribute.value((int)instance.value(attribute)).compareToIgnoreCase(stringArray2[i]) != 0) continue;
                    n27 = i;
                    break;
                }
                double[] dArray22 = dArray20[n27];
                int n31 = (int)instance.classValue();
                dArray22[n31] = dArray22[n31] + 1.0;
                int n32 = n27;
                nArray3[n32] = nArray3[n32] + 1;
                int n33 = (int)instance.classValue();
                dArray21[n33] = dArray21[n33] + 1.0;
            }
            for (n28 = 0; n28 < dArray20.length; ++n28) {
                for (int i = 0; i < dArray20[0].length; ++i) {
                    if (nArray3[n28] == 0) {
                        dArray20[n28][i] = 0.0;
                        continue;
                    }
                    double[] dArray23 = dArray20[n28];
                    int n34 = i;
                    dArray23[n34] = dArray23[n34] / (double)nArray3[n28];
                }
            }
            n28 = 0;
            while (n28 < dArray21.length) {
                int n35 = n28++;
                dArray21[n35] = dArray21[n35] / (double)n30;
            }
            double[][] dArray24 = new double[n29][n29];
            for (int i = 0; i < n29; ++i) {
                for (n27 = 0; n27 < n29; ++n27) {
                    double d5 = 0.0;
                    for (int j = 0; j < n3; ++j) {
                        d5 += (dArray20[j][n27] - dArray21[n27]) * (dArray20[j][i] - dArray21[i]) * (double)nArray3[j];
                    }
                    dArray24[i][n27] = d5;
                }
            }
            Matrix matrix = new Matrix(dArray24);
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
            double[] dArray25 = eigenvalueDecomposition.getRealEigenvalues();
            n2 = 0;
            double d6 = dArray25[0];
            for (int i = 1; i < dArray25.length; ++i) {
                if (!(dArray25[i] > d6)) continue;
                n2 = i;
                d6 = dArray25[i];
            }
            double[] dArray26 = new double[n29];
            Matrix matrix2 = eigenvalueDecomposition.getV();
            double[][] dArray27 = matrix2.getArray();
            for (int i = 0; i < dArray26.length; ++i) {
                dArray26[i] = dArray27[i][n2];
            }
            double[] dArray28 = new double[n3];
            for (int i = 0; i < dArray28.length; ++i) {
                dArray28[i] = 0.0;
                for (int j = 0; j < n29; ++j) {
                    int n36 = i;
                    dArray28[n36] = dArray28[n36] + dArray26[j] * dArray20[i][j];
                }
            }
            double[] dArray29 = new double[n3];
            System.arraycopy(dArray28, 0, dArray29, 0, n3);
            String[] stringArray5 = new String[n3];
            Arrays.sort(dArray28);
            for (int i = 0; i < n3; ++i) {
                stringArray5[i] = stringArray2[Utils.minIndex(dArray29)];
                dArray29[Utils.minIndex((double[])dArray29)] = Double.MAX_VALUE;
            }
            String string4 = "";
            for (int i = 0; i < n5 - 1; ++i) {
                int n37;
                Object object;
                dArray7 = new double[2][n7];
                string4 = string4 == "" ? "(" + stringArray5[i] + ")" : string4 + "|(" + stringArray5[i] + ")";
                for (int j = 0; j < nArray.length && !((Instance)(object = instances.instance(nArray[j]))).isMissing(attribute); ++j) {
                    if (string4.indexOf("(" + attribute.value((int)((Instance)object).value(attribute)) + ")") != -1) {
                        double[] dArray30 = dArray7[0];
                        int n38 = (int)((Instance)object).classValue();
                        dArray30[n38] = dArray30[n38] + dArray3[j];
                        continue;
                    }
                    double[] dArray31 = dArray7[1];
                    int n39 = (int)((Instance)object).classValue();
                    dArray31[n39] = dArray31[n39] + dArray3[j];
                }
                double[][] dArray32 = new double[2][n7];
                for (int j = 0; j < 2; ++j) {
                    dArray32[j] = dArray7[j];
                }
                object = new double[2];
                for (n37 = 0; n37 < 2; ++n37) {
                    object[n37] = Utils.sum(dArray32[n37]);
                }
                if (Utils.sum((double[])object) != 0.0) {
                    Utils.normalize((double[])object);
                }
                for (n37 = n8; n37 < nArray.length; ++n37) {
                    Instance instance = instances.instance(nArray[n37]);
                    for (int j = 0; j < 2; ++j) {
                        double[] dArray33 = dArray32[j];
                        int n40 = (int)instance.classValue();
                        dArray33[n40] = dArray33[n40] + object[j] * dArray3[n37];
                    }
                }
                double d7 = bl2 ? this.computeGiniGain(dArray6, dArray32) : this.computeInfoGain(dArray6, dArray32);
                if (!(d7 > d)) continue;
                d = d7;
                string = string4;
                for (int j = 0; j < 2; ++j) {
                    System.arraycopy(dArray32[j], 0, dArray8[j], 0, dArray8[j].length);
                }
            }
        }
        int n41 = attribute.index();
        dArray[n41] = new double[2];
        for (n = 0; n < 2; ++n) {
            dArray[n41][n] = Utils.sum(dArray8[n]);
        }
        if (!(Utils.sum(dArray[n41]) > 0.0)) {
            for (n = 0; n < dArray[n41].length; ++n) {
                dArray[n41][n] = 1.0 / (double)dArray[n41].length;
            }
        } else {
            Utils.normalize(dArray[n41]);
        }
        dArray4[n41] = new double[2];
        for (n = 0; n < 2; ++n) {
            double[] dArray34 = dArray4[n41];
            int n42 = n;
            dArray34[n42] = dArray34[n42] + Utils.sum(dArray8[n]);
        }
        for (n = 0; n < n4; ++n) {
            if (!(dArray[n41][0] >= dArray[n41][1])) continue;
            string = string == "" ? "(" + stringArray3[n] + ")" : string + "|(" + stringArray3[n] + ")";
        }
        dArray5[n41] = Math.rint(d * 1.0E7) / 1.0E7;
        dArray2[n41] = dArray8;
        return string;
    }

    protected void splitData(int[][][] nArray, double[][][] dArray, Attribute attribute, double d, String string, int[][] nArray2, double[][] dArray2, Instances instances) throws Exception {
        for (int i = 0; i < instances.numAttributes(); ++i) {
            int n;
            if (i == instances.classIndex()) continue;
            int[] nArray3 = new int[2];
            for (n = 0; n < 2; ++n) {
                nArray[n][i] = new int[nArray2[i].length];
                dArray[n][i] = new double[dArray2[i].length];
            }
            for (int j = 0; j < nArray2[i].length; ++j) {
                int n2;
                Instance instance = instances.instance(nArray2[i][j]);
                if (instance.isMissing(attribute)) {
                    for (n2 = 0; n2 < 2; ++n2) {
                        if (!(this.m_Props[n2] > 0.0)) continue;
                        nArray[n2][i][nArray3[n2]] = nArray2[i][j];
                        dArray[n2][i][nArray3[n2]] = this.m_Props[n2] * dArray2[i][j];
                        int n3 = n2;
                        nArray3[n3] = nArray3[n3] + 1;
                    }
                    continue;
                }
                n2 = attribute.isNumeric() ? (instance.value(attribute) < d ? 0 : 1) : (string.indexOf("(" + attribute.value((int)instance.value(attribute.index())) + ")") != -1 ? 0 : 1);
                nArray[n2][i][nArray3[n2]] = nArray2[i][j];
                dArray[n2][i][nArray3[n2]] = dArray2[i][j];
                int n4 = n2;
                nArray3[n4] = nArray3[n4] + 1;
            }
            for (n = 0; n < 2; ++n) {
                int[] nArray4 = new int[nArray3[n]];
                System.arraycopy(nArray[n][i], 0, nArray4, 0, nArray3[n]);
                nArray[n][i] = nArray4;
                double[] dArray3 = new double[nArray3[n]];
                System.arraycopy(dArray[n][i], 0, dArray3, 0, nArray3[n]);
                dArray[n][i] = dArray3;
            }
        }
    }

    protected double computeGiniGain(double[] dArray, double[][] dArray2) {
        double d = Utils.sum(dArray);
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = Utils.sum(dArray2[0]);
        double d3 = Utils.sum(dArray2[1]);
        double d4 = this.computeGini(dArray, d);
        double d5 = this.computeGini(dArray2[0], d2);
        double d6 = this.computeGini(dArray2[1], d3);
        return d4 - d2 / d * d5 - d3 / d * d6;
    }

    protected double computeGini(double[] dArray, double d) {
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i] / d * (dArray[i] / d);
        }
        return 1.0 - d2;
    }

    protected double computeInfoGain(double[] dArray, double[][] dArray2) {
        double d = Utils.sum(dArray);
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = Utils.sum(dArray2[0]);
        double d3 = Utils.sum(dArray2[1]);
        double d4 = this.computeEntropy(dArray, d);
        double d5 = this.computeEntropy(dArray2[0], d2);
        double d6 = this.computeEntropy(dArray2[1], d3);
        return d4 - d2 / d * d5 - d3 / d * d6;
    }

    protected double computeEntropy(double[] dArray, double d) {
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            d2 -= dArray[i] / d * Utils.log2(dArray[i] / d);
        }
        return d2;
    }

    protected void makeLeaf(Instances instances) {
        this.m_Attribute = null;
        this.m_isLeaf = true;
        this.m_ClassValue = Utils.maxIndex(this.m_ClassProbs);
        this.m_ClassAttribute = instances.classAttribute();
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (!this.m_isLeaf) {
            if (instance.isMissing(this.m_Attribute)) {
                double[] dArray = new double[this.m_ClassProbs.length];
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    double[] dArray2 = this.m_Successors[i].distributionForInstance(instance);
                    if (dArray2 == null) continue;
                    for (int j = 0; j < dArray2.length; ++j) {
                        int n = j;
                        dArray[n] = dArray[n] + this.m_Props[i] * dArray2[j];
                    }
                }
                return dArray;
            }
            if (this.m_Attribute.isNominal()) {
                if (this.m_SplitString.indexOf("(" + this.m_Attribute.value((int)instance.value(this.m_Attribute)) + ")") != -1) {
                    return this.m_Successors[0].distributionForInstance(instance);
                }
                return this.m_Successors[1].distributionForInstance(instance);
            }
            if (instance.value(this.m_Attribute) < this.m_SplitValue) {
                return this.m_Successors[0].distributionForInstance(instance);
            }
            return this.m_Successors[1].distributionForInstance(instance);
        }
        return this.m_ClassProbs;
    }

    public String toString() {
        if (this.m_Distribution == null && this.m_Successors == null) {
            return "Best-First: No model built yet.";
        }
        return "Best-First Decision Tree\n" + this.toString(0) + "\n\n" + "Size of the Tree: " + this.numNodes() + "\n\n" + "Number of Leaf Nodes: " + this.numLeaves();
    }

    protected String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Attribute == null) {
            if (Instance.isMissingValue(this.m_ClassValue)) {
                stringBuffer.append(": null");
            } else {
                double d = Math.rint(this.m_Distribution[Utils.maxIndex(this.m_Distribution)] * 100.0) / 100.0;
                double d2 = Math.rint((Utils.sum(this.m_Distribution) - this.m_Distribution[Utils.maxIndex(this.m_Distribution)]) * 100.0) / 100.0;
                String string = "(" + d + "/" + d2 + ")";
                stringBuffer.append(": " + this.m_ClassAttribute.value((int)this.m_ClassValue) + string);
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                stringBuffer.append("\n");
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append("|  ");
                }
                if (i == 0) {
                    if (this.m_Attribute.isNumeric()) {
                        stringBuffer.append(this.m_Attribute.name() + " < " + this.m_SplitValue);
                    } else {
                        stringBuffer.append(this.m_Attribute.name() + "=" + this.m_SplitString);
                    }
                } else if (this.m_Attribute.isNumeric()) {
                    stringBuffer.append(this.m_Attribute.name() + " >= " + this.m_SplitValue);
                } else {
                    stringBuffer.append(this.m_Attribute.name() + "!=" + this.m_SplitString);
                }
                stringBuffer.append(this.m_Successors[i].toString(n + 1));
            }
        }
        return stringBuffer.toString();
    }

    public int numNodes() {
        if (this.m_isLeaf) {
            return 1;
        }
        int n = 1;
        for (int i = 0; i < this.m_Successors.length; ++i) {
            n += this.m_Successors[i].numNodes();
        }
        return n;
    }

    public int numLeaves() {
        if (this.m_isLeaf) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.m_Successors.length; ++i) {
            n += this.m_Successors[i].numLeaves();
        }
        return n;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe pruning strategy.\n\t(default: " + new SelectedTag(1, TAGS_PRUNING) + ")", "P", 1, "-P " + Tag.toOptionList(TAGS_PRUNING)));
        vector.addElement(new Option("\tThe minimal number of instances at the terminal nodes.\n\t(default 2)", "M", 1, "-M <min no>"));
        vector.addElement(new Option("\tThe number of folds used in the pruning.\n\t(default 5)", "N", 5, "-N <num folds>"));
        vector.addElement(new Option("\tDon't use heuristic search for nominal attributes in multi-class\n\tproblem (default yes).\n", "H", 0, "-H"));
        vector.addElement(new Option("\tDon't use Gini index for splitting (default yes),\n\tif not information is used.", "G", 0, "-G"));
        vector.addElement(new Option("\tDon't use error rate in internal cross-validation (default yes), \n\tbut root mean squared error.", "R", 0, "-R"));
        vector.addElement(new Option("\tUse the 1 SE rule to make pruning decision.\n\t(default no).", "A", 0, "-A"));
        vector.addElement(new Option("\tPercentage of training data size (0-1]\n\t(default 1).", "C", 0, "-C"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMinNumObj(Integer.parseInt(string));
        } else {
            this.setMinNumObj(2);
        }
        string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNumFoldsPruning(Integer.parseInt(string));
        } else {
            this.setNumFoldsPruning(5);
        }
        string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setSizePer(Double.parseDouble(string));
        } else {
            this.setSizePer(1.0);
        }
        string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setPruningStrategy(new SelectedTag(string, TAGS_PRUNING));
        } else {
            this.setPruningStrategy(new SelectedTag(1, TAGS_PRUNING));
        }
        this.setHeuristic(!Utils.getFlag('H', stringArray));
        this.setUseGini(!Utils.getFlag('G', stringArray));
        this.setUseErrorRate(!Utils.getFlag('R', stringArray));
        this.setUseOneSE(Utils.getFlag('A', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-M");
        vector.add("" + this.getMinNumObj());
        vector.add("-N");
        vector.add("" + this.getNumFoldsPruning());
        if (!this.getHeuristic()) {
            vector.add("-H");
        }
        if (!this.getUseGini()) {
            vector.add("-G");
        }
        if (!this.getUseErrorRate()) {
            vector.add("-R");
        }
        if (this.getUseOneSE()) {
            vector.add("-A");
        }
        vector.add("-C");
        vector.add("" + this.getSizePer());
        vector.add("-P");
        vector.add("" + this.getPruningStrategy());
        return vector.toArray(new String[vector.size()]);
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("measureTreeSize");
        return vector.elements();
    }

    public double measureTreeSize() {
        return this.numNodes();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        throw new IllegalArgumentException(string + " not supported (Best-First)");
    }

    public String pruningStrategyTipText() {
        return "Sets the pruning strategy.";
    }

    public void setPruningStrategy(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_PRUNING) {
            this.m_PruningStrategy = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getPruningStrategy() {
        return new SelectedTag(this.m_PruningStrategy, TAGS_PRUNING);
    }

    public String minNumObjTipText() {
        return "Set minimal number of instances at the terminal nodes.";
    }

    public void setMinNumObj(int n) {
        this.m_minNumObj = n;
    }

    public int getMinNumObj() {
        return this.m_minNumObj;
    }

    public String numFoldsPruningTipText() {
        return "Number of folds in internal cross-validation.";
    }

    public void setNumFoldsPruning(int n) {
        this.m_numFoldsPruning = n;
    }

    public int getNumFoldsPruning() {
        return this.m_numFoldsPruning;
    }

    public String heuristicTipText() {
        return "If heuristic search is used for binary split for nominal attributes.";
    }

    public void setHeuristic(boolean bl) {
        this.m_Heuristic = bl;
    }

    public boolean getHeuristic() {
        return this.m_Heuristic;
    }

    public String useGiniTipText() {
        return "If true the Gini index is used for splitting criterion, otherwise the information is used.";
    }

    public void setUseGini(boolean bl) {
        this.m_UseGini = bl;
    }

    public boolean getUseGini() {
        return this.m_UseGini;
    }

    public String useErrorRateTipText() {
        return "If error rate is used as error estimate. if not, root mean squared error is used.";
    }

    public void setUseErrorRate(boolean bl) {
        this.m_UseErrorRate = bl;
    }

    public boolean getUseErrorRate() {
        return this.m_UseErrorRate;
    }

    public String useOneSETipText() {
        return "Use the 1SE rule to make pruning decision.";
    }

    public void setUseOneSE(boolean bl) {
        this.m_UseOneSE = bl;
    }

    public boolean getUseOneSE() {
        return this.m_UseOneSE;
    }

    public String sizePerTipText() {
        return "The percentage of the training set size (0-1, 0 not included).";
    }

    public void setSizePer(double d) {
        if (d <= 0.0 || d > 1.0) {
            System.err.println("The percentage of the training set size must be in range 0 to 1 (0 not included) - ignored!");
        } else {
            this.m_SizePer = d;
        }
    }

    public double getSizePer() {
        return this.m_SizePer;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5535 $");
    }

    public static void main(String[] stringArray) {
        BFTree.runClassifier(new BFTree(), stringArray);
    }
}

