/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.ConverterUtils;

public class CSVLoader
extends AbstractFileLoader
implements BatchConverter,
OptionHandler {
    static final long serialVersionUID = 5607529739745491340L;
    public static String FILE_EXTENSION = ".csv";
    protected FastVector m_cumulativeStructure;
    protected FastVector m_cumulativeInstances;
    protected transient BufferedReader m_sourceReader;
    protected StreamTokenizer m_st;
    protected Range m_NominalAttributes = new Range();
    protected Range m_StringAttributes = new Range();
    protected String m_MissingValue = "?";
    protected boolean m_FirstCheck;

    public CSVLoader() {
        this.setRetrieval(0);
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String getFileDescription() {
        return "CSV data files";
    }

    public String[] getFileExtensions() {
        return new String[]{this.getFileExtension()};
    }

    public String globalInfo() {
        return "Reads a source that is in comma separated or tab separated format. Assumes that the first row in the file determines the number of and names of the attributes.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe range of attributes to force type to be NOMINAL.\n\t'first' and 'last' are accepted as well.\n\tExamples: \"first-last\", \"1,4,5-27,50-last\"\n\t(default: -none-)", "N", 1, "-N <range>"));
        vector.addElement(new Option("\tThe range of attribute to force type to be STRING.\n\t'first' and 'last' are accepted as well.\n\tExamples: \"first-last\", \"1,4,5-27,50-last\"\n\t(default: -none-)", "S", 1, "-S <range>"));
        vector.addElement(new Option("\tThe string representing a missing value.\n\t(default: ?)", "M", 1, "-M <str>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNominalAttributes(string);
        } else {
            this.setNominalAttributes("");
        }
        string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setStringAttributes(string);
        } else {
            this.setStringAttributes("");
        }
        string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMissingValue(string);
        } else {
            this.setMissingValue("?");
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getNominalAttributes().length() > 0) {
            vector.add("-N");
            vector.add(this.getNominalAttributes());
        }
        if (this.getStringAttributes().length() > 0) {
            vector.add("-S");
            vector.add(this.getStringAttributes());
        }
        vector.add("-M");
        vector.add(this.getMissingValue());
        return vector.toArray(new String[vector.size()]);
    }

    public void setNominalAttributes(String string) {
        this.m_NominalAttributes.setRanges(string);
    }

    public String getNominalAttributes() {
        return this.m_NominalAttributes.getRanges();
    }

    public String nominalAttributesTipText() {
        return "The range of attributes to force to be of type NOMINAL, example ranges: 'first-last', '1,4,7-14,50-last'.";
    }

    public void setStringAttributes(String string) {
        this.m_StringAttributes.setRanges(string);
    }

    public String getStringAttributes() {
        return this.m_StringAttributes.getRanges();
    }

    public String stringAttributesTipText() {
        return "The range of attributes to force to be of type STRING, example ranges: 'first-last', '1,4,7-14,50-last'.";
    }

    public void setMissingValue(String string) {
        this.m_MissingValue = string;
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The placeholder for missing values, default is '?'.";
    }

    public void setSource(InputStream inputStream) throws IOException {
        this.m_structure = null;
        this.m_sourceFile = null;
        this.m_File = null;
        this.m_FirstCheck = true;
        this.m_sourceReader = new BufferedReader(new InputStreamReader(inputStream));
    }

    public void setSource(File file) throws IOException {
        super.setSource(file);
    }

    public Instances getStructure() throws IOException {
        if (this.m_sourceFile == null && this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            try {
                this.m_st = new StreamTokenizer(this.m_sourceReader);
                this.initTokenizer(this.m_st);
                this.readStructure(this.m_st);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return this.m_structure;
    }

    private void readStructure(StreamTokenizer streamTokenizer) throws IOException {
        this.readHeader(streamTokenizer);
    }

    public Instances getDataSet() throws IOException {
        Object object;
        Object object2;
        Object object3;
        FastVector fastVector;
        if (this.m_sourceFile == null && this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            this.getStructure();
        }
        this.m_st.ordinaryChar(44);
        this.m_st.ordinaryChar(9);
        this.m_cumulativeStructure = new FastVector(this.m_structure.numAttributes());
        for (int i = 0; i < this.m_structure.numAttributes(); ++i) {
            this.m_cumulativeStructure.addElement(new Hashtable());
        }
        this.m_cumulativeInstances = new FastVector();
        while ((fastVector = this.getInstance(this.m_st)) != null) {
            this.m_cumulativeInstances.addElement(fastVector);
        }
        FastVector fastVector2 = new FastVector(this.m_structure.numAttributes());
        for (int i = 0; i < this.m_structure.numAttributes(); ++i) {
            object3 = this.m_structure.attribute(i).name();
            Hashtable hashtable = (Hashtable)this.m_cumulativeStructure.elementAt(i);
            if (hashtable.size() == 0) {
                fastVector2.addElement(new Attribute((String)object3));
                continue;
            }
            if (this.m_StringAttributes.isInRange(i)) {
                fastVector2.addElement(new Attribute((String)object3, (FastVector)null));
                continue;
            }
            object2 = new FastVector(hashtable.size());
            for (int j = 0; j < hashtable.size(); ++j) {
                ((FastVector)object2).addElement("dummy");
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                int n = (Integer)hashtable.get(object);
                String string = object.toString();
                if (string.startsWith("'") || string.startsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                ((FastVector)object2).setElementAt(new String(string), n);
            }
            fastVector2.addElement(new Attribute((String)object3, (FastVector)object2));
        }
        String string = this.m_sourceFile != null ? this.m_sourceFile.getName().replaceAll("\\.[cC][sS][vV]$", "") : "stream";
        object3 = new Instances(string, fastVector2, this.m_cumulativeInstances.size());
        for (int i = 0; i < this.m_cumulativeInstances.size(); ++i) {
            fastVector = (FastVector)this.m_cumulativeInstances.elementAt(i);
            object2 = new double[((Instances)object3).numAttributes()];
            for (int j = 0; j < fastVector.size(); ++j) {
                int n;
                Hashtable hashtable;
                object = fastVector.elementAt(j);
                if (object instanceof String) {
                    if (((String)object).compareTo(this.m_MissingValue) == 0) {
                        object2[j] = Instance.missingValue();
                        continue;
                    }
                    if (((Instances)object3).attribute(j).isString()) {
                        object2[j] = (double)((Instances)object3).attribute(j).addStringValue((String)object);
                        continue;
                    }
                    if (((Instances)object3).attribute(j).isNominal()) {
                        hashtable = (Hashtable)this.m_cumulativeStructure.elementAt(j);
                        n = (Integer)hashtable.get(object);
                        object2[j] = (double)n;
                        continue;
                    }
                    throw new IllegalStateException("Wrong attribute type at position " + (i + 1) + "!!!");
                }
                if (((Instances)object3).attribute(j).isNominal()) {
                    hashtable = (Hashtable)this.m_cumulativeStructure.elementAt(j);
                    n = (Integer)hashtable.get(object);
                    object2[j] = (double)n;
                    continue;
                }
                object2[j] = ((Instances)object3).attribute(j).isString() ? (Object)((Instances)object3).attribute(j).addStringValue("" + object) : (Object)((Double)object);
            }
            ((Instances)object3).add(new Instance(1.0, (double[])object2));
        }
        this.m_structure = new Instances((Instances)object3, 0);
        this.setRetrieval(1);
        this.m_cumulativeStructure = null;
        this.m_sourceReader.close();
        return object3;
    }

    public Instance getNextInstance(Instances instances) throws IOException {
        throw new IOException("CSVLoader can't read data sets incrementally.");
    }

    private FastVector getInstance(StreamTokenizer streamTokenizer) throws IOException {
        FastVector fastVector = new FastVector();
        ConverterUtils.getFirstToken(streamTokenizer);
        if (streamTokenizer.ttype == -1) {
            return null;
        }
        boolean bl = true;
        while (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1) {
            boolean bl2;
            if (!bl) {
                ConverterUtils.getToken(streamTokenizer);
            }
            if (streamTokenizer.ttype == 44 || streamTokenizer.ttype == 9 || streamTokenizer.ttype == 10) {
                fastVector.addElement(this.m_MissingValue);
                bl2 = true;
            } else {
                bl2 = false;
                if (streamTokenizer.sval.equals(this.m_MissingValue)) {
                    fastVector.addElement(new String(this.m_MissingValue));
                } else {
                    try {
                        double d = Double.valueOf(streamTokenizer.sval);
                        fastVector.addElement(new Double(d));
                    }
                    catch (NumberFormatException numberFormatException) {
                        fastVector.addElement(new String(streamTokenizer.sval));
                    }
                }
            }
            if (!bl2) {
                ConverterUtils.getToken(streamTokenizer);
            }
            bl = false;
        }
        if (fastVector.size() != this.m_structure.numAttributes()) {
            ConverterUtils.errms(streamTokenizer, "wrong number of values. Read " + fastVector.size() + ", expected " + this.m_structure.numAttributes());
        }
        try {
            this.checkStructure(fastVector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return fastVector;
    }

    private void checkStructure(FastVector fastVector) throws Exception {
        if (fastVector == null) {
            throw new Exception("current shouldn't be null in checkStructure");
        }
        if (this.m_FirstCheck) {
            this.m_NominalAttributes.setUpper(fastVector.size() - 1);
            this.m_StringAttributes.setUpper(fastVector.size() - 1);
            this.m_FirstCheck = false;
        }
        for (int i = 0; i < fastVector.size(); ++i) {
            int n;
            Hashtable hashtable;
            Object object = fastVector.elementAt(i);
            if (object instanceof String || this.m_NominalAttributes.isInRange(i) || this.m_StringAttributes.isInRange(i)) {
                if (object.toString().compareTo(this.m_MissingValue) == 0 || (hashtable = (Hashtable)this.m_cumulativeStructure.elementAt(i)).containsKey(object)) continue;
                if (hashtable.size() == 0) {
                    for (n = 0; n < this.m_cumulativeInstances.size(); ++n) {
                        FastVector fastVector2 = (FastVector)this.m_cumulativeInstances.elementAt(n);
                        Object object2 = fastVector2.elementAt(i);
                        if (object2 instanceof String || hashtable.containsKey(object2)) continue;
                        hashtable.put(new Double((Double)object2), new Integer(hashtable.size()));
                    }
                }
                n = hashtable.size();
                hashtable.put(object, new Integer(n));
                continue;
            }
            if (object instanceof Double) {
                hashtable = (Hashtable)this.m_cumulativeStructure.elementAt(i);
                if (hashtable.size() == 0 || hashtable.containsKey(object)) continue;
                n = hashtable.size();
                hashtable.put(new Double((Double)object), new Integer(n));
                continue;
            }
            throw new Exception("Wrong object type in checkStructure!");
        }
    }

    private void readHeader(StreamTokenizer streamTokenizer) throws IOException {
        FastVector fastVector = new FastVector();
        ConverterUtils.getFirstToken(streamTokenizer);
        if (streamTokenizer.ttype == -1) {
            ConverterUtils.errms(streamTokenizer, "premature end of file");
        }
        while (streamTokenizer.ttype != 10) {
            fastVector.addElement(new Attribute(streamTokenizer.sval));
            ConverterUtils.getToken(streamTokenizer);
        }
        String string = this.m_sourceFile != null ? this.m_sourceFile.getName().replaceAll("\\.[cC][sS][vV]$", "") : "stream";
        this.m_structure = new Instances(string, fastVector, 0);
    }

    private void initTokenizer(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 31);
        streamTokenizer.wordChars(32, 255);
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.whitespaceChars(9, 9);
        streamTokenizer.commentChar(37);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        streamTokenizer.eolIsSignificant(true);
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.m_st = null;
        this.setRetrieval(0);
        if (this.m_File != null) {
            this.setFile(new File(this.m_File));
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5151 $");
    }

    public static void main(String[] stringArray) {
        CSVLoader.runFileLoader(new CSVLoader(), stringArray);
    }
}

