/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.pmml.DerivedFieldMetaInfo;
import weka.core.pmml.MiningFieldMetaInfo;
import weka.core.pmml.TargetMetaInfo;
import weka.core.pmml.TransformationDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiningSchema
implements Serializable {
    private static final long serialVersionUID = 7144380586726330455L;
    protected Instances m_fieldInstancesStructure;
    protected Instances m_miningSchemaInstancesStructure;
    protected ArrayList<MiningFieldMetaInfo> m_miningMeta = new ArrayList();
    protected ArrayList<DerivedFieldMetaInfo> m_derivedMeta = new ArrayList();
    protected TransformationDictionary m_transformationDictionary = null;
    protected TargetMetaInfo m_targetMetaInfo = null;

    private void getLocalTransformations(Element element) throws Exception {
        NodeList nodeList = element.getElementsByTagName("LocalTransformations");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            for (int i = 0; i < this.m_miningSchemaInstancesStructure.numAttributes(); ++i) {
                arrayList.add(this.m_miningSchemaInstancesStructure.attribute(i));
            }
            NodeList nodeList2 = element2.getElementsByTagName("DerivedField");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                if (node.getNodeType() != 1) continue;
                DerivedFieldMetaInfo derivedFieldMetaInfo = new DerivedFieldMetaInfo((Element)node, arrayList, this.m_transformationDictionary);
                this.m_derivedMeta.add(derivedFieldMetaInfo);
            }
        }
    }

    public MiningSchema(Element element, Instances instances, TransformationDictionary transformationDictionary) throws Exception {
        NodeList nodeList;
        ArrayList<DerivedFieldMetaInfo> arrayList;
        Attribute attribute;
        Serializable serializable;
        FastVector fastVector = new FastVector();
        NodeList nodeList2 = element.getElementsByTagName("MiningField");
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Element element2;
            Node object22 = nodeList2.item(i);
            if (object22.getNodeType() != 1 || ((MiningFieldMetaInfo)(serializable = new MiningFieldMetaInfo(element2 = (Element)object22))).getUsageType() != MiningFieldMetaInfo.Usage.ACTIVE && ((MiningFieldMetaInfo)serializable).getUsageType() != MiningFieldMetaInfo.Usage.PREDICTED) continue;
            attribute = instances.attribute(((MiningFieldMetaInfo)serializable).getName());
            if (attribute != null) {
                ((MiningFieldMetaInfo)serializable).setIndex(n2);
                fastVector.addElement(attribute);
                ++n2;
                if (((MiningFieldMetaInfo)serializable).getUsageType() == MiningFieldMetaInfo.Usage.PREDICTED) {
                    n = n2 - 1;
                }
                this.m_miningMeta.add((MiningFieldMetaInfo)serializable);
                continue;
            }
            throw new Exception("Can't find mining field: " + ((MiningFieldMetaInfo)serializable).getName() + " in the data dictionary.");
        }
        this.m_miningSchemaInstancesStructure = new Instances("miningSchema", fastVector, 0);
        for (MiningFieldMetaInfo miningFieldMetaInfo : this.m_miningMeta) {
            miningFieldMetaInfo.setMiningSchemaInstances(this.m_miningSchemaInstancesStructure);
        }
        this.m_transformationDictionary = transformationDictionary;
        if (this.m_transformationDictionary != null) {
            this.m_transformationDictionary.setFieldDefsForDerivedFields(this.m_miningSchemaInstancesStructure);
            arrayList = transformationDictionary.getDerivedFields();
            this.m_derivedMeta.addAll(arrayList);
        }
        this.getLocalTransformations(element);
        arrayList = new FastVector();
        for (MiningFieldMetaInfo miningFieldMetaInfo : this.m_miningMeta) {
            ((FastVector)((Object)arrayList)).addElement(miningFieldMetaInfo.getFieldAsAttribute());
        }
        for (DerivedFieldMetaInfo derivedFieldMetaInfo : this.m_derivedMeta) {
            ((FastVector)((Object)arrayList)).addElement(derivedFieldMetaInfo.getFieldAsAttribute());
        }
        this.m_fieldInstancesStructure = new Instances("FieldStructure", (FastVector)((Object)arrayList), 0);
        if (n != -1) {
            this.m_fieldInstancesStructure.setClassIndex(n);
            this.m_miningSchemaInstancesStructure.setClassIndex(n);
        }
        if ((nodeList = element.getElementsByTagName("Targets")).getLength() > 0) {
            if (nodeList.getLength() > 1) {
                throw new Exception("[MiningSchema] Can only handle a single Target");
            }
            Node node = nodeList.item(0);
            if (node.getNodeType() == 1) {
                this.m_targetMetaInfo = new TargetMetaInfo((Element)node);
                if (this.m_fieldInstancesStructure.classIndex() >= 0 && this.m_fieldInstancesStructure.classAttribute().isString() && ((ArrayList)(serializable = this.m_targetMetaInfo.getValues())).size() > 0) {
                    attribute = this.m_fieldInstancesStructure.classAttribute();
                    for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                        attribute.addStringValue((String)((ArrayList)serializable).get(i));
                    }
                }
            }
        }
    }

    public void applyMissingValuesTreatment(double[] dArray) throws Exception {
        for (int i = 0; i < this.m_miningMeta.size(); ++i) {
            MiningFieldMetaInfo miningFieldMetaInfo = this.m_miningMeta.get(i);
            dArray[i] = miningFieldMetaInfo.applyMissingValueTreatment(dArray[i]);
        }
    }

    public void applyOutlierTreatment(double[] dArray) throws Exception {
        for (int i = 0; i < this.m_miningMeta.size(); ++i) {
            MiningFieldMetaInfo miningFieldMetaInfo = this.m_miningMeta.get(i);
            dArray[i] = miningFieldMetaInfo.applyOutlierTreatment(dArray[i]);
        }
    }

    public void applyMissingAndOutlierTreatments(double[] dArray) throws Exception {
        for (int i = 0; i < this.m_miningMeta.size(); ++i) {
            MiningFieldMetaInfo miningFieldMetaInfo = this.m_miningMeta.get(i);
            dArray[i] = miningFieldMetaInfo.applyMissingValueTreatment(dArray[i]);
            dArray[i] = miningFieldMetaInfo.applyOutlierTreatment(dArray[i]);
        }
    }

    public Instances getFieldsAsInstances() {
        return this.m_fieldInstancesStructure;
    }

    public Instances getMiningSchemaAsInstances() {
        return this.m_miningSchemaInstancesStructure;
    }

    public TransformationDictionary getTransformationDictionary() {
        return this.m_transformationDictionary;
    }

    public boolean hasTargetMetaData() {
        return this.m_targetMetaInfo != null;
    }

    public TargetMetaInfo getTargetMetaData() {
        return this.m_targetMetaInfo;
    }

    public void convertStringAttsToNominal() {
        Instances instances = this.getFieldsAsInstances();
        if (instances.checkForStringAttributes()) {
            FastVector fastVector = new FastVector();
            for (int i = 0; i < instances.numAttributes(); ++i) {
                Attribute attribute = instances.attribute(i);
                if (attribute.isString()) {
                    FastVector fastVector2 = new FastVector();
                    for (int j = 0; j < attribute.numValues(); ++j) {
                        fastVector2.addElement(attribute.value(j));
                    }
                    Attribute attribute2 = new Attribute(attribute.name(), fastVector2);
                    fastVector.addElement(attribute2);
                    continue;
                }
                fastVector.addElement(attribute);
            }
            Instances instances2 = new Instances("miningSchema", fastVector, 0);
            if (this.m_fieldInstancesStructure.classIndex() >= 0) {
                instances2.setClassIndex(this.m_fieldInstancesStructure.classIndex());
            }
            this.m_fieldInstancesStructure = instances2;
        }
    }

    public void convertNumericAttToNominal(int n, ArrayList<String> arrayList) {
        Instances instances = this.getFieldsAsInstances();
        if (instances.attribute(n).isNominal()) {
            throw new IllegalArgumentException("[MiningSchema] convertNumericAttToNominal: attribute is already nominal!");
        }
        FastVector fastVector = new FastVector();
        for (int i = 0; i < arrayList.size(); ++i) {
            fastVector.addElement(arrayList.get(i));
        }
        FastVector fastVector2 = new FastVector();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            Attribute attribute = instances.attribute(i);
            if (i == n) {
                Attribute attribute2 = new Attribute(attribute.name(), fastVector);
                fastVector2.addElement(attribute2);
                continue;
            }
            fastVector2.addElement(attribute);
        }
        Instances instances2 = new Instances("miningSchema", fastVector2, 0);
        if (this.m_fieldInstancesStructure.classIndex() >= 0) {
            instances2.setClassIndex(this.m_fieldInstancesStructure.classIndex());
        }
        this.m_fieldInstancesStructure = instances2;
    }

    public ArrayList<DerivedFieldMetaInfo> getDerivedFields() {
        return this.m_derivedMeta;
    }

    public ArrayList<MiningFieldMetaInfo> getMiningFields() {
        return this.m_miningMeta;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_transformationDictionary != null) {
            stringBuffer.append(this.m_transformationDictionary);
        }
        stringBuffer.append("Mining schema:\n\n");
        for (MiningFieldMetaInfo fieldMetaInfo : this.m_miningMeta) {
            stringBuffer.append(fieldMetaInfo + "\n");
        }
        if (this.m_derivedMeta.size() > 0) {
            stringBuffer.append("\nDerived fields:\n\n");
            for (DerivedFieldMetaInfo derivedFieldMetaInfo : this.m_derivedMeta) {
                stringBuffer.append(derivedFieldMetaInfo + "\n");
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

